/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.crypto;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import lombok.NonNull;

public final class Sha256 {
    private static final String SHA_256 = "SHA-256";

    public static byte[] calculate(@NonNull String data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return Sha256.calculate(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] calculate(byte @NonNull [] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        MessageDigest digest = MessageDigest.getInstance(SHA_256);
        digest.update(data);
        return digest.digest();
    }

    private Sha256() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

