/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.button.base;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.button.base.ButtonBody;
import it.auties.whatsapp.model.button.base.ButtonBodyType;
import it.auties.whatsapp.model.button.base.ButtonText;
import it.auties.whatsapp.model.info.NativeFlowInfo;
import it.auties.whatsapp.util.BytesHelper;
import java.nio.charset.StandardCharsets;
import java.util.HexFormat;
import lombok.NonNull;

@JsonDeserialize(builder=ButtonBuilder.class)
public final class Button
implements ProtobufMessage {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    private String id;
    @ProtobufProperty(index=2, type=ProtobufType.MESSAGE, implementation=ButtonText.class)
    private ButtonText bodyText;
    @ProtobufProperty(index=4, type=ProtobufType.MESSAGE, implementation=NativeFlowInfo.class)
    private NativeFlowInfo bodyNativeFlow;
    @ProtobufProperty(index=3, type=ProtobufType.MESSAGE, implementation=ButtonBodyType.class)
    private ButtonBodyType bodyType;

    public static Button of(@NonNull ButtonBody body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        String id = HexFormat.of().formatHex(BytesHelper.random(6));
        return Button.of(id, body);
    }

    public static Button of(@NonNull String id, ButtonBody body) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        ButtonBuilder builder = Button.builder().id(id);
        if (body instanceof ButtonText) {
            ButtonText buttonText = (ButtonText)body;
            builder.bodyText(buttonText).bodyType(ButtonBodyType.TEXT);
        } else if (body instanceof NativeFlowInfo) {
            NativeFlowInfo flowInfo = (NativeFlowInfo)body;
            builder.bodyNativeFlow(flowInfo).bodyType(ButtonBodyType.NATIVE_FLOW);
        }
        return builder.build();
    }

    public static ButtonBuilder builder() {
        return new ButtonBuilder();
    }

    public Button(String id, ButtonText bodyText, NativeFlowInfo bodyNativeFlow, ButtonBodyType bodyType) {
        this.id = id;
        this.bodyText = bodyText;
        this.bodyNativeFlow = bodyNativeFlow;
        this.bodyType = bodyType;
    }

    public String id() {
        return this.id;
    }

    public ButtonText bodyText() {
        return this.bodyText;
    }

    public NativeFlowInfo bodyNativeFlow() {
        return this.bodyNativeFlow;
    }

    public ButtonBodyType bodyType() {
        return this.bodyType;
    }

    public Button id(String id) {
        this.id = id;
        return this;
    }

    public Button bodyText(ButtonText bodyText) {
        this.bodyText = bodyText;
        return this;
    }

    public Button bodyNativeFlow(NativeFlowInfo bodyNativeFlow) {
        this.bodyNativeFlow = bodyNativeFlow;
        return this;
    }

    public Button bodyType(ButtonBodyType bodyType) {
        this.bodyType = bodyType;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Button)) {
            return false;
        }
        Button other = (Button)o;
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        ButtonText this$bodyText = this.bodyText();
        ButtonText other$bodyText = other.bodyText();
        if (this$bodyText == null ? other$bodyText != null : !((Object)this$bodyText).equals(other$bodyText)) {
            return false;
        }
        NativeFlowInfo this$bodyNativeFlow = this.bodyNativeFlow();
        NativeFlowInfo other$bodyNativeFlow = other.bodyNativeFlow();
        if (this$bodyNativeFlow == null ? other$bodyNativeFlow != null : !((Object)this$bodyNativeFlow).equals(other$bodyNativeFlow)) {
            return false;
        }
        ButtonBodyType this$bodyType = this.bodyType();
        ButtonBodyType other$bodyType = other.bodyType();
        return !(this$bodyType == null ? other$bodyType != null : !((Object)((Object)this$bodyType)).equals((Object)other$bodyType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        ButtonText $bodyText = this.bodyText();
        result = result * 59 + ($bodyText == null ? 43 : ((Object)$bodyText).hashCode());
        NativeFlowInfo $bodyNativeFlow = this.bodyNativeFlow();
        result = result * 59 + ($bodyNativeFlow == null ? 43 : ((Object)$bodyNativeFlow).hashCode());
        ButtonBodyType $bodyType = this.bodyType();
        result = result * 59 + ($bodyType == null ? 43 : ((Object)((Object)$bodyType)).hashCode());
        return result;
    }

    public String toString() {
        return "Button(id=" + this.id() + ", bodyText=" + this.bodyText() + ", bodyNativeFlow=" + this.bodyNativeFlow() + ", bodyType=" + this.bodyType() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.bodyText != null) {
            protobufOutputStream.writeBytes(2, this.bodyText.toEncodedProtobuf());
        }
        if (this.bodyType != null) {
            protobufOutputStream.writeUInt32(3, this.bodyType.index());
        }
        if (this.id != null) {
            protobufOutputStream.writeString(1, this.id);
        }
        if (this.bodyNativeFlow != null) {
            protobufOutputStream.writeBytes(4, this.bodyNativeFlow.toEncodedProtobuf());
        }
        return protobufOutputStream.toByteArray();
    }

    public static Button ofProtobuf(byte[] byArray) {
        int n;
        ButtonBuilder buttonBuilder = Button.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block6: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 2: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    buttonBuilder.bodyText(ButtonText.ofProtobuf(protobufInputStream.readBytes()));
                    continue block6;
                }
                case 3: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    buttonBuilder.bodyType(ButtonBodyType.of(protobufInputStream.readInt32()));
                    continue block6;
                }
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    buttonBuilder.id(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block6;
                }
                case 4: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    buttonBuilder.bodyNativeFlow(NativeFlowInfo.ofProtobuf(protobufInputStream.readBytes()));
                    continue block6;
                }
            }
            protobufInputStream.readBytes();
        }
        return buttonBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ButtonBuilder {
        private String id;
        private ButtonText bodyText;
        private NativeFlowInfo bodyNativeFlow;
        private ButtonBodyType bodyType;

        ButtonBuilder() {
        }

        public ButtonBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ButtonBuilder bodyText(ButtonText bodyText) {
            this.bodyText = bodyText;
            return this;
        }

        public ButtonBuilder bodyNativeFlow(NativeFlowInfo bodyNativeFlow) {
            this.bodyNativeFlow = bodyNativeFlow;
            return this;
        }

        public ButtonBuilder bodyType(ButtonBodyType bodyType) {
            this.bodyType = bodyType;
            return this;
        }

        public Button build() {
            return new Button(this.id, this.bodyText, this.bodyNativeFlow, this.bodyType);
        }

        public String toString() {
            return "Button.ButtonBuilder(id=" + this.id + ", bodyText=" + this.bodyText + ", bodyNativeFlow=" + this.bodyNativeFlow + ", bodyType=" + this.bodyType + ")";
        }
    }
}

