/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.button.template.hydrated;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufName;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.button.template.TemplateFormatter;
import it.auties.whatsapp.model.button.template.hydrated.HydratedFourRowTemplateTitle;
import it.auties.whatsapp.model.button.template.hydrated.HydratedFourRowTemplateTitleType;
import it.auties.whatsapp.model.button.template.hydrated.HydratedTemplateButton;
import it.auties.whatsapp.model.message.button.TemplateFormatterType;
import it.auties.whatsapp.model.message.standard.DocumentMessage;
import it.auties.whatsapp.model.message.standard.ImageMessage;
import it.auties.whatsapp.model.message.standard.LocationMessage;
import it.auties.whatsapp.model.message.standard.TextMessage;
import it.auties.whatsapp.model.message.standard.VideoMessage;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;

@ProtobufName(value="TemplateMessage.HydratedFourRowTemplate")
@JsonDeserialize(builder=HydratedFourRowTemplateBuilder.class)
public final class HydratedFourRowTemplate
implements TemplateFormatter {
    @ProtobufProperty(index=9, type=ProtobufType.STRING)
    private String templateId;
    @ProtobufProperty(index=1, type=ProtobufType.MESSAGE, implementation=DocumentMessage.class)
    private DocumentMessage titleDocument;
    @ProtobufProperty(index=2, type=ProtobufType.STRING)
    private String titleText;
    @ProtobufProperty(index=3, type=ProtobufType.MESSAGE, implementation=ImageMessage.class)
    private ImageMessage titleImage;
    @ProtobufProperty(index=4, type=ProtobufType.MESSAGE, implementation=VideoMessage.class)
    private VideoMessage titleVideo;
    @ProtobufProperty(index=5, type=ProtobufType.MESSAGE, implementation=LocationMessage.class)
    private LocationMessage titleLocation;
    @ProtobufProperty(index=6, type=ProtobufType.STRING)
    private String body;
    @ProtobufProperty(index=7, type=ProtobufType.STRING)
    private String footer;
    @ProtobufProperty(index=8, type=ProtobufType.MESSAGE, implementation=HydratedTemplateButton.class, repeated=true)
    private List<HydratedTemplateButton> hydratedButtons;

    private static HydratedFourRowTemplate customBuilder(HydratedFourRowTemplateTitle title, String body, String footer, List<HydratedTemplateButton> buttons, String id) {
        IntStream.range(0, buttons.size()).forEach(index -> ((HydratedTemplateButton)buttons.get(index)).index(index + 1));
        HydratedFourRowTemplateBuilder builder = HydratedFourRowTemplate.builder().body(body).footer(footer).hydratedButtons(buttons).templateId(id);
        if (title instanceof DocumentMessage) {
            DocumentMessage documentMessage = (DocumentMessage)title;
            builder.titleDocument(documentMessage);
        } else if (title instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)title;
            builder.titleText(textMessage.text());
        } else if (title instanceof ImageMessage) {
            ImageMessage imageMessage = (ImageMessage)title;
            builder.titleImage(imageMessage);
        } else if (title instanceof VideoMessage) {
            VideoMessage videoMessage = (VideoMessage)title;
            builder.titleVideo(videoMessage);
        } else if (title instanceof LocationMessage) {
            LocationMessage locationMessage = (LocationMessage)title;
            builder.titleLocation(locationMessage);
        }
        return builder.build();
    }

    public HydratedFourRowTemplateTitleType titleType() {
        return this.title().map(HydratedFourRowTemplateTitle::hydratedTitleType).orElse(HydratedFourRowTemplateTitleType.NONE);
    }

    public Optional<HydratedFourRowTemplateTitle> title() {
        if (this.titleDocument != null) {
            return Optional.of(this.titleDocument);
        }
        if (this.titleText != null) {
            return Optional.of(TextMessage.of(this.titleText));
        }
        if (this.titleImage != null) {
            return Optional.of(this.titleImage);
        }
        if (this.titleVideo != null) {
            return Optional.of(this.titleVideo);
        }
        if (this.titleLocation != null) {
            return Optional.of(this.titleLocation);
        }
        return Optional.empty();
    }

    public Optional<DocumentMessage> titleDocument() {
        return Optional.ofNullable(this.titleDocument);
    }

    public Optional<String> titleText() {
        return Optional.ofNullable(this.titleText);
    }

    public Optional<ImageMessage> titleImage() {
        return Optional.ofNullable(this.titleImage);
    }

    public Optional<VideoMessage> titleVideo() {
        return Optional.ofNullable(this.titleVideo);
    }

    public Optional<LocationMessage> titleLocation() {
        return Optional.ofNullable(this.titleLocation);
    }

    @Override
    public TemplateFormatterType templateType() {
        return TemplateFormatterType.HYDRATED_FOUR_ROW;
    }

    public static HydratedFourRowTemplateBuilder builder() {
        return new HydratedFourRowTemplateBuilder();
    }

    public static HydratedFourRowTemplateSimpleBuilder simpleBuilder() {
        return new HydratedFourRowTemplateSimpleBuilder();
    }

    public HydratedFourRowTemplate(String templateId, DocumentMessage titleDocument, String titleText, ImageMessage titleImage, VideoMessage titleVideo, LocationMessage titleLocation, String body, String footer, List<HydratedTemplateButton> hydratedButtons) {
        this.templateId = templateId;
        this.titleDocument = titleDocument;
        this.titleText = titleText;
        this.titleImage = titleImage;
        this.titleVideo = titleVideo;
        this.titleLocation = titleLocation;
        this.body = body;
        this.footer = footer;
        this.hydratedButtons = hydratedButtons;
    }

    private HydratedFourRowTemplate() {
    }

    public static HydratedFourRowTemplate of() {
        return new HydratedFourRowTemplate();
    }

    public String templateId() {
        return this.templateId;
    }

    public String body() {
        return this.body;
    }

    public String footer() {
        return this.footer;
    }

    public List<HydratedTemplateButton> hydratedButtons() {
        return this.hydratedButtons;
    }

    public HydratedFourRowTemplate templateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    public HydratedFourRowTemplate titleDocument(DocumentMessage titleDocument) {
        this.titleDocument = titleDocument;
        return this;
    }

    public HydratedFourRowTemplate titleText(String titleText) {
        this.titleText = titleText;
        return this;
    }

    public HydratedFourRowTemplate titleImage(ImageMessage titleImage) {
        this.titleImage = titleImage;
        return this;
    }

    public HydratedFourRowTemplate titleVideo(VideoMessage titleVideo) {
        this.titleVideo = titleVideo;
        return this;
    }

    public HydratedFourRowTemplate titleLocation(LocationMessage titleLocation) {
        this.titleLocation = titleLocation;
        return this;
    }

    public HydratedFourRowTemplate body(String body) {
        this.body = body;
        return this;
    }

    public HydratedFourRowTemplate footer(String footer) {
        this.footer = footer;
        return this;
    }

    public HydratedFourRowTemplate hydratedButtons(List<HydratedTemplateButton> hydratedButtons) {
        this.hydratedButtons = hydratedButtons;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HydratedFourRowTemplate)) {
            return false;
        }
        HydratedFourRowTemplate other = (HydratedFourRowTemplate)o;
        String this$templateId = this.templateId();
        String other$templateId = other.templateId();
        if (this$templateId == null ? other$templateId != null : !this$templateId.equals(other$templateId)) {
            return false;
        }
        Optional<DocumentMessage> this$titleDocument = this.titleDocument();
        Optional<DocumentMessage> other$titleDocument = other.titleDocument();
        if (this$titleDocument == null ? other$titleDocument != null : !((Object)this$titleDocument).equals(other$titleDocument)) {
            return false;
        }
        Optional<String> this$titleText = this.titleText();
        Optional<String> other$titleText = other.titleText();
        if (this$titleText == null ? other$titleText != null : !((Object)this$titleText).equals(other$titleText)) {
            return false;
        }
        Optional<ImageMessage> this$titleImage = this.titleImage();
        Optional<ImageMessage> other$titleImage = other.titleImage();
        if (this$titleImage == null ? other$titleImage != null : !((Object)this$titleImage).equals(other$titleImage)) {
            return false;
        }
        Optional<VideoMessage> this$titleVideo = this.titleVideo();
        Optional<VideoMessage> other$titleVideo = other.titleVideo();
        if (this$titleVideo == null ? other$titleVideo != null : !((Object)this$titleVideo).equals(other$titleVideo)) {
            return false;
        }
        Optional<LocationMessage> this$titleLocation = this.titleLocation();
        Optional<LocationMessage> other$titleLocation = other.titleLocation();
        if (this$titleLocation == null ? other$titleLocation != null : !((Object)this$titleLocation).equals(other$titleLocation)) {
            return false;
        }
        String this$body = this.body();
        String other$body = other.body();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        String this$footer = this.footer();
        String other$footer = other.footer();
        if (this$footer == null ? other$footer != null : !this$footer.equals(other$footer)) {
            return false;
        }
        List<HydratedTemplateButton> this$hydratedButtons = this.hydratedButtons();
        List<HydratedTemplateButton> other$hydratedButtons = other.hydratedButtons();
        return !(this$hydratedButtons == null ? other$hydratedButtons != null : !((Object)this$hydratedButtons).equals(other$hydratedButtons));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $templateId = this.templateId();
        result = result * 59 + ($templateId == null ? 43 : $templateId.hashCode());
        Optional<DocumentMessage> $titleDocument = this.titleDocument();
        result = result * 59 + ($titleDocument == null ? 43 : ((Object)$titleDocument).hashCode());
        Optional<String> $titleText = this.titleText();
        result = result * 59 + ($titleText == null ? 43 : ((Object)$titleText).hashCode());
        Optional<ImageMessage> $titleImage = this.titleImage();
        result = result * 59 + ($titleImage == null ? 43 : ((Object)$titleImage).hashCode());
        Optional<VideoMessage> $titleVideo = this.titleVideo();
        result = result * 59 + ($titleVideo == null ? 43 : ((Object)$titleVideo).hashCode());
        Optional<LocationMessage> $titleLocation = this.titleLocation();
        result = result * 59 + ($titleLocation == null ? 43 : ((Object)$titleLocation).hashCode());
        String $body = this.body();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        String $footer = this.footer();
        result = result * 59 + ($footer == null ? 43 : $footer.hashCode());
        List<HydratedTemplateButton> $hydratedButtons = this.hydratedButtons();
        result = result * 59 + ($hydratedButtons == null ? 43 : ((Object)$hydratedButtons).hashCode());
        return result;
    }

    public String toString() {
        return "HydratedFourRowTemplate(templateId=" + this.templateId() + ", titleDocument=" + this.titleDocument() + ", titleText=" + this.titleText() + ", titleImage=" + this.titleImage() + ", titleVideo=" + this.titleVideo() + ", titleLocation=" + this.titleLocation() + ", body=" + this.body() + ", footer=" + this.footer() + ", hydratedButtons=" + this.hydratedButtons() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.body != null) {
            protobufOutputStream.writeString(6, this.body);
        }
        if (this.titleImage != null) {
            protobufOutputStream.writeBytes(3, this.titleImage.toEncodedProtobuf());
        }
        if (this.titleText != null) {
            protobufOutputStream.writeString(2, this.titleText);
        }
        if (this.titleDocument != null) {
            protobufOutputStream.writeBytes(1, this.titleDocument.toEncodedProtobuf());
        }
        if (this.titleLocation != null) {
            protobufOutputStream.writeBytes(5, this.titleLocation.toEncodedProtobuf());
        }
        if (this.titleVideo != null) {
            protobufOutputStream.writeBytes(4, this.titleVideo.toEncodedProtobuf());
        }
        if (this.hydratedButtons != null) {
            for (HydratedTemplateButton hydratedTemplateButton : this.hydratedButtons) {
                protobufOutputStream.writeBytes(8, hydratedTemplateButton.toEncodedProtobuf());
            }
        }
        if (this.templateId != null) {
            protobufOutputStream.writeString(9, this.templateId);
        }
        if (this.footer != null) {
            protobufOutputStream.writeString(7, this.footer);
        }
        return protobufOutputStream.toByteArray();
    }

    public static HydratedFourRowTemplate ofProtobuf(byte[] byArray) {
        int n;
        HydratedFourRowTemplateBuilder hydratedFourRowTemplateBuilder = HydratedFourRowTemplate.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        ArrayList<HydratedTemplateButton> arrayList = new ArrayList<HydratedTemplateButton>();
        block11: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 6: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    hydratedFourRowTemplateBuilder.body(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block11;
                }
                case 3: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    hydratedFourRowTemplateBuilder.titleImage(ImageMessage.ofProtobuf(protobufInputStream.readBytes()));
                    continue block11;
                }
                case 2: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    hydratedFourRowTemplateBuilder.titleText(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block11;
                }
                case 1: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    hydratedFourRowTemplateBuilder.titleDocument(DocumentMessage.ofProtobuf(protobufInputStream.readBytes()));
                    continue block11;
                }
                case 5: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    hydratedFourRowTemplateBuilder.titleLocation(LocationMessage.ofProtobuf(protobufInputStream.readBytes()));
                    continue block11;
                }
                case 4: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    hydratedFourRowTemplateBuilder.titleVideo(VideoMessage.ofProtobuf(protobufInputStream.readBytes()));
                    continue block11;
                }
                case 8: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    arrayList.add(HydratedTemplateButton.ofProtobuf(protobufInputStream.readBytes()));
                    continue block11;
                }
                case 9: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    hydratedFourRowTemplateBuilder.templateId(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block11;
                }
                case 7: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    hydratedFourRowTemplateBuilder.footer(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block11;
                }
            }
            protobufInputStream.readBytes();
        }
        hydratedFourRowTemplateBuilder.hydratedButtons(arrayList);
        return hydratedFourRowTemplateBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class HydratedFourRowTemplateBuilder {
        private String templateId;
        private DocumentMessage titleDocument;
        private String titleText;
        private ImageMessage titleImage;
        private VideoMessage titleVideo;
        private LocationMessage titleLocation;
        private String body;
        private String footer;
        private List<HydratedTemplateButton> hydratedButtons;

        HydratedFourRowTemplateBuilder() {
        }

        public HydratedFourRowTemplateBuilder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public HydratedFourRowTemplateBuilder titleDocument(DocumentMessage titleDocument) {
            this.titleDocument = titleDocument;
            return this;
        }

        public HydratedFourRowTemplateBuilder titleText(String titleText) {
            this.titleText = titleText;
            return this;
        }

        public HydratedFourRowTemplateBuilder titleImage(ImageMessage titleImage) {
            this.titleImage = titleImage;
            return this;
        }

        public HydratedFourRowTemplateBuilder titleVideo(VideoMessage titleVideo) {
            this.titleVideo = titleVideo;
            return this;
        }

        public HydratedFourRowTemplateBuilder titleLocation(LocationMessage titleLocation) {
            this.titleLocation = titleLocation;
            return this;
        }

        public HydratedFourRowTemplateBuilder body(String body) {
            this.body = body;
            return this;
        }

        public HydratedFourRowTemplateBuilder footer(String footer) {
            this.footer = footer;
            return this;
        }

        public HydratedFourRowTemplateBuilder hydratedButtons(List<HydratedTemplateButton> hydratedButtons) {
            this.hydratedButtons = hydratedButtons;
            return this;
        }

        public HydratedFourRowTemplate build() {
            return new HydratedFourRowTemplate(this.templateId, this.titleDocument, this.titleText, this.titleImage, this.titleVideo, this.titleLocation, this.body, this.footer, this.hydratedButtons);
        }

        public String toString() {
            return "HydratedFourRowTemplate.HydratedFourRowTemplateBuilder(templateId=" + this.templateId + ", titleDocument=" + this.titleDocument + ", titleText=" + this.titleText + ", titleImage=" + this.titleImage + ", titleVideo=" + this.titleVideo + ", titleLocation=" + this.titleLocation + ", body=" + this.body + ", footer=" + this.footer + ", hydratedButtons=" + this.hydratedButtons + ")";
        }
    }

    public static class HydratedFourRowTemplateSimpleBuilder {
        private HydratedFourRowTemplateTitle title;
        private String body;
        private String footer;
        private List<HydratedTemplateButton> buttons;
        private String id;

        HydratedFourRowTemplateSimpleBuilder() {
        }

        public HydratedFourRowTemplateSimpleBuilder title(HydratedFourRowTemplateTitle title) {
            this.title = title;
            return this;
        }

        public HydratedFourRowTemplateSimpleBuilder body(String body) {
            this.body = body;
            return this;
        }

        public HydratedFourRowTemplateSimpleBuilder footer(String footer) {
            this.footer = footer;
            return this;
        }

        public HydratedFourRowTemplateSimpleBuilder buttons(List<HydratedTemplateButton> buttons) {
            this.buttons = buttons;
            return this;
        }

        public HydratedFourRowTemplateSimpleBuilder id(String id) {
            this.id = id;
            return this;
        }

        public HydratedFourRowTemplate build() {
            return HydratedFourRowTemplate.customBuilder(this.title, this.body, this.footer, this.buttons, this.id);
        }

        public String toString() {
            return "HydratedFourRowTemplate.HydratedFourRowTemplateSimpleBuilder(title=" + this.title + ", body=" + this.body + ", footer=" + this.footer + ", buttons=" + this.buttons + ", id=" + this.id + ")";
        }
    }
}

