/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.button.template.hydrated;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.button.template.hydrated.HydratedButton;
import it.auties.whatsapp.model.button.template.hydrated.HydratedButtonType;
import it.auties.whatsapp.model.button.template.hydrated.HydratedCallButton;
import it.auties.whatsapp.model.button.template.hydrated.HydratedQuickReplyButton;
import it.auties.whatsapp.model.button.template.hydrated.HydratedURLButton;
import java.util.Optional;

@JsonDeserialize(builder=HydratedTemplateButtonBuilder.class)
public final class HydratedTemplateButton
implements ProtobufMessage {
    @ProtobufProperty(index=1, type=ProtobufType.MESSAGE, implementation=HydratedQuickReplyButton.class)
    private HydratedQuickReplyButton quickReplyButton;
    @ProtobufProperty(index=2, type=ProtobufType.MESSAGE, implementation=HydratedURLButton.class)
    private HydratedURLButton urlButton;
    @ProtobufProperty(index=3, type=ProtobufType.MESSAGE, implementation=HydratedCallButton.class)
    private HydratedCallButton callButton;
    @ProtobufProperty(index=4, type=ProtobufType.UINT32)
    private int index;

    public static HydratedTemplateButton of(HydratedButton button) {
        HydratedTemplateButtonBuilder builder = HydratedTemplateButton.builder();
        if (button instanceof HydratedQuickReplyButton) {
            HydratedQuickReplyButton hydratedQuickReplyButton = (HydratedQuickReplyButton)button;
            builder.quickReplyButton(hydratedQuickReplyButton);
        } else if (button instanceof HydratedURLButton) {
            HydratedURLButton hydratedURLButton = (HydratedURLButton)button;
            builder.urlButton(hydratedURLButton);
        } else if (button instanceof HydratedCallButton) {
            HydratedCallButton hydratedCallButton = (HydratedCallButton)button;
            builder.callButton(hydratedCallButton);
        }
        return builder.build();
    }

    public Optional<HydratedButton> button() {
        if (this.quickReplyButton != null) {
            return Optional.of(this.quickReplyButton);
        }
        if (this.urlButton != null) {
            return Optional.of(this.urlButton);
        }
        if (this.callButton != null) {
            return Optional.of(this.callButton);
        }
        return Optional.empty();
    }

    public HydratedButtonType buttonType() {
        return this.button().map(HydratedButton::buttonType).orElse(HydratedButtonType.NONE);
    }

    public static HydratedTemplateButtonBuilder builder() {
        return new HydratedTemplateButtonBuilder();
    }

    public HydratedTemplateButton(HydratedQuickReplyButton quickReplyButton, HydratedURLButton urlButton, HydratedCallButton callButton, int index) {
        this.quickReplyButton = quickReplyButton;
        this.urlButton = urlButton;
        this.callButton = callButton;
        this.index = index;
    }

    public HydratedQuickReplyButton quickReplyButton() {
        return this.quickReplyButton;
    }

    public HydratedURLButton urlButton() {
        return this.urlButton;
    }

    public HydratedCallButton callButton() {
        return this.callButton;
    }

    public int index() {
        return this.index;
    }

    public HydratedTemplateButton quickReplyButton(HydratedQuickReplyButton quickReplyButton) {
        this.quickReplyButton = quickReplyButton;
        return this;
    }

    public HydratedTemplateButton urlButton(HydratedURLButton urlButton) {
        this.urlButton = urlButton;
        return this;
    }

    public HydratedTemplateButton callButton(HydratedCallButton callButton) {
        this.callButton = callButton;
        return this;
    }

    public HydratedTemplateButton index(int index) {
        this.index = index;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HydratedTemplateButton)) {
            return false;
        }
        HydratedTemplateButton other = (HydratedTemplateButton)o;
        if (this.index() != other.index()) {
            return false;
        }
        HydratedQuickReplyButton this$quickReplyButton = this.quickReplyButton();
        HydratedQuickReplyButton other$quickReplyButton = other.quickReplyButton();
        if (this$quickReplyButton == null ? other$quickReplyButton != null : !((Object)this$quickReplyButton).equals(other$quickReplyButton)) {
            return false;
        }
        HydratedURLButton this$urlButton = this.urlButton();
        HydratedURLButton other$urlButton = other.urlButton();
        if (this$urlButton == null ? other$urlButton != null : !((Object)this$urlButton).equals(other$urlButton)) {
            return false;
        }
        HydratedCallButton this$callButton = this.callButton();
        HydratedCallButton other$callButton = other.callButton();
        return !(this$callButton == null ? other$callButton != null : !((Object)this$callButton).equals(other$callButton));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.index();
        HydratedQuickReplyButton $quickReplyButton = this.quickReplyButton();
        result = result * 59 + ($quickReplyButton == null ? 43 : ((Object)$quickReplyButton).hashCode());
        HydratedURLButton $urlButton = this.urlButton();
        result = result * 59 + ($urlButton == null ? 43 : ((Object)$urlButton).hashCode());
        HydratedCallButton $callButton = this.callButton();
        result = result * 59 + ($callButton == null ? 43 : ((Object)$callButton).hashCode());
        return result;
    }

    public String toString() {
        return "HydratedTemplateButton(quickReplyButton=" + this.quickReplyButton() + ", urlButton=" + this.urlButton() + ", callButton=" + this.callButton() + ", index=" + this.index() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.callButton != null) {
            protobufOutputStream.writeBytes(3, this.callButton.toEncodedProtobuf());
        }
        if (this.urlButton != null) {
            protobufOutputStream.writeBytes(2, this.urlButton.toEncodedProtobuf());
        }
        protobufOutputStream.writeUInt32(4, this.index);
        if (this.quickReplyButton != null) {
            protobufOutputStream.writeBytes(1, this.quickReplyButton.toEncodedProtobuf());
        }
        return protobufOutputStream.toByteArray();
    }

    public static HydratedTemplateButton ofProtobuf(byte[] byArray) {
        int n;
        HydratedTemplateButtonBuilder hydratedTemplateButtonBuilder = HydratedTemplateButton.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block6: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 3: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    hydratedTemplateButtonBuilder.callButton(HydratedCallButton.ofProtobuf(protobufInputStream.readBytes()));
                    continue block6;
                }
                case 2: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    hydratedTemplateButtonBuilder.urlButton(HydratedURLButton.ofProtobuf(protobufInputStream.readBytes()));
                    continue block6;
                }
                case 4: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    hydratedTemplateButtonBuilder.index(protobufInputStream.readInt32());
                    continue block6;
                }
                case 1: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    hydratedTemplateButtonBuilder.quickReplyButton(HydratedQuickReplyButton.ofProtobuf(protobufInputStream.readBytes()));
                    continue block6;
                }
            }
            protobufInputStream.readBytes();
        }
        return hydratedTemplateButtonBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class HydratedTemplateButtonBuilder {
        private HydratedQuickReplyButton quickReplyButton;
        private HydratedURLButton urlButton;
        private HydratedCallButton callButton;
        private int index;

        HydratedTemplateButtonBuilder() {
        }

        public HydratedTemplateButtonBuilder quickReplyButton(HydratedQuickReplyButton quickReplyButton) {
            this.quickReplyButton = quickReplyButton;
            return this;
        }

        public HydratedTemplateButtonBuilder urlButton(HydratedURLButton urlButton) {
            this.urlButton = urlButton;
            return this;
        }

        public HydratedTemplateButtonBuilder callButton(HydratedCallButton callButton) {
            this.callButton = callButton;
            return this;
        }

        public HydratedTemplateButtonBuilder index(int index) {
            this.index = index;
            return this;
        }

        public HydratedTemplateButton build() {
            return new HydratedTemplateButton(this.quickReplyButton, this.urlButton, this.callButton, this.index);
        }

        public String toString() {
            return "HydratedTemplateButton.HydratedTemplateButtonBuilder(quickReplyButton=" + this.quickReplyButton + ", urlButton=" + this.urlButton + ", callButton=" + this.callButton + ", index=" + this.index + ")";
        }
    }
}

