/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.chat;

import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.whatsapp.model.chat.GroupParticipant;
import it.auties.whatsapp.model.chat.GroupPolicy;
import it.auties.whatsapp.model.chat.GroupSetting;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.request.Node;
import it.auties.whatsapp.util.Clock;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import lombok.NonNull;

public final class GroupMetadata
implements ProtobufMessage {
    @NonNull
    private final ContactJid jid;
    @NonNull
    private final String subject;
    private final ContactJid subjectAuthor;
    @NonNull
    private final ZonedDateTime subjectTimestamp;
    @NonNull
    private final ZonedDateTime foundationTimestamp;
    private final ContactJid founder;
    private final String description;
    private final String descriptionId;
    @NonNull
    private final Map<GroupSetting, GroupPolicy> policies;
    @NonNull
    private final List<GroupParticipant> participants;
    private final ZonedDateTime ephemeralExpiration;
    private final boolean community;
    private final boolean openCommunity;

    public static GroupMetadata of(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        ContactJid groupId = node.attributes().getOptionalString("id").map(id -> ContactJid.of(id, ContactJid.Server.GROUP)).orElseThrow(() -> new NoSuchElementException("Missing group jid"));
        String subject = node.attributes().getString("subject");
        ContactJid subjectAuthor = node.attributes().getJid("s_o").orElse(null);
        long subjectTimestampSeconds = node.attributes().getLong("s_t");
        ZonedDateTime subjectTimestamp = subjectTimestampSeconds <= 0L ? ZonedDateTime.now() : Clock.parseSeconds(subjectTimestampSeconds);
        long foundationTimestampSeconds = node.attributes().getLong("creation");
        ZonedDateTime foundationTimestamp = subjectTimestampSeconds <= 0L ? ZonedDateTime.now() : Clock.parseSeconds(foundationTimestampSeconds);
        ContactJid founder = node.attributes().getJid("creator").orElse(null);
        HashMap<GroupSetting, GroupPolicy> policies = new HashMap<GroupSetting, GroupPolicy>();
        policies.put(GroupSetting.SEND_MESSAGES, GroupPolicy.of(node.hasNode("restrict")));
        policies.put(GroupSetting.EDIT_GROUP_INFO, GroupPolicy.of(node.hasNode("announce")));
        policies.put(GroupSetting.APPROVE_NEW_PARTICIPANTS, GroupPolicy.of(node.hasNode("membership_approval_mode")));
        String description = node.findNode("description").flatMap(parent -> parent.findNode("body")).map(GroupMetadata::parseDescription).orElse(null);
        String descriptionId = node.findNode("description").map(Node::attributes).flatMap(attributes -> attributes.getOptionalString("id")).orElse(null);
        boolean community = node.findNode("parent").isPresent();
        boolean openCommunity = node.findNode("parent").filter(entry -> entry.attributes().hasKey("default_membership_approval_mode", "request_required")).isEmpty();
        ZonedDateTime ephemeral = node.findNode("ephemeral").map(Node::attributes).map(attributes -> attributes.getLong("expiration")).map(Clock::parseSeconds).orElse(null);
        List<GroupParticipant> participants = node.findNodes("participant").stream().map(GroupParticipant::of).toList();
        return new GroupMetadata(groupId, subject, subjectAuthor, subjectTimestamp, foundationTimestamp, founder, description, descriptionId, Collections.unmodifiableMap(policies), participants, ephemeral, community, openCommunity);
    }

    private static String parseDescription(Node wrapper) {
        if (wrapper.content() == null) {
            return null;
        }
        Object object = wrapper.content();
        if (object instanceof String) {
            String string = (String)object;
            return string;
        }
        object = wrapper.content();
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return new String(bytes, StandardCharsets.UTF_8);
        }
        throw new IllegalArgumentException("Illegal body type: %s".formatted(wrapper.content().getClass().getName()));
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public Optional<ZonedDateTime> ephemeralExpiration() {
        return Optional.ofNullable(this.ephemeralExpiration);
    }

    public Optional<ContactJid> founder() {
        return Optional.ofNullable(this.founder);
    }

    public List<ContactJid> participantsJids() {
        return this.participants.stream().map(GroupParticipant::jid).toList();
    }

    public static GroupMetadataBuilder builder() {
        return new GroupMetadataBuilder();
    }

    @NonNull
    public ContactJid jid() {
        return this.jid;
    }

    @NonNull
    public String subject() {
        return this.subject;
    }

    public ContactJid subjectAuthor() {
        return this.subjectAuthor;
    }

    @NonNull
    public ZonedDateTime subjectTimestamp() {
        return this.subjectTimestamp;
    }

    @NonNull
    public ZonedDateTime foundationTimestamp() {
        return this.foundationTimestamp;
    }

    public String descriptionId() {
        return this.descriptionId;
    }

    @NonNull
    public Map<GroupSetting, GroupPolicy> policies() {
        return this.policies;
    }

    @NonNull
    public List<GroupParticipant> participants() {
        return this.participants;
    }

    public boolean community() {
        return this.community;
    }

    public boolean openCommunity() {
        return this.openCommunity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupMetadata)) {
            return false;
        }
        GroupMetadata other = (GroupMetadata)o;
        if (this.community() != other.community()) {
            return false;
        }
        if (this.openCommunity() != other.openCommunity()) {
            return false;
        }
        ContactJid this$jid = this.jid();
        ContactJid other$jid = other.jid();
        if (this$jid == null ? other$jid != null : !((Object)this$jid).equals(other$jid)) {
            return false;
        }
        String this$subject = this.subject();
        String other$subject = other.subject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        ContactJid this$subjectAuthor = this.subjectAuthor();
        ContactJid other$subjectAuthor = other.subjectAuthor();
        if (this$subjectAuthor == null ? other$subjectAuthor != null : !((Object)this$subjectAuthor).equals(other$subjectAuthor)) {
            return false;
        }
        ZonedDateTime this$subjectTimestamp = this.subjectTimestamp();
        ZonedDateTime other$subjectTimestamp = other.subjectTimestamp();
        if (this$subjectTimestamp == null ? other$subjectTimestamp != null : !((Object)this$subjectTimestamp).equals(other$subjectTimestamp)) {
            return false;
        }
        ZonedDateTime this$foundationTimestamp = this.foundationTimestamp();
        ZonedDateTime other$foundationTimestamp = other.foundationTimestamp();
        if (this$foundationTimestamp == null ? other$foundationTimestamp != null : !((Object)this$foundationTimestamp).equals(other$foundationTimestamp)) {
            return false;
        }
        Optional<ContactJid> this$founder = this.founder();
        Optional<ContactJid> other$founder = other.founder();
        if (this$founder == null ? other$founder != null : !((Object)this$founder).equals(other$founder)) {
            return false;
        }
        Optional<String> this$description = this.description();
        Optional<String> other$description = other.description();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        String this$descriptionId = this.descriptionId();
        String other$descriptionId = other.descriptionId();
        if (this$descriptionId == null ? other$descriptionId != null : !this$descriptionId.equals(other$descriptionId)) {
            return false;
        }
        Map<GroupSetting, GroupPolicy> this$policies = this.policies();
        Map<GroupSetting, GroupPolicy> other$policies = other.policies();
        if (this$policies == null ? other$policies != null : !((Object)this$policies).equals(other$policies)) {
            return false;
        }
        List<GroupParticipant> this$participants = this.participants();
        List<GroupParticipant> other$participants = other.participants();
        if (this$participants == null ? other$participants != null : !((Object)this$participants).equals(other$participants)) {
            return false;
        }
        Optional<ZonedDateTime> this$ephemeralExpiration = this.ephemeralExpiration();
        Optional<ZonedDateTime> other$ephemeralExpiration = other.ephemeralExpiration();
        return !(this$ephemeralExpiration == null ? other$ephemeralExpiration != null : !((Object)this$ephemeralExpiration).equals(other$ephemeralExpiration));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.community() ? 79 : 97);
        result = result * 59 + (this.openCommunity() ? 79 : 97);
        ContactJid $jid = this.jid();
        result = result * 59 + ($jid == null ? 43 : ((Object)$jid).hashCode());
        String $subject = this.subject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        ContactJid $subjectAuthor = this.subjectAuthor();
        result = result * 59 + ($subjectAuthor == null ? 43 : ((Object)$subjectAuthor).hashCode());
        ZonedDateTime $subjectTimestamp = this.subjectTimestamp();
        result = result * 59 + ($subjectTimestamp == null ? 43 : ((Object)$subjectTimestamp).hashCode());
        ZonedDateTime $foundationTimestamp = this.foundationTimestamp();
        result = result * 59 + ($foundationTimestamp == null ? 43 : ((Object)$foundationTimestamp).hashCode());
        Optional<ContactJid> $founder = this.founder();
        result = result * 59 + ($founder == null ? 43 : ((Object)$founder).hashCode());
        Optional<String> $description = this.description();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        String $descriptionId = this.descriptionId();
        result = result * 59 + ($descriptionId == null ? 43 : $descriptionId.hashCode());
        Map<GroupSetting, GroupPolicy> $policies = this.policies();
        result = result * 59 + ($policies == null ? 43 : ((Object)$policies).hashCode());
        List<GroupParticipant> $participants = this.participants();
        result = result * 59 + ($participants == null ? 43 : ((Object)$participants).hashCode());
        Optional<ZonedDateTime> $ephemeralExpiration = this.ephemeralExpiration();
        result = result * 59 + ($ephemeralExpiration == null ? 43 : ((Object)$ephemeralExpiration).hashCode());
        return result;
    }

    public String toString() {
        return "GroupMetadata(jid=" + this.jid() + ", subject=" + this.subject() + ", subjectAuthor=" + this.subjectAuthor() + ", subjectTimestamp=" + this.subjectTimestamp() + ", foundationTimestamp=" + this.foundationTimestamp() + ", founder=" + this.founder() + ", description=" + this.description() + ", descriptionId=" + this.descriptionId() + ", policies=" + this.policies() + ", participants=" + this.participants() + ", ephemeralExpiration=" + this.ephemeralExpiration() + ", community=" + this.community() + ", openCommunity=" + this.openCommunity() + ")";
    }

    public GroupMetadata(@NonNull ContactJid jid, @NonNull String subject, ContactJid subjectAuthor, @NonNull ZonedDateTime subjectTimestamp, @NonNull ZonedDateTime foundationTimestamp, ContactJid founder, String description, String descriptionId, @NonNull Map<GroupSetting, GroupPolicy> policies, @NonNull List<GroupParticipant> participants, ZonedDateTime ephemeralExpiration, boolean community, boolean openCommunity) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        if (subject == null) {
            throw new NullPointerException("subject is marked non-null but is null");
        }
        if (subjectTimestamp == null) {
            throw new NullPointerException("subjectTimestamp is marked non-null but is null");
        }
        if (foundationTimestamp == null) {
            throw new NullPointerException("foundationTimestamp is marked non-null but is null");
        }
        if (policies == null) {
            throw new NullPointerException("policies is marked non-null but is null");
        }
        if (participants == null) {
            throw new NullPointerException("participants is marked non-null but is null");
        }
        this.jid = jid;
        this.subject = subject;
        this.subjectAuthor = subjectAuthor;
        this.subjectTimestamp = subjectTimestamp;
        this.foundationTimestamp = foundationTimestamp;
        this.founder = founder;
        this.description = description;
        this.descriptionId = descriptionId;
        this.policies = policies;
        this.participants = participants;
        this.ephemeralExpiration = ephemeralExpiration;
        this.community = community;
        this.openCommunity = openCommunity;
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        return protobufOutputStream.toByteArray();
    }

    public static GroupMetadata ofProtobuf(byte[] byArray) {
        int n;
        GroupMetadataBuilder groupMetadataBuilder = GroupMetadata.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                default: 
            }
            protobufInputStream.readBytes();
        }
        return groupMetadataBuilder.build();
    }

    public static class GroupMetadataBuilder {
        private ContactJid jid;
        private String subject;
        private ContactJid subjectAuthor;
        private ZonedDateTime subjectTimestamp;
        private ZonedDateTime foundationTimestamp;
        private ContactJid founder;
        private String description;
        private String descriptionId;
        private Map<GroupSetting, GroupPolicy> policies;
        private List<GroupParticipant> participants;
        private ZonedDateTime ephemeralExpiration;
        private boolean community;
        private boolean openCommunity;

        GroupMetadataBuilder() {
        }

        public GroupMetadataBuilder jid(@NonNull ContactJid jid) {
            if (jid == null) {
                throw new NullPointerException("jid is marked non-null but is null");
            }
            this.jid = jid;
            return this;
        }

        public GroupMetadataBuilder subject(@NonNull String subject) {
            if (subject == null) {
                throw new NullPointerException("subject is marked non-null but is null");
            }
            this.subject = subject;
            return this;
        }

        public GroupMetadataBuilder subjectAuthor(ContactJid subjectAuthor) {
            this.subjectAuthor = subjectAuthor;
            return this;
        }

        public GroupMetadataBuilder subjectTimestamp(@NonNull ZonedDateTime subjectTimestamp) {
            if (subjectTimestamp == null) {
                throw new NullPointerException("subjectTimestamp is marked non-null but is null");
            }
            this.subjectTimestamp = subjectTimestamp;
            return this;
        }

        public GroupMetadataBuilder foundationTimestamp(@NonNull ZonedDateTime foundationTimestamp) {
            if (foundationTimestamp == null) {
                throw new NullPointerException("foundationTimestamp is marked non-null but is null");
            }
            this.foundationTimestamp = foundationTimestamp;
            return this;
        }

        public GroupMetadataBuilder founder(ContactJid founder) {
            this.founder = founder;
            return this;
        }

        public GroupMetadataBuilder description(String description) {
            this.description = description;
            return this;
        }

        public GroupMetadataBuilder descriptionId(String descriptionId) {
            this.descriptionId = descriptionId;
            return this;
        }

        public GroupMetadataBuilder policies(@NonNull Map<GroupSetting, GroupPolicy> policies) {
            if (policies == null) {
                throw new NullPointerException("policies is marked non-null but is null");
            }
            this.policies = policies;
            return this;
        }

        public GroupMetadataBuilder participants(@NonNull List<GroupParticipant> participants) {
            if (participants == null) {
                throw new NullPointerException("participants is marked non-null but is null");
            }
            this.participants = participants;
            return this;
        }

        public GroupMetadataBuilder ephemeralExpiration(ZonedDateTime ephemeralExpiration) {
            this.ephemeralExpiration = ephemeralExpiration;
            return this;
        }

        public GroupMetadataBuilder community(boolean community) {
            this.community = community;
            return this;
        }

        public GroupMetadataBuilder openCommunity(boolean openCommunity) {
            this.openCommunity = openCommunity;
            return this;
        }

        public GroupMetadata build() {
            return new GroupMetadata(this.jid, this.subject, this.subjectAuthor, this.subjectTimestamp, this.foundationTimestamp, this.founder, this.description, this.descriptionId, this.policies, this.participants, this.ephemeralExpiration, this.community, this.openCommunity);
        }

        public String toString() {
            return "GroupMetadata.GroupMetadataBuilder(jid=" + this.jid + ", subject=" + this.subject + ", subjectAuthor=" + this.subjectAuthor + ", subjectTimestamp=" + this.subjectTimestamp + ", foundationTimestamp=" + this.foundationTimestamp + ", founder=" + this.founder + ", description=" + this.description + ", descriptionId=" + this.descriptionId + ", policies=" + this.policies + ", participants=" + this.participants + ", ephemeralExpiration=" + this.ephemeralExpiration + ", community=" + this.community + ", openCommunity=" + this.openCommunity + ")";
        }
    }
}

