/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.chat;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufName;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.util.Clock;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Iterator;

@ProtobufName(value="PastParticipant")
@JsonDeserialize(builder=PastParticipantBuilder.class)
public class PastParticipant
implements ProtobufMessage {
    @ProtobufProperty(index=1, name="userJid", type=ProtobufType.STRING)
    private ContactJid jid;
    @ProtobufProperty(index=2, name="leaveReason", type=ProtobufType.MESSAGE)
    private LeaveReason reason;
    @ProtobufProperty(index=3, name="leaveTs", type=ProtobufType.UINT64)
    private long timestampSeconds;

    public ZonedDateTime timestamp() {
        return Clock.parseSeconds(this.timestampSeconds);
    }

    public static PastParticipantBuilder builder() {
        return new PastParticipantBuilder();
    }

    public PastParticipant(ContactJid jid, LeaveReason reason, long timestampSeconds) {
        this.jid = jid;
        this.reason = reason;
        this.timestampSeconds = timestampSeconds;
    }

    public ContactJid jid() {
        return this.jid;
    }

    public LeaveReason reason() {
        return this.reason;
    }

    public long timestampSeconds() {
        return this.timestampSeconds;
    }

    public PastParticipant jid(ContactJid jid) {
        this.jid = jid;
        return this;
    }

    public PastParticipant reason(LeaveReason reason) {
        this.reason = reason;
        return this;
    }

    public PastParticipant timestampSeconds(long timestampSeconds) {
        this.timestampSeconds = timestampSeconds;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PastParticipant)) {
            return false;
        }
        PastParticipant other = (PastParticipant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.timestampSeconds() != other.timestampSeconds()) {
            return false;
        }
        ContactJid this$jid = this.jid();
        ContactJid other$jid = other.jid();
        if (this$jid == null ? other$jid != null : !((Object)this$jid).equals(other$jid)) {
            return false;
        }
        LeaveReason this$reason = this.reason();
        LeaveReason other$reason = other.reason();
        return !(this$reason == null ? other$reason != null : !((Object)((Object)this$reason)).equals((Object)other$reason));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PastParticipant;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestampSeconds = this.timestampSeconds();
        result = result * 59 + (int)($timestampSeconds >>> 32 ^ $timestampSeconds);
        ContactJid $jid = this.jid();
        result = result * 59 + ($jid == null ? 43 : ((Object)$jid).hashCode());
        LeaveReason $reason = this.reason();
        result = result * 59 + ($reason == null ? 43 : ((Object)((Object)$reason)).hashCode());
        return result;
    }

    public String toString() {
        return "PastParticipant(jid=" + this.jid() + ", reason=" + this.reason() + ", timestampSeconds=" + this.timestampSeconds() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        protobufOutputStream.writeUInt64(3, this.timestampSeconds);
        if (this.jid != null) {
            protobufOutputStream.writeString(1, this.jid.toValue());
        }
        if (this.reason != null) {
            protobufOutputStream.writeUInt32(2, this.reason.index());
        }
        return protobufOutputStream.toByteArray();
    }

    public static PastParticipant ofProtobuf(byte[] byArray) {
        int n;
        PastParticipantBuilder pastParticipantBuilder = PastParticipant.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block5: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 3: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    pastParticipantBuilder.timestampSeconds(protobufInputStream.readInt64());
                    continue block5;
                }
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    pastParticipantBuilder.jid(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block5;
                }
                case 2: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    pastParticipantBuilder.reason(LeaveReason.of(protobufInputStream.readInt32()));
                    continue block5;
                }
            }
            protobufInputStream.readBytes();
        }
        return pastParticipantBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class PastParticipantBuilder {
        private ContactJid jid;
        private LeaveReason reason;
        private long timestampSeconds;

        PastParticipantBuilder() {
        }

        public PastParticipantBuilder jid(ContactJid jid) {
            this.jid = jid;
            return this;
        }

        public PastParticipantBuilder reason(LeaveReason reason) {
            this.reason = reason;
            return this;
        }

        public PastParticipantBuilder timestampSeconds(long timestampSeconds) {
            this.timestampSeconds = timestampSeconds;
            return this;
        }

        public PastParticipant build() {
            return new PastParticipant(this.jid, this.reason, this.timestampSeconds);
        }

        public String toString() {
            return "PastParticipant.PastParticipantBuilder(jid=" + this.jid + ", reason=" + this.reason + ", timestampSeconds=" + this.timestampSeconds + ")";
        }
    }

    public static enum LeaveReason implements ProtobufMessage
    {
        LEFT(0),
        REMOVED(1);

        private final int index;

        private LeaveReason(int index) {
            this.index = index;
        }

        public int index() {
            return this.index;
        }

        public static LeaveReason of(byte[] byArray) {
            throw new UnsupportedOperationException();
        }

        public byte[] toEncodedProtobuf() {
            ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
            return protobufOutputStream.toByteArray();
        }

        public static LeaveReason of(int n) {
            Iterator iterator = Arrays.stream(LeaveReason.values()).iterator();
            while (iterator.hasNext()) {
                LeaveReason leaveReason = (LeaveReason)((Object)iterator.next());
                if (leaveReason.index() != n) continue;
                return leaveReason;
            }
            return null;
        }
    }
}

