/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.companion;

import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.Version;
import lombok.NonNull;

public record CompanionDevice(@NonNull String model, @NonNull String manufacturer, @NonNull UserAgent.UserAgentPlatform osType, @NonNull Version osVersion) {
    private static final CompanionDevice IPHONE_7 = new CompanionDevice("iPhone 7", "Apple", UserAgent.UserAgentPlatform.IOS, new Version("15.3.1"));
    private static final CompanionDevice SAMSUNG_GALAXY_S9 = new CompanionDevice("star2lte", "Samsung", UserAgent.UserAgentPlatform.ANDROID, new Version("8.0.0"));
    private static final CompanionDevice SURFACE_LAPTOP_STUDIO = new CompanionDevice("Surface Laptop Studio", "Microsoft", UserAgent.UserAgentPlatform.WINDOWS, new Version("10.0"));

    public CompanionDevice(@NonNull String model, @NonNull String manufacturer, @NonNull UserAgent.UserAgentPlatform osType, @NonNull Version osVersion) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (manufacturer == null) {
            throw new NullPointerException("manufacturer is marked non-null but is null");
        }
        if (osType == null) {
            throw new NullPointerException("osType is marked non-null but is null");
        }
        if (osVersion == null) {
            throw new NullPointerException("osVersion is marked non-null but is null");
        }
    }

    public static CompanionDevice ios() {
        return IPHONE_7;
    }

    public static CompanionDevice android() {
        return SAMSUNG_GALAXY_S9;
    }

    public static CompanionDevice windows() {
        return SURFACE_LAPTOP_STUDIO;
    }
}

