/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.media;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

@JsonDeserialize(builder=MediaDataBuilder.class)
public class MediaData
implements ProtobufMessage {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    private String localPath;
    @ProtobufProperty(index=2, name="mediaKeyTimestamp", type=ProtobufType.INT64)
    private Long mediaKeyTimestamp;
    @ProtobufProperty(index=3, name="fileSha256", type=ProtobufType.BYTES)
    private byte[] fileSha256;
    @ProtobufProperty(index=4, name="fileEncSha256", type=ProtobufType.BYTES)
    private byte[] fileEncSha256;
    @ProtobufProperty(index=5, name="directPath", type=ProtobufType.STRING)
    private String directPath;

    public static MediaDataBuilder builder() {
        return new MediaDataBuilder();
    }

    public MediaData(String localPath, Long mediaKeyTimestamp, byte[] fileSha256, byte[] fileEncSha256, String directPath) {
        this.localPath = localPath;
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        this.fileSha256 = fileSha256;
        this.fileEncSha256 = fileEncSha256;
        this.directPath = directPath;
    }

    public String localPath() {
        return this.localPath;
    }

    public Long mediaKeyTimestamp() {
        return this.mediaKeyTimestamp;
    }

    public byte[] fileSha256() {
        return this.fileSha256;
    }

    public byte[] fileEncSha256() {
        return this.fileEncSha256;
    }

    public String directPath() {
        return this.directPath;
    }

    public MediaData localPath(String localPath) {
        this.localPath = localPath;
        return this;
    }

    public MediaData mediaKeyTimestamp(Long mediaKeyTimestamp) {
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        return this;
    }

    public MediaData fileSha256(byte[] fileSha256) {
        this.fileSha256 = fileSha256;
        return this;
    }

    public MediaData fileEncSha256(byte[] fileEncSha256) {
        this.fileEncSha256 = fileEncSha256;
        return this;
    }

    public MediaData directPath(String directPath) {
        this.directPath = directPath;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MediaData)) {
            return false;
        }
        MediaData other = (MediaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$mediaKeyTimestamp = this.mediaKeyTimestamp();
        Long other$mediaKeyTimestamp = other.mediaKeyTimestamp();
        if (this$mediaKeyTimestamp == null ? other$mediaKeyTimestamp != null : !((Object)this$mediaKeyTimestamp).equals(other$mediaKeyTimestamp)) {
            return false;
        }
        String this$localPath = this.localPath();
        String other$localPath = other.localPath();
        if (this$localPath == null ? other$localPath != null : !this$localPath.equals(other$localPath)) {
            return false;
        }
        if (!Arrays.equals(this.fileSha256(), other.fileSha256())) {
            return false;
        }
        if (!Arrays.equals(this.fileEncSha256(), other.fileEncSha256())) {
            return false;
        }
        String this$directPath = this.directPath();
        String other$directPath = other.directPath();
        return !(this$directPath == null ? other$directPath != null : !this$directPath.equals(other$directPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MediaData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $mediaKeyTimestamp = this.mediaKeyTimestamp();
        result = result * 59 + ($mediaKeyTimestamp == null ? 43 : ((Object)$mediaKeyTimestamp).hashCode());
        String $localPath = this.localPath();
        result = result * 59 + ($localPath == null ? 43 : $localPath.hashCode());
        result = result * 59 + Arrays.hashCode(this.fileSha256());
        result = result * 59 + Arrays.hashCode(this.fileEncSha256());
        String $directPath = this.directPath();
        result = result * 59 + ($directPath == null ? 43 : $directPath.hashCode());
        return result;
    }

    public String toString() {
        return "MediaData(localPath=" + this.localPath() + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp() + ", fileSha256=" + Arrays.toString(this.fileSha256()) + ", fileEncSha256=" + Arrays.toString(this.fileEncSha256()) + ", directPath=" + this.directPath() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.mediaKeyTimestamp != null) {
            protobufOutputStream.writeInt64(2, this.mediaKeyTimestamp);
        }
        if (this.localPath != null) {
            protobufOutputStream.writeString(1, this.localPath);
        }
        if (this.fileEncSha256 != null) {
            protobufOutputStream.writeBytes(4, this.fileEncSha256);
        }
        if (this.fileSha256 != null) {
            protobufOutputStream.writeBytes(3, this.fileSha256);
        }
        if (this.directPath != null) {
            protobufOutputStream.writeString(5, this.directPath);
        }
        return protobufOutputStream.toByteArray();
    }

    public static MediaData ofProtobuf(byte[] byArray) {
        int n;
        MediaDataBuilder mediaDataBuilder = MediaData.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block7: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 2: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    mediaDataBuilder.mediaKeyTimestamp(protobufInputStream.readInt64());
                    continue block7;
                }
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    mediaDataBuilder.localPath(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block7;
                }
                case 4: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    mediaDataBuilder.fileEncSha256(protobufInputStream.readBytes());
                    continue block7;
                }
                case 3: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    mediaDataBuilder.fileSha256(protobufInputStream.readBytes());
                    continue block7;
                }
                case 5: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    mediaDataBuilder.directPath(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block7;
                }
            }
            protobufInputStream.readBytes();
        }
        return mediaDataBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class MediaDataBuilder {
        private String localPath;
        private Long mediaKeyTimestamp;
        private byte[] fileSha256;
        private byte[] fileEncSha256;
        private String directPath;

        MediaDataBuilder() {
        }

        public MediaDataBuilder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public MediaDataBuilder mediaKeyTimestamp(Long mediaKeyTimestamp) {
            this.mediaKeyTimestamp = mediaKeyTimestamp;
            return this;
        }

        public MediaDataBuilder fileSha256(byte[] fileSha256) {
            this.fileSha256 = fileSha256;
            return this;
        }

        public MediaDataBuilder fileEncSha256(byte[] fileEncSha256) {
            this.fileEncSha256 = fileEncSha256;
            return this;
        }

        public MediaDataBuilder directPath(String directPath) {
            this.directPath = directPath;
            return this;
        }

        public MediaData build() {
            return new MediaData(this.localPath, this.mediaKeyTimestamp, this.fileSha256, this.fileEncSha256, this.directPath);
        }

        public String toString() {
            return "MediaData.MediaDataBuilder(localPath=" + this.localPath + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp + ", fileSha256=" + Arrays.toString(this.fileSha256) + ", fileEncSha256=" + Arrays.toString(this.fileEncSha256) + ", directPath=" + this.directPath + ")";
        }
    }
}

