/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.button;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.button.base.Button;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.message.button.ButtonsMessageHeader;
import it.auties.whatsapp.model.message.model.ButtonMessage;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.message.model.MessageType;
import it.auties.whatsapp.model.message.standard.DocumentMessage;
import it.auties.whatsapp.model.message.standard.ImageMessage;
import it.auties.whatsapp.model.message.standard.LocationMessage;
import it.auties.whatsapp.model.message.standard.TextMessage;
import it.auties.whatsapp.model.message.standard.VideoMessage;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=ButtonsMessageBuilder.class)
public final class ButtonsMessage
extends ContextualMessage
implements ButtonMessage {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    private String headerText;
    @ProtobufProperty(index=2, type=ProtobufType.MESSAGE, implementation=DocumentMessage.class)
    private DocumentMessage headerDocument;
    @ProtobufProperty(index=3, type=ProtobufType.MESSAGE, implementation=ImageMessage.class)
    private ImageMessage headerImage;
    @ProtobufProperty(index=4, type=ProtobufType.MESSAGE, implementation=VideoMessage.class)
    private VideoMessage headerVideo;
    @ProtobufProperty(index=5, type=ProtobufType.MESSAGE, implementation=LocationMessage.class)
    private LocationMessage headerLocation;
    @ProtobufProperty(index=6, type=ProtobufType.STRING)
    private String body;
    @ProtobufProperty(index=7, type=ProtobufType.STRING)
    private String footer;
    @ProtobufProperty(index=8, type=ProtobufType.MESSAGE, implementation=ContextInfo.class)
    private ContextInfo contextInfo;
    @ProtobufProperty(index=9, type=ProtobufType.MESSAGE, implementation=Button.class, repeated=true)
    private List<Button> buttons;
    @ProtobufProperty(index=10, type=ProtobufType.MESSAGE, implementation=HeaderType.class)
    private HeaderType headerType;

    private static ButtonsMessage customBuilder(ButtonsMessageHeader header, String body, String footer, ContextInfo contextInfo, List<Button> buttons) {
        ButtonsMessageBuilder builder = ButtonsMessage.builder().body(body).footer(footer).contextInfo(Objects.requireNonNullElseGet(contextInfo, ContextInfo::new)).buttons(Objects.requireNonNullElseGet(buttons, ArrayList::new));
        if (header instanceof DocumentMessage) {
            DocumentMessage documentMessage = (DocumentMessage)header;
            builder.headerDocument(documentMessage).headerType(HeaderType.DOCUMENT);
        } else if (header instanceof ImageMessage) {
            ImageMessage imageMessage = (ImageMessage)header;
            builder.headerImage(imageMessage).headerType(HeaderType.IMAGE);
        } else if (header instanceof LocationMessage) {
            LocationMessage locationMessage = (LocationMessage)header;
            builder.headerLocation(locationMessage).headerType(HeaderType.LOCATION);
        } else if (header instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)header;
            builder.headerText(textMessage.text()).headerType(HeaderType.TEXT);
        } else if (header instanceof VideoMessage) {
            VideoMessage videoMessage = (VideoMessage)header;
            builder.headerVideo(videoMessage).headerType(HeaderType.VIDEO);
        } else if (header == null) {
            builder.headerType(HeaderType.EMPTY);
        }
        return builder.build();
    }

    @Override
    public MessageType type() {
        return MessageType.BUTTONS;
    }

    public HeaderType headerType() {
        if (this.headerText != null) {
            return HeaderType.TEXT;
        }
        if (this.headerDocument != null) {
            return HeaderType.DOCUMENT;
        }
        if (this.headerImage != null) {
            return HeaderType.IMAGE;
        }
        if (this.headerVideo != null) {
            return HeaderType.VIDEO;
        }
        if (this.headerLocation != null) {
            return HeaderType.LOCATION;
        }
        return HeaderType.EMPTY;
    }

    public Optional<ButtonsMessageHeader> header() {
        if (this.headerText != null) {
            return Optional.of(TextMessage.of(this.headerText));
        }
        if (this.headerDocument != null) {
            return Optional.of(this.headerDocument);
        }
        if (this.headerImage != null) {
            return Optional.of(this.headerImage);
        }
        if (this.headerVideo != null) {
            return Optional.of(this.headerVideo);
        }
        if (this.headerLocation != null) {
            return Optional.of(this.headerLocation);
        }
        return Optional.empty();
    }

    public Optional<String> headerText() {
        return Optional.ofNullable(this.headerText);
    }

    public Optional<DocumentMessage> headerDocument() {
        return Optional.ofNullable(this.headerDocument);
    }

    public Optional<ImageMessage> headerImage() {
        return Optional.ofNullable(this.headerImage);
    }

    public Optional<VideoMessage> headerVideo() {
        return Optional.ofNullable(this.headerVideo);
    }

    public Optional<LocationMessage> headerLocation() {
        return Optional.ofNullable(this.headerLocation);
    }

    public static ButtonsMessageBuilder builder() {
        return new ButtonsMessageBuilder();
    }

    public static ButtonsMessageSimpleBuilder simpleBuilder() {
        return new ButtonsMessageSimpleBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ButtonsMessage)) {
            return false;
        }
        ButtonsMessage other = (ButtonsMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Optional<String> this$headerText = this.headerText();
        Optional<String> other$headerText = other.headerText();
        if (this$headerText == null ? other$headerText != null : !((Object)this$headerText).equals(other$headerText)) {
            return false;
        }
        Optional<DocumentMessage> this$headerDocument = this.headerDocument();
        Optional<DocumentMessage> other$headerDocument = other.headerDocument();
        if (this$headerDocument == null ? other$headerDocument != null : !((Object)this$headerDocument).equals(other$headerDocument)) {
            return false;
        }
        Optional<ImageMessage> this$headerImage = this.headerImage();
        Optional<ImageMessage> other$headerImage = other.headerImage();
        if (this$headerImage == null ? other$headerImage != null : !((Object)this$headerImage).equals(other$headerImage)) {
            return false;
        }
        Optional<VideoMessage> this$headerVideo = this.headerVideo();
        Optional<VideoMessage> other$headerVideo = other.headerVideo();
        if (this$headerVideo == null ? other$headerVideo != null : !((Object)this$headerVideo).equals(other$headerVideo)) {
            return false;
        }
        Optional<LocationMessage> this$headerLocation = this.headerLocation();
        Optional<LocationMessage> other$headerLocation = other.headerLocation();
        if (this$headerLocation == null ? other$headerLocation != null : !((Object)this$headerLocation).equals(other$headerLocation)) {
            return false;
        }
        String this$body = this.body();
        String other$body = other.body();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        String this$footer = this.footer();
        String other$footer = other.footer();
        if (this$footer == null ? other$footer != null : !this$footer.equals(other$footer)) {
            return false;
        }
        ContextInfo this$contextInfo = this.contextInfo();
        ContextInfo other$contextInfo = other.contextInfo();
        if (this$contextInfo == null ? other$contextInfo != null : !((Object)this$contextInfo).equals(other$contextInfo)) {
            return false;
        }
        List<Button> this$buttons = this.buttons();
        List<Button> other$buttons = other.buttons();
        if (this$buttons == null ? other$buttons != null : !((Object)this$buttons).equals(other$buttons)) {
            return false;
        }
        HeaderType this$headerType = this.headerType();
        HeaderType other$headerType = other.headerType();
        return !(this$headerType == null ? other$headerType != null : !((Object)((Object)this$headerType)).equals((Object)other$headerType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ButtonsMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Optional<String> $headerText = this.headerText();
        result = result * 59 + ($headerText == null ? 43 : ((Object)$headerText).hashCode());
        Optional<DocumentMessage> $headerDocument = this.headerDocument();
        result = result * 59 + ($headerDocument == null ? 43 : ((Object)$headerDocument).hashCode());
        Optional<ImageMessage> $headerImage = this.headerImage();
        result = result * 59 + ($headerImage == null ? 43 : ((Object)$headerImage).hashCode());
        Optional<VideoMessage> $headerVideo = this.headerVideo();
        result = result * 59 + ($headerVideo == null ? 43 : ((Object)$headerVideo).hashCode());
        Optional<LocationMessage> $headerLocation = this.headerLocation();
        result = result * 59 + ($headerLocation == null ? 43 : ((Object)$headerLocation).hashCode());
        String $body = this.body();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        String $footer = this.footer();
        result = result * 59 + ($footer == null ? 43 : $footer.hashCode());
        ContextInfo $contextInfo = this.contextInfo();
        result = result * 59 + ($contextInfo == null ? 43 : ((Object)$contextInfo).hashCode());
        List<Button> $buttons = this.buttons();
        result = result * 59 + ($buttons == null ? 43 : ((Object)$buttons).hashCode());
        HeaderType $headerType = this.headerType();
        result = result * 59 + ($headerType == null ? 43 : ((Object)((Object)$headerType)).hashCode());
        return result;
    }

    public ButtonsMessage(String headerText, DocumentMessage headerDocument, ImageMessage headerImage, VideoMessage headerVideo, LocationMessage headerLocation, String body, String footer, ContextInfo contextInfo, List<Button> buttons, HeaderType headerType) {
        this.headerText = headerText;
        this.headerDocument = headerDocument;
        this.headerImage = headerImage;
        this.headerVideo = headerVideo;
        this.headerLocation = headerLocation;
        this.body = body;
        this.footer = footer;
        this.contextInfo = contextInfo;
        this.buttons = buttons;
        this.headerType = headerType;
    }

    public String body() {
        return this.body;
    }

    public String footer() {
        return this.footer;
    }

    @Override
    public ContextInfo contextInfo() {
        return this.contextInfo;
    }

    public List<Button> buttons() {
        return this.buttons;
    }

    public ButtonsMessage headerText(String headerText) {
        this.headerText = headerText;
        return this;
    }

    public ButtonsMessage headerDocument(DocumentMessage headerDocument) {
        this.headerDocument = headerDocument;
        return this;
    }

    public ButtonsMessage headerImage(ImageMessage headerImage) {
        this.headerImage = headerImage;
        return this;
    }

    public ButtonsMessage headerVideo(VideoMessage headerVideo) {
        this.headerVideo = headerVideo;
        return this;
    }

    public ButtonsMessage headerLocation(LocationMessage headerLocation) {
        this.headerLocation = headerLocation;
        return this;
    }

    public ButtonsMessage body(String body) {
        this.body = body;
        return this;
    }

    public ButtonsMessage footer(String footer) {
        this.footer = footer;
        return this;
    }

    @Override
    public ButtonsMessage contextInfo(ContextInfo contextInfo) {
        this.contextInfo = contextInfo;
        return this;
    }

    public ButtonsMessage buttons(List<Button> buttons) {
        this.buttons = buttons;
        return this;
    }

    public ButtonsMessage headerType(HeaderType headerType) {
        this.headerType = headerType;
        return this;
    }

    @Override
    public String toString() {
        return "ButtonsMessage(super=" + super.toString() + ", headerText=" + this.headerText() + ", headerDocument=" + this.headerDocument() + ", headerImage=" + this.headerImage() + ", headerVideo=" + this.headerVideo() + ", headerLocation=" + this.headerLocation() + ", body=" + this.body() + ", footer=" + this.footer() + ", contextInfo=" + this.contextInfo() + ", buttons=" + this.buttons() + ", headerType=" + this.headerType() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.headerVideo != null) {
            protobufOutputStream.writeBytes(4, this.headerVideo.toEncodedProtobuf());
        }
        if (this.headerLocation != null) {
            protobufOutputStream.writeBytes(5, this.headerLocation.toEncodedProtobuf());
        }
        if (this.body != null) {
            protobufOutputStream.writeString(6, this.body);
        }
        if (this.buttons != null) {
            for (Button button : this.buttons) {
                protobufOutputStream.writeBytes(9, button.toEncodedProtobuf());
            }
        }
        if (this.headerText != null) {
            protobufOutputStream.writeString(1, this.headerText);
        }
        if (this.footer != null) {
            protobufOutputStream.writeString(7, this.footer);
        }
        if (this.headerDocument != null) {
            protobufOutputStream.writeBytes(2, this.headerDocument.toEncodedProtobuf());
        }
        if (this.contextInfo != null) {
            protobufOutputStream.writeBytes(8, this.contextInfo.toEncodedProtobuf());
        }
        if (this.headerImage != null) {
            protobufOutputStream.writeBytes(3, this.headerImage.toEncodedProtobuf());
        }
        if (this.contextInfo != null) {
            protobufOutputStream.writeBytes(17, this.contextInfo.toEncodedProtobuf());
        }
        if (this.headerType != null) {
            protobufOutputStream.writeUInt32(10, this.headerType.index());
        }
        return protobufOutputStream.toByteArray();
    }

    public static ButtonsMessage ofProtobuf(byte[] byArray) {
        int n;
        ButtonsMessageBuilder buttonsMessageBuilder = ButtonsMessage.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        ArrayList<Button> arrayList = new ArrayList<Button>();
        block13: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 4: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    buttonsMessageBuilder.headerVideo(VideoMessage.ofProtobuf(protobufInputStream.readBytes()));
                    continue block13;
                }
                case 5: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    buttonsMessageBuilder.headerLocation(LocationMessage.ofProtobuf(protobufInputStream.readBytes()));
                    continue block13;
                }
                case 6: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    buttonsMessageBuilder.body(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block13;
                }
                case 9: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    arrayList.add(Button.ofProtobuf(protobufInputStream.readBytes()));
                    continue block13;
                }
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    buttonsMessageBuilder.headerText(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block13;
                }
                case 7: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    buttonsMessageBuilder.footer(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block13;
                }
                case 2: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    buttonsMessageBuilder.headerDocument(DocumentMessage.ofProtobuf(protobufInputStream.readBytes()));
                    continue block13;
                }
                case 8: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    buttonsMessageBuilder.contextInfo(ContextInfo.ofProtobuf(protobufInputStream.readBytes()));
                    continue block13;
                }
                case 3: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    buttonsMessageBuilder.headerImage(ImageMessage.ofProtobuf(protobufInputStream.readBytes()));
                    continue block13;
                }
                case 17: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    buttonsMessageBuilder.contextInfo(ContextInfo.ofProtobuf(protobufInputStream.readBytes()));
                    continue block13;
                }
                case 10: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    buttonsMessageBuilder.headerType(HeaderType.of(protobufInputStream.readInt32()));
                    continue block13;
                }
            }
            protobufInputStream.readBytes();
        }
        buttonsMessageBuilder.buttons(arrayList);
        return buttonsMessageBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ButtonsMessageBuilder {
        private String headerText;
        private DocumentMessage headerDocument;
        private ImageMessage headerImage;
        private VideoMessage headerVideo;
        private LocationMessage headerLocation;
        private String body;
        private String footer;
        private ContextInfo contextInfo;
        private List<Button> buttons;
        private HeaderType headerType;

        ButtonsMessageBuilder() {
        }

        public ButtonsMessageBuilder headerText(String headerText) {
            this.headerText = headerText;
            return this;
        }

        public ButtonsMessageBuilder headerDocument(DocumentMessage headerDocument) {
            this.headerDocument = headerDocument;
            return this;
        }

        public ButtonsMessageBuilder headerImage(ImageMessage headerImage) {
            this.headerImage = headerImage;
            return this;
        }

        public ButtonsMessageBuilder headerVideo(VideoMessage headerVideo) {
            this.headerVideo = headerVideo;
            return this;
        }

        public ButtonsMessageBuilder headerLocation(LocationMessage headerLocation) {
            this.headerLocation = headerLocation;
            return this;
        }

        public ButtonsMessageBuilder body(String body) {
            this.body = body;
            return this;
        }

        public ButtonsMessageBuilder footer(String footer) {
            this.footer = footer;
            return this;
        }

        public ButtonsMessageBuilder contextInfo(ContextInfo contextInfo) {
            this.contextInfo = contextInfo;
            return this;
        }

        public ButtonsMessageBuilder buttons(List<Button> buttons) {
            this.buttons = buttons;
            return this;
        }

        public ButtonsMessageBuilder headerType(HeaderType headerType) {
            this.headerType = headerType;
            return this;
        }

        public ButtonsMessage build() {
            return new ButtonsMessage(this.headerText, this.headerDocument, this.headerImage, this.headerVideo, this.headerLocation, this.body, this.footer, this.contextInfo, this.buttons, this.headerType);
        }

        public String toString() {
            return "ButtonsMessage.ButtonsMessageBuilder(headerText=" + this.headerText + ", headerDocument=" + this.headerDocument + ", headerImage=" + this.headerImage + ", headerVideo=" + this.headerVideo + ", headerLocation=" + this.headerLocation + ", body=" + this.body + ", footer=" + this.footer + ", contextInfo=" + this.contextInfo + ", buttons=" + this.buttons + ", headerType=" + this.headerType + ")";
        }
    }

    public static enum HeaderType implements ProtobufMessage
    {
        UNKNOWN(0),
        EMPTY(1),
        TEXT(2),
        DOCUMENT(3),
        IMAGE(4),
        VIDEO(5),
        LOCATION(6);

        private final int index;

        public boolean hasMedia() {
            return this == DOCUMENT || this == IMAGE || this == VIDEO;
        }

        private HeaderType(int index) {
            this.index = index;
        }

        public int index() {
            return this.index;
        }

        private static /* synthetic */ boolean lambda$of$0(int index, HeaderType entry) {
            return entry.index() == index;
        }

        public byte[] toEncodedProtobuf() {
            ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
            return protobufOutputStream.toByteArray();
        }

        public static HeaderType of(int n) {
            Iterator iterator = Arrays.stream(HeaderType.values()).iterator();
            while (iterator.hasNext()) {
                HeaderType headerType = (HeaderType)((Object)iterator.next());
                if (headerType.index() != n) continue;
                return headerType;
            }
            return null;
        }
    }

    public static class ButtonsMessageSimpleBuilder {
        private ButtonsMessageHeader header;
        private String body;
        private String footer;
        private ContextInfo contextInfo;
        private List<Button> buttons;

        ButtonsMessageSimpleBuilder() {
        }

        public ButtonsMessageSimpleBuilder header(ButtonsMessageHeader header) {
            this.header = header;
            return this;
        }

        public ButtonsMessageSimpleBuilder body(String body) {
            this.body = body;
            return this;
        }

        public ButtonsMessageSimpleBuilder footer(String footer) {
            this.footer = footer;
            return this;
        }

        public ButtonsMessageSimpleBuilder contextInfo(ContextInfo contextInfo) {
            this.contextInfo = contextInfo;
            return this;
        }

        public ButtonsMessageSimpleBuilder buttons(List<Button> buttons) {
            this.buttons = buttons;
            return this;
        }

        public ButtonsMessage build() {
            return ButtonsMessage.customBuilder(this.header, this.body, this.footer, this.contextInfo, this.buttons);
        }

        public String toString() {
            return "ButtonsMessage.ButtonsMessageSimpleBuilder(header=" + this.header + ", body=" + this.body + ", footer=" + this.footer + ", contextInfo=" + this.contextInfo + ", buttons=" + this.buttons + ")";
        }
    }
}

