/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.button;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.button.template.TemplateFormatter;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.interactive.InteractiveBody;
import it.auties.whatsapp.model.interactive.InteractiveCollection;
import it.auties.whatsapp.model.interactive.InteractiveFooter;
import it.auties.whatsapp.model.interactive.InteractiveHeader;
import it.auties.whatsapp.model.interactive.InteractiveNativeFlow;
import it.auties.whatsapp.model.interactive.InteractiveShop;
import it.auties.whatsapp.model.message.button.InteractiveMessageContent;
import it.auties.whatsapp.model.message.button.InteractiveMessageContentType;
import it.auties.whatsapp.model.message.button.TemplateFormatterType;
import it.auties.whatsapp.model.message.model.ButtonMessage;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.message.model.MessageCategory;
import it.auties.whatsapp.model.message.model.MessageType;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=InteractiveMessageBuilder.class)
public final class InteractiveMessage
extends ContextualMessage
implements ButtonMessage,
TemplateFormatter {
    @ProtobufProperty(index=1, type=ProtobufType.MESSAGE, implementation=InteractiveHeader.class)
    private InteractiveHeader header;
    @ProtobufProperty(index=2, type=ProtobufType.MESSAGE, implementation=InteractiveBody.class)
    private InteractiveBody body;
    @ProtobufProperty(index=3, type=ProtobufType.MESSAGE, implementation=InteractiveFooter.class)
    private InteractiveFooter footer;
    @ProtobufProperty(index=4, type=ProtobufType.MESSAGE, implementation=InteractiveShop.class)
    private InteractiveShop contentShop;
    @ProtobufProperty(index=5, type=ProtobufType.MESSAGE, implementation=InteractiveCollection.class)
    private InteractiveCollection contentCollection;
    @ProtobufProperty(index=6, type=ProtobufType.MESSAGE, implementation=InteractiveNativeFlow.class)
    private InteractiveNativeFlow contentNativeFlow;
    @ProtobufProperty(index=15, type=ProtobufType.MESSAGE, implementation=ContextInfo.class)
    private ContextInfo contextInfo;

    private static InteractiveMessage customBuilder(InteractiveHeader header, String body, String footer, InteractiveMessageContent content, ContextInfo contextInfo) {
        InteractiveMessageBuilder builder = InteractiveMessage.builder().header(header).body(InteractiveBody.of(body)).footer(InteractiveFooter.of(footer)).contextInfo(Objects.requireNonNullElseGet(contextInfo, ContextInfo::new));
        if (content instanceof InteractiveShop) {
            InteractiveShop interactiveShop = (InteractiveShop)content;
            builder.contentShop(interactiveShop);
        } else if (content instanceof InteractiveCollection) {
            InteractiveCollection interactiveCollection = (InteractiveCollection)content;
            builder.contentCollection(interactiveCollection);
        } else if (content instanceof InteractiveNativeFlow) {
            InteractiveNativeFlow interactiveNativeFlow = (InteractiveNativeFlow)content;
            builder.contentNativeFlow(interactiveNativeFlow);
        }
        return builder.build();
    }

    public InteractiveMessageContentType contentType() {
        return this.content().map(InteractiveMessageContent::contentType).orElse(InteractiveMessageContentType.NONE);
    }

    public Optional<InteractiveHeader> header() {
        return Optional.ofNullable(this.header);
    }

    public Optional<InteractiveBody> body() {
        return Optional.ofNullable(this.body);
    }

    public Optional<InteractiveFooter> footer() {
        return Optional.ofNullable(this.footer);
    }

    public Optional<InteractiveMessageContent> content() {
        if (this.contentShop != null) {
            return Optional.of(this.contentShop);
        }
        if (this.contentCollection != null) {
            return Optional.of(this.contentCollection);
        }
        if (this.contentNativeFlow != null) {
            return Optional.of(this.contentNativeFlow);
        }
        return Optional.empty();
    }

    public Optional<InteractiveShop> contentShop() {
        return Optional.ofNullable(this.contentShop);
    }

    public Optional<InteractiveCollection> contentCollection() {
        return Optional.ofNullable(this.contentCollection);
    }

    public Optional<InteractiveNativeFlow> contentNativeFlow() {
        return Optional.ofNullable(this.contentNativeFlow);
    }

    @Override
    public TemplateFormatterType templateType() {
        return TemplateFormatterType.INTERACTIVE;
    }

    @Override
    public MessageType type() {
        return MessageType.INTERACTIVE;
    }

    @Override
    public MessageCategory category() {
        return MessageCategory.STANDARD;
    }

    public static InteractiveMessageBuilder builder() {
        return new InteractiveMessageBuilder();
    }

    public static InteractiveMessageSimpleBuilder simpleBuilder() {
        return new InteractiveMessageSimpleBuilder();
    }

    public InteractiveMessage(InteractiveHeader header, InteractiveBody body, InteractiveFooter footer, InteractiveShop contentShop, InteractiveCollection contentCollection, InteractiveNativeFlow contentNativeFlow, ContextInfo contextInfo) {
        this.header = header;
        this.body = body;
        this.footer = footer;
        this.contentShop = contentShop;
        this.contentCollection = contentCollection;
        this.contentNativeFlow = contentNativeFlow;
        this.contextInfo = contextInfo;
    }

    public InteractiveMessage() {
    }

    @Override
    public ContextInfo contextInfo() {
        return this.contextInfo;
    }

    public InteractiveMessage header(InteractiveHeader header) {
        this.header = header;
        return this;
    }

    public InteractiveMessage body(InteractiveBody body) {
        this.body = body;
        return this;
    }

    public InteractiveMessage footer(InteractiveFooter footer) {
        this.footer = footer;
        return this;
    }

    public InteractiveMessage contentShop(InteractiveShop contentShop) {
        this.contentShop = contentShop;
        return this;
    }

    public InteractiveMessage contentCollection(InteractiveCollection contentCollection) {
        this.contentCollection = contentCollection;
        return this;
    }

    public InteractiveMessage contentNativeFlow(InteractiveNativeFlow contentNativeFlow) {
        this.contentNativeFlow = contentNativeFlow;
        return this;
    }

    @Override
    public InteractiveMessage contextInfo(ContextInfo contextInfo) {
        this.contextInfo = contextInfo;
        return this;
    }

    @Override
    public String toString() {
        return "InteractiveMessage(super=" + super.toString() + ", header=" + this.header() + ", body=" + this.body() + ", footer=" + this.footer() + ", contentShop=" + this.contentShop() + ", contentCollection=" + this.contentCollection() + ", contentNativeFlow=" + this.contentNativeFlow() + ", contextInfo=" + this.contextInfo() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InteractiveMessage)) {
            return false;
        }
        InteractiveMessage other = (InteractiveMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Optional<InteractiveHeader> this$header = this.header();
        Optional<InteractiveHeader> other$header = other.header();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        Optional<InteractiveBody> this$body = this.body();
        Optional<InteractiveBody> other$body = other.body();
        if (this$body == null ? other$body != null : !((Object)this$body).equals(other$body)) {
            return false;
        }
        Optional<InteractiveFooter> this$footer = this.footer();
        Optional<InteractiveFooter> other$footer = other.footer();
        if (this$footer == null ? other$footer != null : !((Object)this$footer).equals(other$footer)) {
            return false;
        }
        Optional<InteractiveShop> this$contentShop = this.contentShop();
        Optional<InteractiveShop> other$contentShop = other.contentShop();
        if (this$contentShop == null ? other$contentShop != null : !((Object)this$contentShop).equals(other$contentShop)) {
            return false;
        }
        Optional<InteractiveCollection> this$contentCollection = this.contentCollection();
        Optional<InteractiveCollection> other$contentCollection = other.contentCollection();
        if (this$contentCollection == null ? other$contentCollection != null : !((Object)this$contentCollection).equals(other$contentCollection)) {
            return false;
        }
        Optional<InteractiveNativeFlow> this$contentNativeFlow = this.contentNativeFlow();
        Optional<InteractiveNativeFlow> other$contentNativeFlow = other.contentNativeFlow();
        if (this$contentNativeFlow == null ? other$contentNativeFlow != null : !((Object)this$contentNativeFlow).equals(other$contentNativeFlow)) {
            return false;
        }
        ContextInfo this$contextInfo = this.contextInfo();
        ContextInfo other$contextInfo = other.contextInfo();
        return !(this$contextInfo == null ? other$contextInfo != null : !((Object)this$contextInfo).equals(other$contextInfo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InteractiveMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Optional<InteractiveHeader> $header = this.header();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        Optional<InteractiveBody> $body = this.body();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        Optional<InteractiveFooter> $footer = this.footer();
        result = result * 59 + ($footer == null ? 43 : ((Object)$footer).hashCode());
        Optional<InteractiveShop> $contentShop = this.contentShop();
        result = result * 59 + ($contentShop == null ? 43 : ((Object)$contentShop).hashCode());
        Optional<InteractiveCollection> $contentCollection = this.contentCollection();
        result = result * 59 + ($contentCollection == null ? 43 : ((Object)$contentCollection).hashCode());
        Optional<InteractiveNativeFlow> $contentNativeFlow = this.contentNativeFlow();
        result = result * 59 + ($contentNativeFlow == null ? 43 : ((Object)$contentNativeFlow).hashCode());
        ContextInfo $contextInfo = this.contextInfo();
        result = result * 59 + ($contextInfo == null ? 43 : ((Object)$contextInfo).hashCode());
        return result;
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.body != null) {
            protobufOutputStream.writeBytes(2, this.body.toEncodedProtobuf());
        }
        if (this.contentCollection != null) {
            protobufOutputStream.writeBytes(5, this.contentCollection.toEncodedProtobuf());
        }
        if (this.contentShop != null) {
            protobufOutputStream.writeBytes(4, this.contentShop.toEncodedProtobuf());
        }
        if (this.footer != null) {
            protobufOutputStream.writeBytes(3, this.footer.toEncodedProtobuf());
        }
        if (this.contextInfo != null) {
            protobufOutputStream.writeBytes(15, this.contextInfo.toEncodedProtobuf());
        }
        if (this.contextInfo != null) {
            protobufOutputStream.writeBytes(17, this.contextInfo.toEncodedProtobuf());
        }
        if (this.header != null) {
            protobufOutputStream.writeBytes(1, this.header.toEncodedProtobuf());
        }
        if (this.contentNativeFlow != null) {
            protobufOutputStream.writeBytes(6, this.contentNativeFlow.toEncodedProtobuf());
        }
        return protobufOutputStream.toByteArray();
    }

    public static InteractiveMessage ofProtobuf(byte[] byArray) {
        int n;
        InteractiveMessageBuilder interactiveMessageBuilder = InteractiveMessage.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block10: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 2: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    interactiveMessageBuilder.body(InteractiveBody.ofProtobuf(protobufInputStream.readBytes()));
                    continue block10;
                }
                case 5: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    interactiveMessageBuilder.contentCollection(InteractiveCollection.ofProtobuf(protobufInputStream.readBytes()));
                    continue block10;
                }
                case 4: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    interactiveMessageBuilder.contentShop(InteractiveShop.ofProtobuf(protobufInputStream.readBytes()));
                    continue block10;
                }
                case 3: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    interactiveMessageBuilder.footer(InteractiveFooter.ofProtobuf(protobufInputStream.readBytes()));
                    continue block10;
                }
                case 15: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    interactiveMessageBuilder.contextInfo(ContextInfo.ofProtobuf(protobufInputStream.readBytes()));
                    continue block10;
                }
                case 17: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    interactiveMessageBuilder.contextInfo(ContextInfo.ofProtobuf(protobufInputStream.readBytes()));
                    continue block10;
                }
                case 1: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    interactiveMessageBuilder.header(InteractiveHeader.ofProtobuf(protobufInputStream.readBytes()));
                    continue block10;
                }
                case 6: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    interactiveMessageBuilder.contentNativeFlow(InteractiveNativeFlow.ofProtobuf(protobufInputStream.readBytes()));
                    continue block10;
                }
            }
            protobufInputStream.readBytes();
        }
        return interactiveMessageBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class InteractiveMessageBuilder {
        private InteractiveHeader header;
        private InteractiveBody body;
        private InteractiveFooter footer;
        private InteractiveShop contentShop;
        private InteractiveCollection contentCollection;
        private InteractiveNativeFlow contentNativeFlow;
        private ContextInfo contextInfo;

        InteractiveMessageBuilder() {
        }

        public InteractiveMessageBuilder header(InteractiveHeader header) {
            this.header = header;
            return this;
        }

        public InteractiveMessageBuilder body(InteractiveBody body) {
            this.body = body;
            return this;
        }

        public InteractiveMessageBuilder footer(InteractiveFooter footer) {
            this.footer = footer;
            return this;
        }

        public InteractiveMessageBuilder contentShop(InteractiveShop contentShop) {
            this.contentShop = contentShop;
            return this;
        }

        public InteractiveMessageBuilder contentCollection(InteractiveCollection contentCollection) {
            this.contentCollection = contentCollection;
            return this;
        }

        public InteractiveMessageBuilder contentNativeFlow(InteractiveNativeFlow contentNativeFlow) {
            this.contentNativeFlow = contentNativeFlow;
            return this;
        }

        public InteractiveMessageBuilder contextInfo(ContextInfo contextInfo) {
            this.contextInfo = contextInfo;
            return this;
        }

        public InteractiveMessage build() {
            return new InteractiveMessage(this.header, this.body, this.footer, this.contentShop, this.contentCollection, this.contentNativeFlow, this.contextInfo);
        }

        public String toString() {
            return "InteractiveMessage.InteractiveMessageBuilder(header=" + this.header + ", body=" + this.body + ", footer=" + this.footer + ", contentShop=" + this.contentShop + ", contentCollection=" + this.contentCollection + ", contentNativeFlow=" + this.contentNativeFlow + ", contextInfo=" + this.contextInfo + ")";
        }
    }

    public static class InteractiveMessageSimpleBuilder {
        private InteractiveHeader header;
        private String body;
        private String footer;
        private InteractiveMessageContent content;
        private ContextInfo contextInfo;

        InteractiveMessageSimpleBuilder() {
        }

        public InteractiveMessageSimpleBuilder header(InteractiveHeader header) {
            this.header = header;
            return this;
        }

        public InteractiveMessageSimpleBuilder body(String body) {
            this.body = body;
            return this;
        }

        public InteractiveMessageSimpleBuilder footer(String footer) {
            this.footer = footer;
            return this;
        }

        public InteractiveMessageSimpleBuilder content(InteractiveMessageContent content) {
            this.content = content;
            return this;
        }

        public InteractiveMessageSimpleBuilder contextInfo(ContextInfo contextInfo) {
            this.contextInfo = contextInfo;
            return this;
        }

        public InteractiveMessage build() {
            return InteractiveMessage.customBuilder(this.header, this.body, this.footer, this.content, this.contextInfo);
        }

        public String toString() {
            return "InteractiveMessage.InteractiveMessageSimpleBuilder(header=" + this.header + ", body=" + this.body + ", footer=" + this.footer + ", content=" + this.content + ", contextInfo=" + this.contextInfo + ")";
        }
    }
}

