/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufName;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.message.model.KeepInChatType;
import it.auties.whatsapp.model.message.model.MessageKey;
import it.auties.whatsapp.util.Clock;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;

@ProtobufName(value="KeepInChat")
@JsonDeserialize(builder=KeepInChatBuilder.class)
public class KeepInChat
implements ProtobufMessage {
    @ProtobufProperty(index=1, name="keepType", type=ProtobufType.MESSAGE)
    private KeepInChatType keepType;
    @ProtobufProperty(index=2, name="serverTimestamp", type=ProtobufType.INT64)
    private long serverTimestampSeconds;
    @ProtobufProperty(index=3, name="key", type=ProtobufType.MESSAGE)
    private MessageKey key;
    @ProtobufProperty(index=4, name="deviceJid", type=ProtobufType.STRING)
    private ContactJid deviceJid;
    @ProtobufProperty(index=5, name="clientTimestampMs", type=ProtobufType.INT64)
    private long clientTimestampInMilliseconds;
    @ProtobufProperty(index=6, name="serverTimestampMs", type=ProtobufType.INT64)
    private long serverTimestampMilliseconds;

    public ZonedDateTime serverTimestamp() {
        return Clock.parseSeconds(this.serverTimestampSeconds);
    }

    public ZonedDateTime clientTimestamp() {
        return Clock.parseMilliseconds(this.clientTimestampInMilliseconds);
    }

    public static KeepInChatBuilder builder() {
        return new KeepInChatBuilder();
    }

    public KeepInChat(KeepInChatType keepType, long serverTimestampSeconds, MessageKey key, ContactJid deviceJid, long clientTimestampInMilliseconds, long serverTimestampMilliseconds) {
        this.keepType = keepType;
        this.serverTimestampSeconds = serverTimestampSeconds;
        this.key = key;
        this.deviceJid = deviceJid;
        this.clientTimestampInMilliseconds = clientTimestampInMilliseconds;
        this.serverTimestampMilliseconds = serverTimestampMilliseconds;
    }

    public KeepInChatType keepType() {
        return this.keepType;
    }

    public long serverTimestampSeconds() {
        return this.serverTimestampSeconds;
    }

    public MessageKey key() {
        return this.key;
    }

    public ContactJid deviceJid() {
        return this.deviceJid;
    }

    public long clientTimestampInMilliseconds() {
        return this.clientTimestampInMilliseconds;
    }

    public long serverTimestampMilliseconds() {
        return this.serverTimestampMilliseconds;
    }

    public KeepInChat keepType(KeepInChatType keepType) {
        this.keepType = keepType;
        return this;
    }

    public KeepInChat serverTimestampSeconds(long serverTimestampSeconds) {
        this.serverTimestampSeconds = serverTimestampSeconds;
        return this;
    }

    public KeepInChat key(MessageKey key) {
        this.key = key;
        return this;
    }

    public KeepInChat deviceJid(ContactJid deviceJid) {
        this.deviceJid = deviceJid;
        return this;
    }

    public KeepInChat clientTimestampInMilliseconds(long clientTimestampInMilliseconds) {
        this.clientTimestampInMilliseconds = clientTimestampInMilliseconds;
        return this;
    }

    public KeepInChat serverTimestampMilliseconds(long serverTimestampMilliseconds) {
        this.serverTimestampMilliseconds = serverTimestampMilliseconds;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeepInChat)) {
            return false;
        }
        KeepInChat other = (KeepInChat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.serverTimestampSeconds() != other.serverTimestampSeconds()) {
            return false;
        }
        if (this.clientTimestampInMilliseconds() != other.clientTimestampInMilliseconds()) {
            return false;
        }
        if (this.serverTimestampMilliseconds() != other.serverTimestampMilliseconds()) {
            return false;
        }
        KeepInChatType this$keepType = this.keepType();
        KeepInChatType other$keepType = other.keepType();
        if (this$keepType == null ? other$keepType != null : !((Object)((Object)this$keepType)).equals((Object)other$keepType)) {
            return false;
        }
        MessageKey this$key = this.key();
        MessageKey other$key = other.key();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        ContactJid this$deviceJid = this.deviceJid();
        ContactJid other$deviceJid = other.deviceJid();
        return !(this$deviceJid == null ? other$deviceJid != null : !((Object)this$deviceJid).equals(other$deviceJid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeepInChat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $serverTimestampSeconds = this.serverTimestampSeconds();
        result = result * 59 + (int)($serverTimestampSeconds >>> 32 ^ $serverTimestampSeconds);
        long $clientTimestampInMilliseconds = this.clientTimestampInMilliseconds();
        result = result * 59 + (int)($clientTimestampInMilliseconds >>> 32 ^ $clientTimestampInMilliseconds);
        long $serverTimestampMilliseconds = this.serverTimestampMilliseconds();
        result = result * 59 + (int)($serverTimestampMilliseconds >>> 32 ^ $serverTimestampMilliseconds);
        KeepInChatType $keepType = this.keepType();
        result = result * 59 + ($keepType == null ? 43 : ((Object)((Object)$keepType)).hashCode());
        MessageKey $key = this.key();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        ContactJid $deviceJid = this.deviceJid();
        result = result * 59 + ($deviceJid == null ? 43 : ((Object)$deviceJid).hashCode());
        return result;
    }

    public String toString() {
        return "KeepInChat(keepType=" + this.keepType() + ", serverTimestampSeconds=" + this.serverTimestampSeconds() + ", key=" + this.key() + ", deviceJid=" + this.deviceJid() + ", clientTimestampInMilliseconds=" + this.clientTimestampInMilliseconds() + ", serverTimestampMilliseconds=" + this.serverTimestampMilliseconds() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.deviceJid != null) {
            protobufOutputStream.writeString(4, this.deviceJid.toValue());
        }
        protobufOutputStream.writeInt64(5, this.clientTimestampInMilliseconds);
        protobufOutputStream.writeInt64(6, this.serverTimestampMilliseconds);
        if (this.keepType != null) {
            protobufOutputStream.writeUInt32(1, this.keepType.index());
        }
        protobufOutputStream.writeInt64(2, this.serverTimestampSeconds);
        if (this.key != null) {
            protobufOutputStream.writeBytes(3, this.key.toEncodedProtobuf());
        }
        return protobufOutputStream.toByteArray();
    }

    public static KeepInChat ofProtobuf(byte[] byArray) {
        int n;
        KeepInChatBuilder keepInChatBuilder = KeepInChat.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block8: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 4: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    keepInChatBuilder.deviceJid(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block8;
                }
                case 5: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    keepInChatBuilder.clientTimestampInMilliseconds(protobufInputStream.readInt64());
                    continue block8;
                }
                case 6: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    keepInChatBuilder.serverTimestampMilliseconds(protobufInputStream.readInt64());
                    continue block8;
                }
                case 1: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    keepInChatBuilder.keepType(KeepInChatType.of(protobufInputStream.readInt32()));
                    continue block8;
                }
                case 2: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    keepInChatBuilder.serverTimestampSeconds(protobufInputStream.readInt64());
                    continue block8;
                }
                case 3: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    keepInChatBuilder.key(MessageKey.ofProtobuf(protobufInputStream.readBytes()));
                    continue block8;
                }
            }
            protobufInputStream.readBytes();
        }
        return keepInChatBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class KeepInChatBuilder {
        private KeepInChatType keepType;
        private long serverTimestampSeconds;
        private MessageKey key;
        private ContactJid deviceJid;
        private long clientTimestampInMilliseconds;
        private long serverTimestampMilliseconds;

        KeepInChatBuilder() {
        }

        public KeepInChatBuilder keepType(KeepInChatType keepType) {
            this.keepType = keepType;
            return this;
        }

        public KeepInChatBuilder serverTimestampSeconds(long serverTimestampSeconds) {
            this.serverTimestampSeconds = serverTimestampSeconds;
            return this;
        }

        public KeepInChatBuilder key(MessageKey key) {
            this.key = key;
            return this;
        }

        public KeepInChatBuilder deviceJid(ContactJid deviceJid) {
            this.deviceJid = deviceJid;
            return this;
        }

        public KeepInChatBuilder clientTimestampInMilliseconds(long clientTimestampInMilliseconds) {
            this.clientTimestampInMilliseconds = clientTimestampInMilliseconds;
            return this;
        }

        public KeepInChatBuilder serverTimestampMilliseconds(long serverTimestampMilliseconds) {
            this.serverTimestampMilliseconds = serverTimestampMilliseconds;
            return this;
        }

        public KeepInChat build() {
            return new KeepInChat(this.keepType, this.serverTimestampSeconds, this.key, this.deviceJid, this.clientTimestampInMilliseconds, this.serverTimestampMilliseconds);
        }

        public String toString() {
            return "KeepInChat.KeepInChatBuilder(keepType=" + this.keepType + ", serverTimestampSeconds=" + this.serverTimestampSeconds + ", key=" + this.key + ", deviceJid=" + this.deviceJid + ", clientTimestampInMilliseconds=" + this.clientTimestampInMilliseconds + ", serverTimestampMilliseconds=" + this.serverTimestampMilliseconds + ")";
        }
    }
}

