/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.util.BytesHelper;
import java.nio.charset.StandardCharsets;
import java.util.HexFormat;
import java.util.Optional;
import lombok.NonNull;

@JsonDeserialize(builder=MessageKeyBuilder.class)
public class MessageKey
implements ProtobufMessage {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    @NonNull
    private ContactJid chatJid;
    @JsonBackReference
    private Chat chat;
    @ProtobufProperty(index=2, type=ProtobufType.BOOL)
    private boolean fromMe;
    @ProtobufProperty(index=3, type=ProtobufType.STRING)
    @NonNull
    private String id;
    @ProtobufProperty(index=4, type=ProtobufType.STRING)
    private ContactJid senderJid;
    private Contact sender;

    public static String randomId() {
        return HexFormat.of().formatHex(BytesHelper.random(8));
    }

    public Optional<Contact> sender() {
        return Optional.ofNullable(this.sender);
    }

    public Optional<ContactJid> senderJid() {
        return Optional.ofNullable(this.senderJid);
    }

    public MessageKey copy() {
        return new MessageKey(this.chatJid, this.chat, this.fromMe, this.id, this.senderJid, this.sender);
    }

    private static String $default$id() {
        return MessageKey.randomId();
    }

    public static MessageKeyBuilder builder() {
        return new MessageKeyBuilder();
    }

    public MessageKey(@NonNull ContactJid chatJid, Chat chat, boolean fromMe, @NonNull String id, ContactJid senderJid, Contact sender) {
        if (chatJid == null) {
            throw new NullPointerException("chatJid is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.chatJid = chatJid;
        this.chat = chat;
        this.fromMe = fromMe;
        this.id = id;
        this.senderJid = senderJid;
        this.sender = sender;
    }

    @NonNull
    public ContactJid chatJid() {
        return this.chatJid;
    }

    public Chat chat() {
        return this.chat;
    }

    public boolean fromMe() {
        return this.fromMe;
    }

    @NonNull
    public String id() {
        return this.id;
    }

    public MessageKey chatJid(@NonNull ContactJid chatJid) {
        if (chatJid == null) {
            throw new NullPointerException("chatJid is marked non-null but is null");
        }
        this.chatJid = chatJid;
        return this;
    }

    public MessageKey chat(Chat chat) {
        this.chat = chat;
        return this;
    }

    public MessageKey fromMe(boolean fromMe) {
        this.fromMe = fromMe;
        return this;
    }

    public MessageKey id(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
        return this;
    }

    public MessageKey senderJid(ContactJid senderJid) {
        this.senderJid = senderJid;
        return this;
    }

    public MessageKey sender(Contact sender) {
        this.sender = sender;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageKey)) {
            return false;
        }
        MessageKey other = (MessageKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.fromMe() != other.fromMe()) {
            return false;
        }
        ContactJid this$chatJid = this.chatJid();
        ContactJid other$chatJid = other.chatJid();
        if (this$chatJid == null ? other$chatJid != null : !((Object)this$chatJid).equals(other$chatJid)) {
            return false;
        }
        Chat this$chat = this.chat();
        Chat other$chat = other.chat();
        if (this$chat == null ? other$chat != null : !((Object)this$chat).equals(other$chat)) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Optional<ContactJid> this$senderJid = this.senderJid();
        Optional<ContactJid> other$senderJid = other.senderJid();
        if (this$senderJid == null ? other$senderJid != null : !((Object)this$senderJid).equals(other$senderJid)) {
            return false;
        }
        Optional<Contact> this$sender = this.sender();
        Optional<Contact> other$sender = other.sender();
        return !(this$sender == null ? other$sender != null : !((Object)this$sender).equals(other$sender));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.fromMe() ? 79 : 97);
        ContactJid $chatJid = this.chatJid();
        result = result * 59 + ($chatJid == null ? 43 : ((Object)$chatJid).hashCode());
        Chat $chat = this.chat();
        result = result * 59 + ($chat == null ? 43 : ((Object)$chat).hashCode());
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Optional<ContactJid> $senderJid = this.senderJid();
        result = result * 59 + ($senderJid == null ? 43 : ((Object)$senderJid).hashCode());
        Optional<Contact> $sender = this.sender();
        result = result * 59 + ($sender == null ? 43 : ((Object)$sender).hashCode());
        return result;
    }

    public String toString() {
        return "MessageKey(chatJid=" + this.chatJid() + ", fromMe=" + this.fromMe() + ", id=" + this.id() + ", senderJid=" + this.senderJid() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.id != null) {
            protobufOutputStream.writeString(3, this.id);
        }
        protobufOutputStream.writeBool(2, this.fromMe);
        if (this.senderJid != null) {
            protobufOutputStream.writeString(4, this.senderJid.toValue());
        }
        if (this.chatJid != null) {
            protobufOutputStream.writeString(1, this.chatJid.toValue());
        }
        return protobufOutputStream.toByteArray();
    }

    public static MessageKey ofProtobuf(byte[] byArray) {
        int n;
        MessageKeyBuilder messageKeyBuilder = MessageKey.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block6: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 3: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageKeyBuilder.id(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block6;
                }
                case 2: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageKeyBuilder.fromMe(protobufInputStream.readBool());
                    continue block6;
                }
                case 4: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageKeyBuilder.senderJid(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block6;
                }
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    messageKeyBuilder.chatJid(ContactJid.ofProtobuf(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8)));
                    continue block6;
                }
            }
            protobufInputStream.readBytes();
        }
        return messageKeyBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class MessageKeyBuilder {
        private ContactJid chatJid;
        private Chat chat;
        private boolean fromMe;
        private boolean id$set;
        private String id$value;
        private ContactJid senderJid;
        private Contact sender;

        MessageKeyBuilder() {
        }

        public MessageKeyBuilder chatJid(@NonNull ContactJid chatJid) {
            if (chatJid == null) {
                throw new NullPointerException("chatJid is marked non-null but is null");
            }
            this.chatJid = chatJid;
            return this;
        }

        public MessageKeyBuilder chat(Chat chat) {
            this.chat = chat;
            return this;
        }

        public MessageKeyBuilder fromMe(boolean fromMe) {
            this.fromMe = fromMe;
            return this;
        }

        public MessageKeyBuilder id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id$value = id;
            this.id$set = true;
            return this;
        }

        public MessageKeyBuilder senderJid(ContactJid senderJid) {
            this.senderJid = senderJid;
            return this;
        }

        public MessageKeyBuilder sender(Contact sender) {
            this.sender = sender;
            return this;
        }

        public MessageKey build() {
            String id$value = this.id$value;
            if (!this.id$set) {
                id$value = MessageKey.$default$id();
            }
            return new MessageKey(this.chatJid, this.chat, this.fromMe, id$value, this.senderJid, this.sender);
        }

        public String toString() {
            return "MessageKey.MessageKeyBuilder(chatJid=" + this.chatJid + ", chat=" + this.chat + ", fromMe=" + this.fromMe + ", id$value=" + this.id$value + ", senderJid=" + this.senderJid + ", sender=" + this.sender + ")";
        }
    }
}

