/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.message.model.MediaMessage;
import it.auties.whatsapp.model.message.model.MediaMessageType;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.Medias;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=AudioMessageBuilderImpl.class)
public final class AudioMessage
extends MediaMessage {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    private String mediaUrl;
    @ProtobufProperty(index=2, type=ProtobufType.STRING)
    private String mimetype;
    @ProtobufProperty(index=3, type=ProtobufType.BYTES)
    private byte[] mediaSha256;
    @ProtobufProperty(index=4, type=ProtobufType.UINT64)
    private long mediaSize;
    @ProtobufProperty(index=5, type=ProtobufType.UINT32)
    private int duration;
    @ProtobufProperty(index=6, type=ProtobufType.BOOL)
    private boolean voiceMessage;
    @ProtobufProperty(index=7, type=ProtobufType.BYTES)
    private byte[] mediaKey;
    @ProtobufProperty(index=8, type=ProtobufType.BYTES)
    private byte[] mediaEncryptedSha256;
    @ProtobufProperty(index=9, type=ProtobufType.STRING)
    private String mediaDirectPath;
    @ProtobufProperty(index=10, type=ProtobufType.INT64)
    private long mediaKeyTimestamp;
    @ProtobufProperty(index=18, type=ProtobufType.BYTES)
    private byte[] streamingSidecar;
    @ProtobufProperty(index=19, name="waveform", type=ProtobufType.BYTES)
    private byte[] waveform;
    @ProtobufProperty(index=20, name="backgroundArgb", type=ProtobufType.FIXED32)
    private Integer backgroundArgb;

    private static AudioMessage customBuilder(byte[] media, ContextInfo contextInfo, String mimeType, boolean voiceMessage) {
        return ((AudioMessageBuilder)((AudioMessageBuilder)((AudioMessageBuilder)((AudioMessageBuilder)((AudioMessageBuilder)((ContextualMessage.ContextualMessageBuilder)((AudioMessageBuilder)AudioMessage.builder().decodedMedia(media)).mediaKeyTimestamp(Clock.nowSeconds())).contextInfo(Objects.requireNonNullElseGet(contextInfo, ContextInfo::new))).duration(Medias.getDuration(media))).mimetype(AudioMessage.getMimeType(media, mimeType))).voiceMessage(voiceMessage)).waveform(Medias.getAudioWaveForm(media).orElse(null))).build();
    }

    private static String getMimeType(byte[] media, String mimeType) {
        return Optional.ofNullable(mimeType).or(() -> Medias.getMimeType(media)).orElseGet(MediaMessageType.AUDIO::defaultMimeType);
    }

    @Override
    public MediaMessageType mediaType() {
        return MediaMessageType.AUDIO;
    }

    protected AudioMessage(AudioMessageBuilder<?, ?> b) {
        super((MediaMessage.MediaMessageBuilder<?, ?>)b);
        this.mediaUrl = b.mediaUrl;
        this.mimetype = b.mimetype;
        this.mediaSha256 = b.mediaSha256;
        this.mediaSize = b.mediaSize;
        this.duration = b.duration;
        this.voiceMessage = b.voiceMessage;
        this.mediaKey = b.mediaKey;
        this.mediaEncryptedSha256 = b.mediaEncryptedSha256;
        this.mediaDirectPath = b.mediaDirectPath;
        this.mediaKeyTimestamp = b.mediaKeyTimestamp;
        this.streamingSidecar = b.streamingSidecar;
        this.waveform = b.waveform;
        this.backgroundArgb = b.backgroundArgb;
    }

    public static AudioMessageBuilder<?, ?> builder() {
        return new AudioMessageBuilderImpl();
    }

    public static SimpleAudioMessageBuilder simpleBuilder() {
        return new SimpleAudioMessageBuilder();
    }

    public AudioMessage(String mediaUrl, String mimetype, byte[] mediaSha256, long mediaSize, int duration, boolean voiceMessage, byte[] mediaKey, byte[] mediaEncryptedSha256, String mediaDirectPath, long mediaKeyTimestamp, byte[] streamingSidecar, byte[] waveform, Integer backgroundArgb) {
        this.mediaUrl = mediaUrl;
        this.mimetype = mimetype;
        this.mediaSha256 = mediaSha256;
        this.mediaSize = mediaSize;
        this.duration = duration;
        this.voiceMessage = voiceMessage;
        this.mediaKey = mediaKey;
        this.mediaEncryptedSha256 = mediaEncryptedSha256;
        this.mediaDirectPath = mediaDirectPath;
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        this.streamingSidecar = streamingSidecar;
        this.waveform = waveform;
        this.backgroundArgb = backgroundArgb;
    }

    public AudioMessage() {
    }

    @Override
    public String mediaUrl() {
        return this.mediaUrl;
    }

    public String mimetype() {
        return this.mimetype;
    }

    @Override
    public byte[] mediaSha256() {
        return this.mediaSha256;
    }

    @Override
    public long mediaSize() {
        return this.mediaSize;
    }

    public int duration() {
        return this.duration;
    }

    public boolean voiceMessage() {
        return this.voiceMessage;
    }

    @Override
    public byte[] mediaKey() {
        return this.mediaKey;
    }

    @Override
    public byte[] mediaEncryptedSha256() {
        return this.mediaEncryptedSha256;
    }

    @Override
    public String mediaDirectPath() {
        return this.mediaDirectPath;
    }

    @Override
    public long mediaKeyTimestamp() {
        return this.mediaKeyTimestamp;
    }

    public byte[] streamingSidecar() {
        return this.streamingSidecar;
    }

    public byte[] waveform() {
        return this.waveform;
    }

    public Integer backgroundArgb() {
        return this.backgroundArgb;
    }

    @Override
    public AudioMessage mediaUrl(String mediaUrl) {
        this.mediaUrl = mediaUrl;
        return this;
    }

    public AudioMessage mimetype(String mimetype) {
        this.mimetype = mimetype;
        return this;
    }

    @Override
    public AudioMessage mediaSha256(byte[] mediaSha256) {
        this.mediaSha256 = mediaSha256;
        return this;
    }

    @Override
    public AudioMessage mediaSize(long mediaSize) {
        this.mediaSize = mediaSize;
        return this;
    }

    public AudioMessage duration(int duration) {
        this.duration = duration;
        return this;
    }

    public AudioMessage voiceMessage(boolean voiceMessage) {
        this.voiceMessage = voiceMessage;
        return this;
    }

    @Override
    public AudioMessage mediaKey(byte[] mediaKey) {
        this.mediaKey = mediaKey;
        return this;
    }

    @Override
    public AudioMessage mediaEncryptedSha256(byte[] mediaEncryptedSha256) {
        this.mediaEncryptedSha256 = mediaEncryptedSha256;
        return this;
    }

    @Override
    public AudioMessage mediaDirectPath(String mediaDirectPath) {
        this.mediaDirectPath = mediaDirectPath;
        return this;
    }

    public AudioMessage mediaKeyTimestamp(long mediaKeyTimestamp) {
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        return this;
    }

    public AudioMessage streamingSidecar(byte[] streamingSidecar) {
        this.streamingSidecar = streamingSidecar;
        return this;
    }

    public AudioMessage waveform(byte[] waveform) {
        this.waveform = waveform;
        return this;
    }

    public AudioMessage backgroundArgb(Integer backgroundArgb) {
        this.backgroundArgb = backgroundArgb;
        return this;
    }

    @Override
    public String toString() {
        return "AudioMessage(super=" + super.toString() + ", mediaUrl=" + this.mediaUrl() + ", mimetype=" + this.mimetype() + ", mediaSha256=" + Arrays.toString(this.mediaSha256()) + ", mediaSize=" + this.mediaSize() + ", duration=" + this.duration() + ", voiceMessage=" + this.voiceMessage() + ", mediaKey=" + Arrays.toString(this.mediaKey()) + ", mediaEncryptedSha256=" + Arrays.toString(this.mediaEncryptedSha256()) + ", mediaDirectPath=" + this.mediaDirectPath() + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp() + ", streamingSidecar=" + Arrays.toString(this.streamingSidecar()) + ", waveform=" + Arrays.toString(this.waveform()) + ", backgroundArgb=" + this.backgroundArgb() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AudioMessage)) {
            return false;
        }
        AudioMessage other = (AudioMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.mediaSize() != other.mediaSize()) {
            return false;
        }
        if (this.duration() != other.duration()) {
            return false;
        }
        if (this.voiceMessage() != other.voiceMessage()) {
            return false;
        }
        if (this.mediaKeyTimestamp() != other.mediaKeyTimestamp()) {
            return false;
        }
        Integer this$backgroundArgb = this.backgroundArgb();
        Integer other$backgroundArgb = other.backgroundArgb();
        if (this$backgroundArgb == null ? other$backgroundArgb != null : !((Object)this$backgroundArgb).equals(other$backgroundArgb)) {
            return false;
        }
        String this$mediaUrl = this.mediaUrl();
        String other$mediaUrl = other.mediaUrl();
        if (this$mediaUrl == null ? other$mediaUrl != null : !this$mediaUrl.equals(other$mediaUrl)) {
            return false;
        }
        String this$mimetype = this.mimetype();
        String other$mimetype = other.mimetype();
        if (this$mimetype == null ? other$mimetype != null : !this$mimetype.equals(other$mimetype)) {
            return false;
        }
        if (!Arrays.equals(this.mediaSha256(), other.mediaSha256())) {
            return false;
        }
        if (!Arrays.equals(this.mediaKey(), other.mediaKey())) {
            return false;
        }
        if (!Arrays.equals(this.mediaEncryptedSha256(), other.mediaEncryptedSha256())) {
            return false;
        }
        String this$mediaDirectPath = this.mediaDirectPath();
        String other$mediaDirectPath = other.mediaDirectPath();
        if (this$mediaDirectPath == null ? other$mediaDirectPath != null : !this$mediaDirectPath.equals(other$mediaDirectPath)) {
            return false;
        }
        if (!Arrays.equals(this.streamingSidecar(), other.streamingSidecar())) {
            return false;
        }
        return Arrays.equals(this.waveform(), other.waveform());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AudioMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $mediaSize = this.mediaSize();
        result = result * 59 + (int)($mediaSize >>> 32 ^ $mediaSize);
        result = result * 59 + this.duration();
        result = result * 59 + (this.voiceMessage() ? 79 : 97);
        long $mediaKeyTimestamp = this.mediaKeyTimestamp();
        result = result * 59 + (int)($mediaKeyTimestamp >>> 32 ^ $mediaKeyTimestamp);
        Integer $backgroundArgb = this.backgroundArgb();
        result = result * 59 + ($backgroundArgb == null ? 43 : ((Object)$backgroundArgb).hashCode());
        String $mediaUrl = this.mediaUrl();
        result = result * 59 + ($mediaUrl == null ? 43 : $mediaUrl.hashCode());
        String $mimetype = this.mimetype();
        result = result * 59 + ($mimetype == null ? 43 : $mimetype.hashCode());
        result = result * 59 + Arrays.hashCode(this.mediaSha256());
        result = result * 59 + Arrays.hashCode(this.mediaKey());
        result = result * 59 + Arrays.hashCode(this.mediaEncryptedSha256());
        String $mediaDirectPath = this.mediaDirectPath();
        result = result * 59 + ($mediaDirectPath == null ? 43 : $mediaDirectPath.hashCode());
        result = result * 59 + Arrays.hashCode(this.streamingSidecar());
        result = result * 59 + Arrays.hashCode(this.waveform());
        return result;
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        protobufOutputStream.writeBool(6, this.voiceMessage);
        if (this.backgroundArgb != null) {
            protobufOutputStream.writeFixed32(20, this.backgroundArgb);
        }
        if (this.mediaEncryptedSha256 != null) {
            protobufOutputStream.writeBytes(8, this.mediaEncryptedSha256);
        }
        protobufOutputStream.writeUInt64(4, this.mediaSize);
        if (this.mediaUrl != null) {
            protobufOutputStream.writeString(1, this.mediaUrl);
        }
        if (this.contextInfo != null) {
            protobufOutputStream.writeBytes(17, this.contextInfo.toEncodedProtobuf());
        }
        if (this.mediaSha256 != null) {
            protobufOutputStream.writeBytes(3, this.mediaSha256);
        }
        if (this.mimetype != null) {
            protobufOutputStream.writeString(2, this.mimetype);
        }
        if (this.mediaDirectPath != null) {
            protobufOutputStream.writeString(9, this.mediaDirectPath);
        }
        if (this.streamingSidecar != null) {
            protobufOutputStream.writeBytes(18, this.streamingSidecar);
        }
        if (this.mediaKey != null) {
            protobufOutputStream.writeBytes(7, this.mediaKey);
        }
        if (this.waveform != null) {
            protobufOutputStream.writeBytes(19, this.waveform);
        }
        protobufOutputStream.writeUInt32(5, this.duration);
        protobufOutputStream.writeInt64(10, this.mediaKeyTimestamp);
        return protobufOutputStream.toByteArray();
    }

    public static AudioMessage ofProtobuf(byte[] byArray) {
        int n;
        AudioMessageBuilder<?, ?> audioMessageBuilder = AudioMessage.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block16: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 6: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    audioMessageBuilder.voiceMessage(protobufInputStream.readBool());
                    continue block16;
                }
                case 20: {
                    if (n3 != 5) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    audioMessageBuilder.backgroundArgb(protobufInputStream.readFixed32());
                    continue block16;
                }
                case 8: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    audioMessageBuilder.mediaEncryptedSha256(protobufInputStream.readBytes());
                    continue block16;
                }
                case 4: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    audioMessageBuilder.mediaSize(protobufInputStream.readInt64());
                    continue block16;
                }
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    audioMessageBuilder.mediaUrl(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block16;
                }
                case 17: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    audioMessageBuilder.contextInfo(ContextInfo.ofProtobuf(protobufInputStream.readBytes()));
                    continue block16;
                }
                case 3: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    audioMessageBuilder.mediaSha256(protobufInputStream.readBytes());
                    continue block16;
                }
                case 2: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    audioMessageBuilder.mimetype(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block16;
                }
                case 9: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    audioMessageBuilder.mediaDirectPath(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block16;
                }
                case 18: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    audioMessageBuilder.streamingSidecar(protobufInputStream.readBytes());
                    continue block16;
                }
                case 7: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    audioMessageBuilder.mediaKey(protobufInputStream.readBytes());
                    continue block16;
                }
                case 19: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    audioMessageBuilder.waveform(protobufInputStream.readBytes());
                    continue block16;
                }
                case 5: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    audioMessageBuilder.duration(protobufInputStream.readInt32());
                    continue block16;
                }
                case 10: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    audioMessageBuilder.mediaKeyTimestamp(protobufInputStream.readInt64());
                    continue block16;
                }
            }
            protobufInputStream.readBytes();
        }
        return audioMessageBuilder.build();
    }

    public static abstract class AudioMessageBuilder<C extends AudioMessage, B extends AudioMessageBuilder<C, B>>
    extends MediaMessage.MediaMessageBuilder<C, B> {
        private String mediaUrl;
        private String mimetype;
        private byte[] mediaSha256;
        private long mediaSize;
        private int duration;
        private boolean voiceMessage;
        private byte[] mediaKey;
        private byte[] mediaEncryptedSha256;
        private String mediaDirectPath;
        private long mediaKeyTimestamp;
        private byte[] streamingSidecar;
        private byte[] waveform;
        private Integer backgroundArgb;

        public B mediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return (B)this.self();
        }

        public B mimetype(String mimetype) {
            this.mimetype = mimetype;
            return (B)this.self();
        }

        public B mediaSha256(byte[] mediaSha256) {
            this.mediaSha256 = mediaSha256;
            return (B)this.self();
        }

        public B mediaSize(long mediaSize) {
            this.mediaSize = mediaSize;
            return (B)this.self();
        }

        public B duration(int duration) {
            this.duration = duration;
            return (B)this.self();
        }

        public B voiceMessage(boolean voiceMessage) {
            this.voiceMessage = voiceMessage;
            return (B)this.self();
        }

        public B mediaKey(byte[] mediaKey) {
            this.mediaKey = mediaKey;
            return (B)this.self();
        }

        public B mediaEncryptedSha256(byte[] mediaEncryptedSha256) {
            this.mediaEncryptedSha256 = mediaEncryptedSha256;
            return (B)this.self();
        }

        public B mediaDirectPath(String mediaDirectPath) {
            this.mediaDirectPath = mediaDirectPath;
            return (B)this.self();
        }

        public B mediaKeyTimestamp(long mediaKeyTimestamp) {
            this.mediaKeyTimestamp = mediaKeyTimestamp;
            return (B)this.self();
        }

        public B streamingSidecar(byte[] streamingSidecar) {
            this.streamingSidecar = streamingSidecar;
            return (B)this.self();
        }

        public B waveform(byte[] waveform) {
            this.waveform = waveform;
            return (B)this.self();
        }

        public B backgroundArgb(Integer backgroundArgb) {
            this.backgroundArgb = backgroundArgb;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "AudioMessage.AudioMessageBuilder(super=" + super.toString() + ", mediaUrl=" + this.mediaUrl + ", mimetype=" + this.mimetype + ", mediaSha256=" + Arrays.toString(this.mediaSha256) + ", mediaSize=" + this.mediaSize + ", duration=" + this.duration + ", voiceMessage=" + this.voiceMessage + ", mediaKey=" + Arrays.toString(this.mediaKey) + ", mediaEncryptedSha256=" + Arrays.toString(this.mediaEncryptedSha256) + ", mediaDirectPath=" + this.mediaDirectPath + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp + ", streamingSidecar=" + Arrays.toString(this.streamingSidecar) + ", waveform=" + Arrays.toString(this.waveform) + ", backgroundArgb=" + this.backgroundArgb + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class AudioMessageBuilderImpl
    extends AudioMessageBuilder<AudioMessage, AudioMessageBuilderImpl> {
        private AudioMessageBuilderImpl() {
        }

        @Override
        protected AudioMessageBuilderImpl self() {
            return this;
        }

        @Override
        public AudioMessage build() {
            return new AudioMessage(this);
        }
    }

    public static class SimpleAudioMessageBuilder {
        private byte[] media;
        private ContextInfo contextInfo;
        private String mimeType;
        private boolean voiceMessage;

        SimpleAudioMessageBuilder() {
        }

        public SimpleAudioMessageBuilder media(byte[] media) {
            this.media = media;
            return this;
        }

        public SimpleAudioMessageBuilder contextInfo(ContextInfo contextInfo) {
            this.contextInfo = contextInfo;
            return this;
        }

        public SimpleAudioMessageBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public SimpleAudioMessageBuilder voiceMessage(boolean voiceMessage) {
            this.voiceMessage = voiceMessage;
            return this;
        }

        public AudioMessage build() {
            return AudioMessage.customBuilder(this.media, this.contextInfo, this.mimeType, this.voiceMessage);
        }

        public String toString() {
            return "AudioMessage.SimpleAudioMessageBuilder(media=" + Arrays.toString(this.media) + ", contextInfo=" + this.contextInfo + ", mimeType=" + this.mimeType + ", voiceMessage=" + this.voiceMessage + ")";
        }
    }
}

