/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.button.template.hsm.HighlyStructuredFourRowTemplateTitle;
import it.auties.whatsapp.model.button.template.hsm.HighlyStructuredFourRowTemplateTitleType;
import it.auties.whatsapp.model.button.template.hydrated.HydratedFourRowTemplateTitle;
import it.auties.whatsapp.model.button.template.hydrated.HydratedFourRowTemplateTitleType;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.interactive.InteractiveHeaderAttachment;
import it.auties.whatsapp.model.message.button.ButtonsMessageHeader;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.message.model.MediaMessage;
import it.auties.whatsapp.model.message.model.MediaMessageType;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.Medias;
import it.auties.whatsapp.util.Validate;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;

@JsonDeserialize(builder=DocumentMessageBuilderImpl.class)
public final class DocumentMessage
extends MediaMessage
implements InteractiveHeaderAttachment,
ButtonsMessageHeader,
HighlyStructuredFourRowTemplateTitle,
HydratedFourRowTemplateTitle {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    private String mediaUrl;
    @ProtobufProperty(index=2, type=ProtobufType.STRING)
    private String mimetype;
    @ProtobufProperty(index=3, type=ProtobufType.STRING)
    private String title;
    @ProtobufProperty(index=4, type=ProtobufType.BYTES)
    private byte[] mediaSha256;
    @ProtobufProperty(index=5, type=ProtobufType.UINT64)
    private long mediaSize;
    @ProtobufProperty(index=6, type=ProtobufType.UINT32)
    private Integer pageCount;
    @ProtobufProperty(index=7, type=ProtobufType.BYTES)
    private byte[] mediaKey;
    @ProtobufProperty(index=8, type=ProtobufType.STRING)
    private String fileName;
    @ProtobufProperty(index=9, type=ProtobufType.BYTES)
    private byte[] mediaEncryptedSha256;
    @ProtobufProperty(index=10, type=ProtobufType.STRING)
    private String mediaDirectPath;
    @ProtobufProperty(index=11, type=ProtobufType.UINT64)
    private long mediaKeyTimestamp;
    @ProtobufProperty(index=16, type=ProtobufType.BYTES)
    private byte[] thumbnail;
    @ProtobufProperty(index=12, name="contactVcard", type=ProtobufType.BOOL)
    private Boolean contactVcard;
    @ProtobufProperty(index=13, name="thumbnailDirectPath", type=ProtobufType.STRING)
    private String thumbnailDirectPath;
    @ProtobufProperty(index=14, name="thumbnailSha256", type=ProtobufType.BYTES)
    private byte[] thumbnailSha256;
    @ProtobufProperty(index=15, name="thumbnailEncSha256", type=ProtobufType.BYTES)
    private byte[] thumbnailEncSha256;
    @ProtobufProperty(index=18, name="thumbnailHeight", type=ProtobufType.UINT32)
    private Integer thumbnailHeight;
    @ProtobufProperty(index=19, name="thumbnailWidth", type=ProtobufType.UINT32)
    private Integer thumbnailWidth;
    @ProtobufProperty(index=20, name="caption", type=ProtobufType.STRING)
    private String caption;

    private static DocumentMessage customBuilder(byte[] media, @NonNull String fileName, String mimeType, String title, int pageCount, byte[] thumbnail, ContextInfo contextInfo) {
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        int extensionIndex = fileName.lastIndexOf(".");
        Validate.isTrue(extensionIndex != -1 && extensionIndex + 1 < fileName.length(), "Expected fileName to be formatted as name.extension", new Object[0]);
        String extension = fileName.substring(extensionIndex + 1);
        String actualMimeType = Optional.ofNullable(mimeType).or(() -> Medias.getMimeType(fileName)).or(() -> Medias.getMimeType(media)).orElse(MediaMessageType.DOCUMENT.defaultMimeType());
        return ((DocumentMessageBuilder)((ContextualMessage.ContextualMessageBuilder)((DocumentMessageBuilder)((DocumentMessageBuilder)((DocumentMessageBuilder)((DocumentMessageBuilder)((DocumentMessageBuilder)((DocumentMessageBuilder)((DocumentMessageBuilder)((DocumentMessageBuilder)DocumentMessage.builder().decodedMedia(media)).mediaKeyTimestamp(Clock.nowSeconds())).mimetype(actualMimeType)).fileName(fileName)).pageCount(pageCount > 0 ? pageCount : Medias.getPagesCount(media, extension).orElse(1))).title(title)).thumbnail(thumbnail != null ? null : (byte[])Medias.getThumbnail(media, extension).orElse(null))).thumbnailWidth(480)).thumbnailHeight(339)).contextInfo(Objects.requireNonNullElseGet(contextInfo, ContextInfo::new))).build();
    }

    @Override
    public MediaMessageType mediaType() {
        return MediaMessageType.DOCUMENT;
    }

    @Override
    public HighlyStructuredFourRowTemplateTitleType titleType() {
        return HighlyStructuredFourRowTemplateTitleType.DOCUMENT;
    }

    @Override
    public HydratedFourRowTemplateTitleType hydratedTitleType() {
        return HydratedFourRowTemplateTitleType.DOCUMENT;
    }

    protected DocumentMessage(DocumentMessageBuilder<?, ?> b) {
        super((MediaMessage.MediaMessageBuilder<?, ?>)b);
        this.mediaUrl = b.mediaUrl;
        this.mimetype = b.mimetype;
        this.title = b.title;
        this.mediaSha256 = b.mediaSha256;
        this.mediaSize = b.mediaSize;
        this.pageCount = b.pageCount;
        this.mediaKey = b.mediaKey;
        this.fileName = b.fileName;
        this.mediaEncryptedSha256 = b.mediaEncryptedSha256;
        this.mediaDirectPath = b.mediaDirectPath;
        this.mediaKeyTimestamp = b.mediaKeyTimestamp;
        this.thumbnail = b.thumbnail;
        this.contactVcard = b.contactVcard;
        this.thumbnailDirectPath = b.thumbnailDirectPath;
        this.thumbnailSha256 = b.thumbnailSha256;
        this.thumbnailEncSha256 = b.thumbnailEncSha256;
        this.thumbnailHeight = b.thumbnailHeight;
        this.thumbnailWidth = b.thumbnailWidth;
        this.caption = b.caption;
    }

    public static DocumentMessageBuilder<?, ?> builder() {
        return new DocumentMessageBuilderImpl();
    }

    public static SimpleDocumentMessageBuilder simpleBuilder() {
        return new SimpleDocumentMessageBuilder();
    }

    public DocumentMessage(String mediaUrl, String mimetype, String title, byte[] mediaSha256, long mediaSize, Integer pageCount, byte[] mediaKey, String fileName, byte[] mediaEncryptedSha256, String mediaDirectPath, long mediaKeyTimestamp, byte[] thumbnail, Boolean contactVcard, String thumbnailDirectPath, byte[] thumbnailSha256, byte[] thumbnailEncSha256, Integer thumbnailHeight, Integer thumbnailWidth, String caption) {
        this.mediaUrl = mediaUrl;
        this.mimetype = mimetype;
        this.title = title;
        this.mediaSha256 = mediaSha256;
        this.mediaSize = mediaSize;
        this.pageCount = pageCount;
        this.mediaKey = mediaKey;
        this.fileName = fileName;
        this.mediaEncryptedSha256 = mediaEncryptedSha256;
        this.mediaDirectPath = mediaDirectPath;
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        this.thumbnail = thumbnail;
        this.contactVcard = contactVcard;
        this.thumbnailDirectPath = thumbnailDirectPath;
        this.thumbnailSha256 = thumbnailSha256;
        this.thumbnailEncSha256 = thumbnailEncSha256;
        this.thumbnailHeight = thumbnailHeight;
        this.thumbnailWidth = thumbnailWidth;
        this.caption = caption;
    }

    public DocumentMessage() {
    }

    @Override
    public String mediaUrl() {
        return this.mediaUrl;
    }

    public String mimetype() {
        return this.mimetype;
    }

    public String title() {
        return this.title;
    }

    @Override
    public byte[] mediaSha256() {
        return this.mediaSha256;
    }

    @Override
    public long mediaSize() {
        return this.mediaSize;
    }

    public Integer pageCount() {
        return this.pageCount;
    }

    @Override
    public byte[] mediaKey() {
        return this.mediaKey;
    }

    public String fileName() {
        return this.fileName;
    }

    @Override
    public byte[] mediaEncryptedSha256() {
        return this.mediaEncryptedSha256;
    }

    @Override
    public String mediaDirectPath() {
        return this.mediaDirectPath;
    }

    @Override
    public long mediaKeyTimestamp() {
        return this.mediaKeyTimestamp;
    }

    public byte[] thumbnail() {
        return this.thumbnail;
    }

    public Boolean contactVcard() {
        return this.contactVcard;
    }

    public String thumbnailDirectPath() {
        return this.thumbnailDirectPath;
    }

    public byte[] thumbnailSha256() {
        return this.thumbnailSha256;
    }

    public byte[] thumbnailEncSha256() {
        return this.thumbnailEncSha256;
    }

    public Integer thumbnailHeight() {
        return this.thumbnailHeight;
    }

    public Integer thumbnailWidth() {
        return this.thumbnailWidth;
    }

    public String caption() {
        return this.caption;
    }

    @Override
    public DocumentMessage mediaUrl(String mediaUrl) {
        this.mediaUrl = mediaUrl;
        return this;
    }

    public DocumentMessage mimetype(String mimetype) {
        this.mimetype = mimetype;
        return this;
    }

    public DocumentMessage title(String title) {
        this.title = title;
        return this;
    }

    @Override
    public DocumentMessage mediaSha256(byte[] mediaSha256) {
        this.mediaSha256 = mediaSha256;
        return this;
    }

    @Override
    public DocumentMessage mediaSize(long mediaSize) {
        this.mediaSize = mediaSize;
        return this;
    }

    public DocumentMessage pageCount(Integer pageCount) {
        this.pageCount = pageCount;
        return this;
    }

    @Override
    public DocumentMessage mediaKey(byte[] mediaKey) {
        this.mediaKey = mediaKey;
        return this;
    }

    public DocumentMessage fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Override
    public DocumentMessage mediaEncryptedSha256(byte[] mediaEncryptedSha256) {
        this.mediaEncryptedSha256 = mediaEncryptedSha256;
        return this;
    }

    @Override
    public DocumentMessage mediaDirectPath(String mediaDirectPath) {
        this.mediaDirectPath = mediaDirectPath;
        return this;
    }

    public DocumentMessage mediaKeyTimestamp(long mediaKeyTimestamp) {
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        return this;
    }

    public DocumentMessage thumbnail(byte[] thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    public DocumentMessage contactVcard(Boolean contactVcard) {
        this.contactVcard = contactVcard;
        return this;
    }

    public DocumentMessage thumbnailDirectPath(String thumbnailDirectPath) {
        this.thumbnailDirectPath = thumbnailDirectPath;
        return this;
    }

    public DocumentMessage thumbnailSha256(byte[] thumbnailSha256) {
        this.thumbnailSha256 = thumbnailSha256;
        return this;
    }

    public DocumentMessage thumbnailEncSha256(byte[] thumbnailEncSha256) {
        this.thumbnailEncSha256 = thumbnailEncSha256;
        return this;
    }

    public DocumentMessage thumbnailHeight(Integer thumbnailHeight) {
        this.thumbnailHeight = thumbnailHeight;
        return this;
    }

    public DocumentMessage thumbnailWidth(Integer thumbnailWidth) {
        this.thumbnailWidth = thumbnailWidth;
        return this;
    }

    public DocumentMessage caption(String caption) {
        this.caption = caption;
        return this;
    }

    @Override
    public String toString() {
        return "DocumentMessage(super=" + super.toString() + ", mediaUrl=" + this.mediaUrl() + ", mimetype=" + this.mimetype() + ", title=" + this.title() + ", mediaSha256=" + Arrays.toString(this.mediaSha256()) + ", mediaSize=" + this.mediaSize() + ", pageCount=" + this.pageCount() + ", mediaKey=" + Arrays.toString(this.mediaKey()) + ", fileName=" + this.fileName() + ", mediaEncryptedSha256=" + Arrays.toString(this.mediaEncryptedSha256()) + ", mediaDirectPath=" + this.mediaDirectPath() + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp() + ", thumbnail=" + Arrays.toString(this.thumbnail()) + ", contactVcard=" + this.contactVcard() + ", thumbnailDirectPath=" + this.thumbnailDirectPath() + ", thumbnailSha256=" + Arrays.toString(this.thumbnailSha256()) + ", thumbnailEncSha256=" + Arrays.toString(this.thumbnailEncSha256()) + ", thumbnailHeight=" + this.thumbnailHeight() + ", thumbnailWidth=" + this.thumbnailWidth() + ", caption=" + this.caption() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentMessage)) {
            return false;
        }
        DocumentMessage other = (DocumentMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.mediaSize() != other.mediaSize()) {
            return false;
        }
        if (this.mediaKeyTimestamp() != other.mediaKeyTimestamp()) {
            return false;
        }
        Integer this$pageCount = this.pageCount();
        Integer other$pageCount = other.pageCount();
        if (this$pageCount == null ? other$pageCount != null : !((Object)this$pageCount).equals(other$pageCount)) {
            return false;
        }
        Boolean this$contactVcard = this.contactVcard();
        Boolean other$contactVcard = other.contactVcard();
        if (this$contactVcard == null ? other$contactVcard != null : !((Object)this$contactVcard).equals(other$contactVcard)) {
            return false;
        }
        Integer this$thumbnailHeight = this.thumbnailHeight();
        Integer other$thumbnailHeight = other.thumbnailHeight();
        if (this$thumbnailHeight == null ? other$thumbnailHeight != null : !((Object)this$thumbnailHeight).equals(other$thumbnailHeight)) {
            return false;
        }
        Integer this$thumbnailWidth = this.thumbnailWidth();
        Integer other$thumbnailWidth = other.thumbnailWidth();
        if (this$thumbnailWidth == null ? other$thumbnailWidth != null : !((Object)this$thumbnailWidth).equals(other$thumbnailWidth)) {
            return false;
        }
        String this$mediaUrl = this.mediaUrl();
        String other$mediaUrl = other.mediaUrl();
        if (this$mediaUrl == null ? other$mediaUrl != null : !this$mediaUrl.equals(other$mediaUrl)) {
            return false;
        }
        String this$mimetype = this.mimetype();
        String other$mimetype = other.mimetype();
        if (this$mimetype == null ? other$mimetype != null : !this$mimetype.equals(other$mimetype)) {
            return false;
        }
        String this$title = this.title();
        String other$title = other.title();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        if (!Arrays.equals(this.mediaSha256(), other.mediaSha256())) {
            return false;
        }
        if (!Arrays.equals(this.mediaKey(), other.mediaKey())) {
            return false;
        }
        String this$fileName = this.fileName();
        String other$fileName = other.fileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        if (!Arrays.equals(this.mediaEncryptedSha256(), other.mediaEncryptedSha256())) {
            return false;
        }
        String this$mediaDirectPath = this.mediaDirectPath();
        String other$mediaDirectPath = other.mediaDirectPath();
        if (this$mediaDirectPath == null ? other$mediaDirectPath != null : !this$mediaDirectPath.equals(other$mediaDirectPath)) {
            return false;
        }
        if (!Arrays.equals(this.thumbnail(), other.thumbnail())) {
            return false;
        }
        String this$thumbnailDirectPath = this.thumbnailDirectPath();
        String other$thumbnailDirectPath = other.thumbnailDirectPath();
        if (this$thumbnailDirectPath == null ? other$thumbnailDirectPath != null : !this$thumbnailDirectPath.equals(other$thumbnailDirectPath)) {
            return false;
        }
        if (!Arrays.equals(this.thumbnailSha256(), other.thumbnailSha256())) {
            return false;
        }
        if (!Arrays.equals(this.thumbnailEncSha256(), other.thumbnailEncSha256())) {
            return false;
        }
        String this$caption = this.caption();
        String other$caption = other.caption();
        return !(this$caption == null ? other$caption != null : !this$caption.equals(other$caption));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DocumentMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $mediaSize = this.mediaSize();
        result = result * 59 + (int)($mediaSize >>> 32 ^ $mediaSize);
        long $mediaKeyTimestamp = this.mediaKeyTimestamp();
        result = result * 59 + (int)($mediaKeyTimestamp >>> 32 ^ $mediaKeyTimestamp);
        Integer $pageCount = this.pageCount();
        result = result * 59 + ($pageCount == null ? 43 : ((Object)$pageCount).hashCode());
        Boolean $contactVcard = this.contactVcard();
        result = result * 59 + ($contactVcard == null ? 43 : ((Object)$contactVcard).hashCode());
        Integer $thumbnailHeight = this.thumbnailHeight();
        result = result * 59 + ($thumbnailHeight == null ? 43 : ((Object)$thumbnailHeight).hashCode());
        Integer $thumbnailWidth = this.thumbnailWidth();
        result = result * 59 + ($thumbnailWidth == null ? 43 : ((Object)$thumbnailWidth).hashCode());
        String $mediaUrl = this.mediaUrl();
        result = result * 59 + ($mediaUrl == null ? 43 : $mediaUrl.hashCode());
        String $mimetype = this.mimetype();
        result = result * 59 + ($mimetype == null ? 43 : $mimetype.hashCode());
        String $title = this.title();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        result = result * 59 + Arrays.hashCode(this.mediaSha256());
        result = result * 59 + Arrays.hashCode(this.mediaKey());
        String $fileName = this.fileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        result = result * 59 + Arrays.hashCode(this.mediaEncryptedSha256());
        String $mediaDirectPath = this.mediaDirectPath();
        result = result * 59 + ($mediaDirectPath == null ? 43 : $mediaDirectPath.hashCode());
        result = result * 59 + Arrays.hashCode(this.thumbnail());
        String $thumbnailDirectPath = this.thumbnailDirectPath();
        result = result * 59 + ($thumbnailDirectPath == null ? 43 : $thumbnailDirectPath.hashCode());
        result = result * 59 + Arrays.hashCode(this.thumbnailSha256());
        result = result * 59 + Arrays.hashCode(this.thumbnailEncSha256());
        String $caption = this.caption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        return result;
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.caption != null) {
            protobufOutputStream.writeString(20, this.caption);
        }
        if (this.contextInfo != null) {
            protobufOutputStream.writeBytes(17, this.contextInfo.toEncodedProtobuf());
        }
        if (this.thumbnailHeight != null) {
            protobufOutputStream.writeUInt32(18, this.thumbnailHeight);
        }
        protobufOutputStream.writeUInt64(11, this.mediaKeyTimestamp);
        if (this.mediaUrl != null) {
            protobufOutputStream.writeString(1, this.mediaUrl);
        }
        if (this.thumbnail != null) {
            protobufOutputStream.writeBytes(16, this.thumbnail);
        }
        if (this.thumbnailEncSha256 != null) {
            protobufOutputStream.writeBytes(15, this.thumbnailEncSha256);
        }
        if (this.mediaEncryptedSha256 != null) {
            protobufOutputStream.writeBytes(9, this.mediaEncryptedSha256);
        }
        if (this.pageCount != null) {
            protobufOutputStream.writeUInt32(6, this.pageCount);
        }
        if (this.mediaKey != null) {
            protobufOutputStream.writeBytes(7, this.mediaKey);
        }
        if (this.contactVcard != null) {
            protobufOutputStream.writeBool(12, this.contactVcard);
        }
        protobufOutputStream.writeUInt64(5, this.mediaSize);
        if (this.fileName != null) {
            protobufOutputStream.writeString(8, this.fileName);
        }
        if (this.mediaDirectPath != null) {
            protobufOutputStream.writeString(10, this.mediaDirectPath);
        }
        if (this.thumbnailWidth != null) {
            protobufOutputStream.writeUInt32(19, this.thumbnailWidth);
        }
        if (this.mediaSha256 != null) {
            protobufOutputStream.writeBytes(4, this.mediaSha256);
        }
        if (this.thumbnailDirectPath != null) {
            protobufOutputStream.writeString(13, this.thumbnailDirectPath);
        }
        if (this.thumbnailSha256 != null) {
            protobufOutputStream.writeBytes(14, this.thumbnailSha256);
        }
        if (this.title != null) {
            protobufOutputStream.writeString(3, this.title);
        }
        if (this.mimetype != null) {
            protobufOutputStream.writeString(2, this.mimetype);
        }
        return protobufOutputStream.toByteArray();
    }

    public static DocumentMessage ofProtobuf(byte[] byArray) {
        int n;
        DocumentMessageBuilder<?, ?> documentMessageBuilder = DocumentMessage.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block22: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 20: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.caption(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block22;
                }
                case 17: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.contextInfo(ContextInfo.ofProtobuf(protobufInputStream.readBytes()));
                    continue block22;
                }
                case 18: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.thumbnailHeight(protobufInputStream.readInt32());
                    continue block22;
                }
                case 11: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.mediaKeyTimestamp(protobufInputStream.readInt64());
                    continue block22;
                }
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.mediaUrl(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block22;
                }
                case 16: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.thumbnail(protobufInputStream.readBytes());
                    continue block22;
                }
                case 15: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.thumbnailEncSha256(protobufInputStream.readBytes());
                    continue block22;
                }
                case 9: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.mediaEncryptedSha256(protobufInputStream.readBytes());
                    continue block22;
                }
                case 6: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.pageCount(protobufInputStream.readInt32());
                    continue block22;
                }
                case 7: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.mediaKey(protobufInputStream.readBytes());
                    continue block22;
                }
                case 12: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.contactVcard(protobufInputStream.readBool());
                    continue block22;
                }
                case 5: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.mediaSize(protobufInputStream.readInt64());
                    continue block22;
                }
                case 8: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.fileName(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block22;
                }
                case 10: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.mediaDirectPath(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block22;
                }
                case 19: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.thumbnailWidth(protobufInputStream.readInt32());
                    continue block22;
                }
                case 4: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.mediaSha256(protobufInputStream.readBytes());
                    continue block22;
                }
                case 13: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.thumbnailDirectPath(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block22;
                }
                case 14: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.thumbnailSha256(protobufInputStream.readBytes());
                    continue block22;
                }
                case 3: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.title(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block22;
                }
                case 2: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    documentMessageBuilder.mimetype(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block22;
                }
            }
            protobufInputStream.readBytes();
        }
        return documentMessageBuilder.build();
    }

    public static abstract class DocumentMessageBuilder<C extends DocumentMessage, B extends DocumentMessageBuilder<C, B>>
    extends MediaMessage.MediaMessageBuilder<C, B> {
        private String mediaUrl;
        private String mimetype;
        private String title;
        private byte[] mediaSha256;
        private long mediaSize;
        private Integer pageCount;
        private byte[] mediaKey;
        private String fileName;
        private byte[] mediaEncryptedSha256;
        private String mediaDirectPath;
        private long mediaKeyTimestamp;
        private byte[] thumbnail;
        private Boolean contactVcard;
        private String thumbnailDirectPath;
        private byte[] thumbnailSha256;
        private byte[] thumbnailEncSha256;
        private Integer thumbnailHeight;
        private Integer thumbnailWidth;
        private String caption;

        public B mediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return (B)this.self();
        }

        public B mimetype(String mimetype) {
            this.mimetype = mimetype;
            return (B)this.self();
        }

        public B title(String title) {
            this.title = title;
            return (B)this.self();
        }

        public B mediaSha256(byte[] mediaSha256) {
            this.mediaSha256 = mediaSha256;
            return (B)this.self();
        }

        public B mediaSize(long mediaSize) {
            this.mediaSize = mediaSize;
            return (B)this.self();
        }

        public B pageCount(Integer pageCount) {
            this.pageCount = pageCount;
            return (B)this.self();
        }

        public B mediaKey(byte[] mediaKey) {
            this.mediaKey = mediaKey;
            return (B)this.self();
        }

        public B fileName(String fileName) {
            this.fileName = fileName;
            return (B)this.self();
        }

        public B mediaEncryptedSha256(byte[] mediaEncryptedSha256) {
            this.mediaEncryptedSha256 = mediaEncryptedSha256;
            return (B)this.self();
        }

        public B mediaDirectPath(String mediaDirectPath) {
            this.mediaDirectPath = mediaDirectPath;
            return (B)this.self();
        }

        public B mediaKeyTimestamp(long mediaKeyTimestamp) {
            this.mediaKeyTimestamp = mediaKeyTimestamp;
            return (B)this.self();
        }

        public B thumbnail(byte[] thumbnail) {
            this.thumbnail = thumbnail;
            return (B)this.self();
        }

        public B contactVcard(Boolean contactVcard) {
            this.contactVcard = contactVcard;
            return (B)this.self();
        }

        public B thumbnailDirectPath(String thumbnailDirectPath) {
            this.thumbnailDirectPath = thumbnailDirectPath;
            return (B)this.self();
        }

        public B thumbnailSha256(byte[] thumbnailSha256) {
            this.thumbnailSha256 = thumbnailSha256;
            return (B)this.self();
        }

        public B thumbnailEncSha256(byte[] thumbnailEncSha256) {
            this.thumbnailEncSha256 = thumbnailEncSha256;
            return (B)this.self();
        }

        public B thumbnailHeight(Integer thumbnailHeight) {
            this.thumbnailHeight = thumbnailHeight;
            return (B)this.self();
        }

        public B thumbnailWidth(Integer thumbnailWidth) {
            this.thumbnailWidth = thumbnailWidth;
            return (B)this.self();
        }

        public B caption(String caption) {
            this.caption = caption;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "DocumentMessage.DocumentMessageBuilder(super=" + super.toString() + ", mediaUrl=" + this.mediaUrl + ", mimetype=" + this.mimetype + ", title=" + this.title + ", mediaSha256=" + Arrays.toString(this.mediaSha256) + ", mediaSize=" + this.mediaSize + ", pageCount=" + this.pageCount + ", mediaKey=" + Arrays.toString(this.mediaKey) + ", fileName=" + this.fileName + ", mediaEncryptedSha256=" + Arrays.toString(this.mediaEncryptedSha256) + ", mediaDirectPath=" + this.mediaDirectPath + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp + ", thumbnail=" + Arrays.toString(this.thumbnail) + ", contactVcard=" + this.contactVcard + ", thumbnailDirectPath=" + this.thumbnailDirectPath + ", thumbnailSha256=" + Arrays.toString(this.thumbnailSha256) + ", thumbnailEncSha256=" + Arrays.toString(this.thumbnailEncSha256) + ", thumbnailHeight=" + this.thumbnailHeight + ", thumbnailWidth=" + this.thumbnailWidth + ", caption=" + this.caption + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class DocumentMessageBuilderImpl
    extends DocumentMessageBuilder<DocumentMessage, DocumentMessageBuilderImpl> {
        private DocumentMessageBuilderImpl() {
        }

        @Override
        protected DocumentMessageBuilderImpl self() {
            return this;
        }

        @Override
        public DocumentMessage build() {
            return new DocumentMessage(this);
        }
    }

    public static class SimpleDocumentMessageBuilder {
        private byte[] media;
        private String fileName;
        private String mimeType;
        private String title;
        private int pageCount;
        private byte[] thumbnail;
        private ContextInfo contextInfo;

        SimpleDocumentMessageBuilder() {
        }

        public SimpleDocumentMessageBuilder media(byte[] media) {
            this.media = media;
            return this;
        }

        public SimpleDocumentMessageBuilder fileName(@NonNull String fileName) {
            if (fileName == null) {
                throw new NullPointerException("fileName is marked non-null but is null");
            }
            this.fileName = fileName;
            return this;
        }

        public SimpleDocumentMessageBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public SimpleDocumentMessageBuilder title(String title) {
            this.title = title;
            return this;
        }

        public SimpleDocumentMessageBuilder pageCount(int pageCount) {
            this.pageCount = pageCount;
            return this;
        }

        public SimpleDocumentMessageBuilder thumbnail(byte[] thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        public SimpleDocumentMessageBuilder contextInfo(ContextInfo contextInfo) {
            this.contextInfo = contextInfo;
            return this;
        }

        public DocumentMessage build() {
            return DocumentMessage.customBuilder(this.media, this.fileName, this.mimeType, this.title, this.pageCount, this.thumbnail, this.contextInfo);
        }

        public String toString() {
            return "DocumentMessage.SimpleDocumentMessageBuilder(media=" + Arrays.toString(this.media) + ", fileName=" + this.fileName + ", mimeType=" + this.mimeType + ", title=" + this.title + ", pageCount=" + this.pageCount + ", thumbnail=" + Arrays.toString(this.thumbnail) + ", contextInfo=" + this.contextInfo + ")";
        }
    }
}

