/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufName;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.message.model.Message;
import it.auties.whatsapp.model.message.model.MessageCategory;
import it.auties.whatsapp.model.message.model.MessageKey;
import it.auties.whatsapp.model.message.model.MessageType;
import it.auties.whatsapp.model.message.standard.PollCreationMessage;
import it.auties.whatsapp.model.poll.PollOption;
import it.auties.whatsapp.model.poll.PollUpdateEncryptedMetadata;
import it.auties.whatsapp.model.poll.PollUpdateMessageMetadata;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.Validate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;

@ProtobufName(value="PollUpdateMessage")
@JsonDeserialize(builder=PollUpdateMessageBuilder.class)
public final class PollUpdateMessage
implements Message {
    private static final String POLL_NAME = "Poll Vote";
    private ContactJid voter;
    @ProtobufProperty(index=1, name="pollCreationMessageKey", type=ProtobufType.MESSAGE)
    private MessageKey pollCreationMessageKey;
    private PollCreationMessage pollCreationMessage;
    private List<PollOption> votes;
    @ProtobufProperty(index=2, name="vote", type=ProtobufType.MESSAGE)
    private PollUpdateEncryptedMetadata encryptedMetadata;
    @ProtobufProperty(index=3, name="metadata", type=ProtobufType.MESSAGE)
    private PollUpdateMessageMetadata metadata;
    @ProtobufProperty(index=4, name="senderTimestampMs", type=ProtobufType.INT64)
    private long senderTimestampMilliseconds;

    public static PollUpdateMessage of(@NonNull MessageInfo poll, List<PollOption> votes) {
        if (poll == null) {
            throw new NullPointerException("poll is marked non-null but is null");
        }
        Validate.isTrue(poll.message().type() == MessageType.POLL_CREATION, "Expected a poll, got %s".formatted(new Object[]{poll.message().type()}), new Object[0]);
        return PollUpdateMessage.builder().pollCreationMessageKey(poll.key()).pollCreationMessage((PollCreationMessage)poll.message().content()).votes(Objects.requireNonNullElseGet(votes, List::of)).build();
    }

    public ZonedDateTime senderTimestamp() {
        return Clock.parseSeconds(this.senderTimestampMilliseconds);
    }

    public Optional<PollUpdateMessageMetadata> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public String secretName() {
        return POLL_NAME;
    }

    @Override
    public MessageType type() {
        return MessageType.POLL_UPDATE;
    }

    @Override
    public MessageCategory category() {
        return MessageCategory.STANDARD;
    }

    private static List<PollOption> $default$votes() {
        return new ArrayList<PollOption>();
    }

    private static long $default$senderTimestampMilliseconds() {
        return Clock.nowSeconds();
    }

    PollUpdateMessage(ContactJid voter, MessageKey pollCreationMessageKey, PollCreationMessage pollCreationMessage, List<PollOption> votes, PollUpdateEncryptedMetadata encryptedMetadata, PollUpdateMessageMetadata metadata, long senderTimestampMilliseconds) {
        this.voter = voter;
        this.pollCreationMessageKey = pollCreationMessageKey;
        this.pollCreationMessage = pollCreationMessage;
        this.votes = votes;
        this.encryptedMetadata = encryptedMetadata;
        this.metadata = metadata;
        this.senderTimestampMilliseconds = senderTimestampMilliseconds;
    }

    public static PollUpdateMessageBuilder builder() {
        return new PollUpdateMessageBuilder();
    }

    public static SimplePollUpdateMessageBuilder simpleBuilder() {
        return new SimplePollUpdateMessageBuilder();
    }

    public ContactJid voter() {
        return this.voter;
    }

    public MessageKey pollCreationMessageKey() {
        return this.pollCreationMessageKey;
    }

    public PollCreationMessage pollCreationMessage() {
        return this.pollCreationMessage;
    }

    public List<PollOption> votes() {
        return this.votes;
    }

    public PollUpdateEncryptedMetadata encryptedMetadata() {
        return this.encryptedMetadata;
    }

    public long senderTimestampMilliseconds() {
        return this.senderTimestampMilliseconds;
    }

    public PollUpdateMessage voter(ContactJid voter) {
        this.voter = voter;
        return this;
    }

    public PollUpdateMessage pollCreationMessageKey(MessageKey pollCreationMessageKey) {
        this.pollCreationMessageKey = pollCreationMessageKey;
        return this;
    }

    public PollUpdateMessage pollCreationMessage(PollCreationMessage pollCreationMessage) {
        this.pollCreationMessage = pollCreationMessage;
        return this;
    }

    public PollUpdateMessage votes(List<PollOption> votes) {
        this.votes = votes;
        return this;
    }

    public PollUpdateMessage encryptedMetadata(PollUpdateEncryptedMetadata encryptedMetadata) {
        this.encryptedMetadata = encryptedMetadata;
        return this;
    }

    public PollUpdateMessage metadata(PollUpdateMessageMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public PollUpdateMessage senderTimestampMilliseconds(long senderTimestampMilliseconds) {
        this.senderTimestampMilliseconds = senderTimestampMilliseconds;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PollUpdateMessage)) {
            return false;
        }
        PollUpdateMessage other = (PollUpdateMessage)o;
        if (this.senderTimestampMilliseconds() != other.senderTimestampMilliseconds()) {
            return false;
        }
        ContactJid this$voter = this.voter();
        ContactJid other$voter = other.voter();
        if (this$voter == null ? other$voter != null : !((Object)this$voter).equals(other$voter)) {
            return false;
        }
        MessageKey this$pollCreationMessageKey = this.pollCreationMessageKey();
        MessageKey other$pollCreationMessageKey = other.pollCreationMessageKey();
        if (this$pollCreationMessageKey == null ? other$pollCreationMessageKey != null : !((Object)this$pollCreationMessageKey).equals(other$pollCreationMessageKey)) {
            return false;
        }
        PollCreationMessage this$pollCreationMessage = this.pollCreationMessage();
        PollCreationMessage other$pollCreationMessage = other.pollCreationMessage();
        if (this$pollCreationMessage == null ? other$pollCreationMessage != null : !((Object)this$pollCreationMessage).equals(other$pollCreationMessage)) {
            return false;
        }
        List<PollOption> this$votes = this.votes();
        List<PollOption> other$votes = other.votes();
        if (this$votes == null ? other$votes != null : !((Object)this$votes).equals(other$votes)) {
            return false;
        }
        PollUpdateEncryptedMetadata this$encryptedMetadata = this.encryptedMetadata();
        PollUpdateEncryptedMetadata other$encryptedMetadata = other.encryptedMetadata();
        if (this$encryptedMetadata == null ? other$encryptedMetadata != null : !((Object)this$encryptedMetadata).equals(other$encryptedMetadata)) {
            return false;
        }
        Optional<PollUpdateMessageMetadata> this$metadata = this.metadata();
        Optional<PollUpdateMessageMetadata> other$metadata = other.metadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $senderTimestampMilliseconds = this.senderTimestampMilliseconds();
        result = result * 59 + (int)($senderTimestampMilliseconds >>> 32 ^ $senderTimestampMilliseconds);
        ContactJid $voter = this.voter();
        result = result * 59 + ($voter == null ? 43 : ((Object)$voter).hashCode());
        MessageKey $pollCreationMessageKey = this.pollCreationMessageKey();
        result = result * 59 + ($pollCreationMessageKey == null ? 43 : ((Object)$pollCreationMessageKey).hashCode());
        PollCreationMessage $pollCreationMessage = this.pollCreationMessage();
        result = result * 59 + ($pollCreationMessage == null ? 43 : ((Object)$pollCreationMessage).hashCode());
        List<PollOption> $votes = this.votes();
        result = result * 59 + ($votes == null ? 43 : ((Object)$votes).hashCode());
        PollUpdateEncryptedMetadata $encryptedMetadata = this.encryptedMetadata();
        result = result * 59 + ($encryptedMetadata == null ? 43 : ((Object)$encryptedMetadata).hashCode());
        Optional<PollUpdateMessageMetadata> $metadata = this.metadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "PollUpdateMessage(voter=" + this.voter() + ", pollCreationMessageKey=" + this.pollCreationMessageKey() + ", pollCreationMessage=" + this.pollCreationMessage() + ", votes=" + this.votes() + ", encryptedMetadata=" + this.encryptedMetadata() + ", metadata=" + this.metadata() + ", senderTimestampMilliseconds=" + this.senderTimestampMilliseconds() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        protobufOutputStream.writeInt64(4, this.senderTimestampMilliseconds);
        if (this.metadata != null) {
            protobufOutputStream.writeBytes(3, this.metadata.toEncodedProtobuf());
        }
        if (this.pollCreationMessageKey != null) {
            protobufOutputStream.writeBytes(1, this.pollCreationMessageKey.toEncodedProtobuf());
        }
        if (this.encryptedMetadata != null) {
            protobufOutputStream.writeBytes(2, this.encryptedMetadata.toEncodedProtobuf());
        }
        return protobufOutputStream.toByteArray();
    }

    public static PollUpdateMessage ofProtobuf(byte[] byArray) {
        int n;
        PollUpdateMessageBuilder pollUpdateMessageBuilder = PollUpdateMessage.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block6: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 4: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    pollUpdateMessageBuilder.senderTimestampMilliseconds(protobufInputStream.readInt64());
                    continue block6;
                }
                case 3: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    pollUpdateMessageBuilder.metadata(PollUpdateMessageMetadata.ofProtobuf(protobufInputStream.readBytes()));
                    continue block6;
                }
                case 1: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    pollUpdateMessageBuilder.pollCreationMessageKey(MessageKey.ofProtobuf(protobufInputStream.readBytes()));
                    continue block6;
                }
                case 2: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    pollUpdateMessageBuilder.encryptedMetadata(PollUpdateEncryptedMetadata.ofProtobuf(protobufInputStream.readBytes()));
                    continue block6;
                }
            }
            protobufInputStream.readBytes();
        }
        return pollUpdateMessageBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class PollUpdateMessageBuilder {
        private ContactJid voter;
        private MessageKey pollCreationMessageKey;
        private PollCreationMessage pollCreationMessage;
        private boolean votes$set;
        private List<PollOption> votes$value;
        private PollUpdateEncryptedMetadata encryptedMetadata;
        private PollUpdateMessageMetadata metadata;
        private boolean senderTimestampMilliseconds$set;
        private long senderTimestampMilliseconds$value;

        PollUpdateMessageBuilder() {
        }

        public PollUpdateMessageBuilder voter(ContactJid voter) {
            this.voter = voter;
            return this;
        }

        public PollUpdateMessageBuilder pollCreationMessageKey(MessageKey pollCreationMessageKey) {
            this.pollCreationMessageKey = pollCreationMessageKey;
            return this;
        }

        public PollUpdateMessageBuilder pollCreationMessage(PollCreationMessage pollCreationMessage) {
            this.pollCreationMessage = pollCreationMessage;
            return this;
        }

        public PollUpdateMessageBuilder votes(List<PollOption> votes) {
            this.votes$value = votes;
            this.votes$set = true;
            return this;
        }

        public PollUpdateMessageBuilder encryptedMetadata(PollUpdateEncryptedMetadata encryptedMetadata) {
            this.encryptedMetadata = encryptedMetadata;
            return this;
        }

        public PollUpdateMessageBuilder metadata(PollUpdateMessageMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public PollUpdateMessageBuilder senderTimestampMilliseconds(long senderTimestampMilliseconds) {
            this.senderTimestampMilliseconds$value = senderTimestampMilliseconds;
            this.senderTimestampMilliseconds$set = true;
            return this;
        }

        public PollUpdateMessage build() {
            List<PollOption> votes$value = this.votes$value;
            if (!this.votes$set) {
                votes$value = PollUpdateMessage.$default$votes();
            }
            long senderTimestampMilliseconds$value = this.senderTimestampMilliseconds$value;
            if (!this.senderTimestampMilliseconds$set) {
                senderTimestampMilliseconds$value = PollUpdateMessage.$default$senderTimestampMilliseconds();
            }
            return new PollUpdateMessage(this.voter, this.pollCreationMessageKey, this.pollCreationMessage, votes$value, this.encryptedMetadata, this.metadata, senderTimestampMilliseconds$value);
        }

        public String toString() {
            return "PollUpdateMessage.PollUpdateMessageBuilder(voter=" + this.voter + ", pollCreationMessageKey=" + this.pollCreationMessageKey + ", pollCreationMessage=" + this.pollCreationMessage + ", votes$value=" + this.votes$value + ", encryptedMetadata=" + this.encryptedMetadata + ", metadata=" + this.metadata + ", senderTimestampMilliseconds$value=" + this.senderTimestampMilliseconds$value + ")";
        }
    }

    public static class SimplePollUpdateMessageBuilder {
        private MessageInfo poll;
        private List<PollOption> votes;

        SimplePollUpdateMessageBuilder() {
        }

        public SimplePollUpdateMessageBuilder poll(@NonNull MessageInfo poll) {
            if (poll == null) {
                throw new NullPointerException("poll is marked non-null but is null");
            }
            this.poll = poll;
            return this;
        }

        public SimplePollUpdateMessageBuilder votes(List<PollOption> votes) {
            this.votes = votes;
            return this;
        }

        public PollUpdateMessage build() {
            return PollUpdateMessage.of(this.poll, this.votes);
        }

        public String toString() {
            return "PollUpdateMessage.SimplePollUpdateMessageBuilder(poll=" + this.poll + ", votes=" + this.votes + ")";
        }
    }
}

