/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.privacy;

import it.auties.whatsapp.util.Clock;
import java.time.ZonedDateTime;
import lombok.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface GdprAccountReport {
    public static Pending ofPending(long timestamp) {
        return new Pending(timestamp <= 0L ? ZonedDateTime.now().plusDays(3L) : Clock.parseSeconds(timestamp));
    }

    public static Ready ofReady() {
        return new Ready();
    }

    public static Error ofError() {
        return new Error();
    }

    public Type type();

    public record Pending(@NonNull ZonedDateTime dateTime) implements GdprAccountReport
    {
        public Pending(@NonNull ZonedDateTime dateTime) {
            if (dateTime == null) {
                throw new NullPointerException("dateTime is marked non-null but is null");
            }
        }

        @Override
        public Type type() {
            return Type.PENDING;
        }
    }

    public record Ready() implements GdprAccountReport
    {
        @Override
        public Type type() {
            return Type.READY;
        }
    }

    public record Error() implements GdprAccountReport
    {
        @Override
        public Type type() {
            return Type.ERROR;
        }
    }

    public static enum Type {
        PENDING,
        ERROR,
        READY;

    }
}

