/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufName;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.crypto.MD5;
import it.auties.whatsapp.util.Validate;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

@ProtobufName(value="AppVersion")
public class Version
implements ProtobufMessage {
    @ProtobufProperty(index=1, type=ProtobufType.UINT32)
    private Integer primary;
    @ProtobufProperty(index=2, type=ProtobufType.UINT32)
    private Integer secondary;
    @ProtobufProperty(index=3, type=ProtobufType.UINT32)
    private Integer tertiary;
    @ProtobufProperty(index=4, type=ProtobufType.UINT32)
    private Integer quaternary;
    @ProtobufProperty(index=5, type=ProtobufType.UINT32)
    private Integer quinary;

    @JsonCreator
    public Version(@NonNull String version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        String[] tokens = version.split("\\.", 5);
        Validate.isTrue(tokens.length <= 5, "Invalid number of tokens for version %s: %s", version, tokens);
        if (tokens.length > 0) {
            this.primary = Integer.parseInt(tokens[0]);
        }
        if (tokens.length > 1) {
            this.secondary = Integer.parseInt(tokens[1]);
        }
        if (tokens.length > 2) {
            this.tertiary = Integer.parseInt(tokens[2]);
        }
        if (tokens.length > 3) {
            this.quaternary = Integer.parseInt(tokens[3]);
        }
        if (tokens.length > 4) {
            this.quinary = Integer.parseInt(tokens[4]);
        }
    }

    public Version(int primary) {
        this.primary = primary;
    }

    public Version(int primary, int secondary, int tertiary) {
        this.primary = primary;
        this.secondary = secondary;
        this.tertiary = tertiary;
    }

    public byte[] toHash() {
        return MD5.calculate(this.toString());
    }

    @JsonValue
    public String toString() {
        return Stream.of(this.primary, this.secondary, this.tertiary, this.quaternary, this.quinary).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining("."));
    }

    public Version(Integer primary, Integer secondary, Integer tertiary, Integer quaternary, Integer quinary) {
        this.primary = primary;
        this.secondary = secondary;
        this.tertiary = tertiary;
        this.quaternary = quaternary;
        this.quinary = quinary;
    }

    public Integer primary() {
        return this.primary;
    }

    public Integer secondary() {
        return this.secondary;
    }

    public Integer tertiary() {
        return this.tertiary;
    }

    public Integer quaternary() {
        return this.quaternary;
    }

    public Integer quinary() {
        return this.quinary;
    }

    public Version primary(Integer primary) {
        this.primary = primary;
        return this;
    }

    public Version secondary(Integer secondary) {
        this.secondary = secondary;
        return this;
    }

    public Version tertiary(Integer tertiary) {
        this.tertiary = tertiary;
        return this;
    }

    public Version quaternary(Integer quaternary) {
        this.quaternary = quaternary;
        return this;
    }

    public Version quinary(Integer quinary) {
        this.quinary = quinary;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$primary = this.primary();
        Integer other$primary = other.primary();
        if (this$primary == null ? other$primary != null : !((Object)this$primary).equals(other$primary)) {
            return false;
        }
        Integer this$secondary = this.secondary();
        Integer other$secondary = other.secondary();
        if (this$secondary == null ? other$secondary != null : !((Object)this$secondary).equals(other$secondary)) {
            return false;
        }
        Integer this$tertiary = this.tertiary();
        Integer other$tertiary = other.tertiary();
        if (this$tertiary == null ? other$tertiary != null : !((Object)this$tertiary).equals(other$tertiary)) {
            return false;
        }
        Integer this$quaternary = this.quaternary();
        Integer other$quaternary = other.quaternary();
        if (this$quaternary == null ? other$quaternary != null : !((Object)this$quaternary).equals(other$quaternary)) {
            return false;
        }
        Integer this$quinary = this.quinary();
        Integer other$quinary = other.quinary();
        return !(this$quinary == null ? other$quinary != null : !((Object)this$quinary).equals(other$quinary));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Version;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $primary = this.primary();
        result = result * 59 + ($primary == null ? 43 : ((Object)$primary).hashCode());
        Integer $secondary = this.secondary();
        result = result * 59 + ($secondary == null ? 43 : ((Object)$secondary).hashCode());
        Integer $tertiary = this.tertiary();
        result = result * 59 + ($tertiary == null ? 43 : ((Object)$tertiary).hashCode());
        Integer $quaternary = this.quaternary();
        result = result * 59 + ($quaternary == null ? 43 : ((Object)$quaternary).hashCode());
        Integer $quinary = this.quinary();
        result = result * 59 + ($quinary == null ? 43 : ((Object)$quinary).hashCode());
        return result;
    }

    public static Version ofProtobuf(byte[] byArray) {
        throw new UnsupportedOperationException();
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.secondary != null) {
            protobufOutputStream.writeUInt32(2, this.secondary);
        }
        if (this.primary != null) {
            protobufOutputStream.writeUInt32(1, this.primary);
        }
        if (this.tertiary != null) {
            protobufOutputStream.writeUInt32(3, this.tertiary);
        }
        if (this.quaternary != null) {
            protobufOutputStream.writeUInt32(4, this.quaternary);
        }
        if (this.quinary != null) {
            protobufOutputStream.writeUInt32(5, this.quinary);
        }
        return protobufOutputStream.toByteArray();
    }
}

