/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.keypair;

import it.auties.whatsapp.model.request.Node;
import it.auties.whatsapp.model.signal.keypair.ISignalKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.util.KeyHelper;
import lombok.NonNull;

public record SignalPreKeyPair(int id, byte @NonNull [] publicKey, byte[] privateKey) implements ISignalKeyPair
{
    public SignalPreKeyPair(int id, byte[] publicKey, byte[] privateKey) {
        this.id = id;
        this.publicKey = KeyHelper.withoutHeader(publicKey);
        this.privateKey = privateKey;
    }

    public static SignalPreKeyPair random(int id) {
        SignalKeyPair keyPair = SignalKeyPair.random();
        return new SignalPreKeyPair(id, keyPair.publicKey(), keyPair.privateKey());
    }

    @Override
    public Node toNode() {
        return Node.of("key", Node.of("id", this.encodedId()), Node.of("value", this.publicKey()));
    }

    @Override
    public SignalKeyPair toGenericKeyPair() {
        return new SignalKeyPair(this.publicKey(), this.privateKey());
    }
}

