/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.keypair;

import it.auties.curve25519.Curve25519;
import it.auties.whatsapp.model.request.Node;
import it.auties.whatsapp.model.signal.keypair.ISignalKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.util.BytesHelper;
import java.util.NoSuchElementException;
import java.util.Optional;
import lombok.NonNull;

public record SignalSignedKeyPair(int id, @NonNull SignalKeyPair keyPair, byte[] signature) implements ISignalKeyPair
{
    public SignalSignedKeyPair(int id, @NonNull SignalKeyPair keyPair, byte[] signature) {
        if (keyPair == null) {
            throw new NullPointerException("keyPair is marked non-null but is null");
        }
    }

    public static SignalSignedKeyPair of(int id, @NonNull SignalKeyPair identityKeyPair) {
        if (identityKeyPair == null) {
            throw new NullPointerException("identityKeyPair is marked non-null but is null");
        }
        SignalKeyPair keyPair = SignalKeyPair.random();
        byte[] signature = Curve25519.sign((byte[])identityKeyPair.privateKey(), (byte[])keyPair.encodedPublicKey(), (boolean)true);
        return new SignalSignedKeyPair(id, keyPair, signature);
    }

    public static Optional<SignalSignedKeyPair> of(Node node) {
        if (node == null) {
            return Optional.empty();
        }
        Integer id = node.findNode("id").flatMap(Node::contentAsBytes).map(bytes -> BytesHelper.bytesToInt(bytes, 3)).orElseThrow(() -> new NoSuchElementException("Missing id in SignalSignedKeyPair"));
        byte[] publicKey = (byte[])node.findNode("value").flatMap(Node::contentAsBytes).orElseThrow(() -> new NoSuchElementException("Missing publicKey in SignalSignedKeyPair"));
        SignalKeyPair keyPair = new SignalKeyPair(publicKey, null);
        byte[] signature = node.findNode("signature").flatMap(Node::contentAsBytes).orElse(null);
        return Optional.of(new SignalSignedKeyPair(id, keyPair, signature));
    }

    @Override
    public byte[] privateKey() {
        return this.keyPair.privateKey();
    }

    @Override
    public Node toNode() {
        return Node.of("skey", Node.of("id", this.encodedId()), Node.of("value", this.publicKey()), Node.of("signature", this.signature()));
    }

    @Override
    public SignalKeyPair toGenericKeyPair() {
        return this.keyPair();
    }

    @Override
    public byte[] publicKey() {
        return this.keyPair.publicKey();
    }
}

