/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.message;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.signal.message.SignalProtocolMessage;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Protobuf;
import java.util.Arrays;
import lombok.NonNull;

@JsonDeserialize(builder=SignalDistributionMessageBuilder.class)
public final class SignalDistributionMessage
implements SignalProtocolMessage {
    private int version;
    @ProtobufProperty(index=1, type=ProtobufType.UINT32)
    private Integer id;
    @ProtobufProperty(index=2, type=ProtobufType.UINT32)
    private Integer iteration;
    @ProtobufProperty(index=3, type=ProtobufType.BYTES)
    private byte @NonNull [] chainKey;
    @ProtobufProperty(index=4, type=ProtobufType.BYTES)
    private byte @NonNull [] signingKey;
    private byte[] serialized;

    public SignalDistributionMessage(int id, int iteration, byte @NonNull [] chainKey, byte @NonNull [] signingKey) {
        if (chainKey == null) {
            throw new NullPointerException("chainKey is marked non-null but is null");
        }
        if (signingKey == null) {
            throw new NullPointerException("signingKey is marked non-null but is null");
        }
        this.version = 3;
        this.id = id;
        this.iteration = iteration;
        this.chainKey = chainKey;
        this.signingKey = signingKey;
        this.serialized = BytesHelper.concat(this.serializedVersion(), Protobuf.writeMessage(this));
    }

    public static SignalDistributionMessage ofSerialized(byte[] serialized) {
        return Protobuf.readMessage(Arrays.copyOfRange(serialized, 1, serialized.length), SignalDistributionMessage.class).version(BytesHelper.bytesToVersion(serialized[0])).serialized(serialized);
    }

    public static SignalDistributionMessageBuilder builder() {
        return new SignalDistributionMessageBuilder();
    }

    public SignalDistributionMessage(int version, Integer id, Integer iteration, byte @NonNull [] chainKey, byte @NonNull [] signingKey, byte[] serialized) {
        if (chainKey == null) {
            throw new NullPointerException("chainKey is marked non-null but is null");
        }
        if (signingKey == null) {
            throw new NullPointerException("signingKey is marked non-null but is null");
        }
        this.version = version;
        this.id = id;
        this.iteration = iteration;
        this.chainKey = chainKey;
        this.signingKey = signingKey;
        this.serialized = serialized;
    }

    @Override
    public int version() {
        return this.version;
    }

    public Integer id() {
        return this.id;
    }

    public Integer iteration() {
        return this.iteration;
    }

    public byte @NonNull [] chainKey() {
        return this.chainKey;
    }

    public byte @NonNull [] signingKey() {
        return this.signingKey;
    }

    @Override
    public byte[] serialized() {
        return this.serialized;
    }

    public SignalDistributionMessage version(int version) {
        this.version = version;
        return this;
    }

    public SignalDistributionMessage id(Integer id) {
        this.id = id;
        return this;
    }

    public SignalDistributionMessage iteration(Integer iteration) {
        this.iteration = iteration;
        return this;
    }

    public SignalDistributionMessage chainKey(byte @NonNull [] chainKey) {
        if (chainKey == null) {
            throw new NullPointerException("chainKey is marked non-null but is null");
        }
        this.chainKey = chainKey;
        return this;
    }

    public SignalDistributionMessage signingKey(byte @NonNull [] signingKey) {
        if (signingKey == null) {
            throw new NullPointerException("signingKey is marked non-null but is null");
        }
        this.signingKey = signingKey;
        return this;
    }

    public SignalDistributionMessage serialized(byte[] serialized) {
        this.serialized = serialized;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignalDistributionMessage)) {
            return false;
        }
        SignalDistributionMessage other = (SignalDistributionMessage)o;
        if (this.version() != other.version()) {
            return false;
        }
        Integer this$id = this.id();
        Integer other$id = other.id();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$iteration = this.iteration();
        Integer other$iteration = other.iteration();
        if (this$iteration == null ? other$iteration != null : !((Object)this$iteration).equals(other$iteration)) {
            return false;
        }
        if (!Arrays.equals(this.chainKey(), other.chainKey())) {
            return false;
        }
        if (!Arrays.equals(this.signingKey(), other.signingKey())) {
            return false;
        }
        return Arrays.equals(this.serialized(), other.serialized());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.version();
        Integer $id = this.id();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $iteration = this.iteration();
        result = result * 59 + ($iteration == null ? 43 : ((Object)$iteration).hashCode());
        result = result * 59 + Arrays.hashCode(this.chainKey());
        result = result * 59 + Arrays.hashCode(this.signingKey());
        result = result * 59 + Arrays.hashCode(this.serialized());
        return result;
    }

    public String toString() {
        return "SignalDistributionMessage(version=" + this.version() + ", id=" + this.id() + ", iteration=" + this.iteration() + ", chainKey=" + this.chainKey() + ", signingKey=" + this.signingKey() + ", serialized=" + Arrays.toString(this.serialized()) + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.signingKey != null) {
            protobufOutputStream.writeBytes(4, this.signingKey);
        }
        if (this.chainKey != null) {
            protobufOutputStream.writeBytes(3, this.chainKey);
        }
        if (this.id != null) {
            protobufOutputStream.writeUInt32(1, this.id);
        }
        if (this.iteration != null) {
            protobufOutputStream.writeUInt32(2, this.iteration);
        }
        return protobufOutputStream.toByteArray();
    }

    public static SignalDistributionMessage ofProtobuf(byte[] byArray) {
        int n;
        SignalDistributionMessageBuilder signalDistributionMessageBuilder = SignalDistributionMessage.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block6: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 4: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    signalDistributionMessageBuilder.signingKey(protobufInputStream.readBytes());
                    continue block6;
                }
                case 3: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    signalDistributionMessageBuilder.chainKey(protobufInputStream.readBytes());
                    continue block6;
                }
                case 1: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    signalDistributionMessageBuilder.id(protobufInputStream.readInt32());
                    continue block6;
                }
                case 2: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    signalDistributionMessageBuilder.iteration(protobufInputStream.readInt32());
                    continue block6;
                }
            }
            protobufInputStream.readBytes();
        }
        return signalDistributionMessageBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class SignalDistributionMessageBuilder {
        private int version;
        private Integer id;
        private Integer iteration;
        private byte @NonNull [] chainKey;
        private byte @NonNull [] signingKey;
        private byte[] serialized;

        SignalDistributionMessageBuilder() {
        }

        public SignalDistributionMessageBuilder version(int version) {
            this.version = version;
            return this;
        }

        public SignalDistributionMessageBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public SignalDistributionMessageBuilder iteration(Integer iteration) {
            this.iteration = iteration;
            return this;
        }

        public SignalDistributionMessageBuilder chainKey(byte @NonNull [] chainKey) {
            if (chainKey == null) {
                throw new NullPointerException("chainKey is marked non-null but is null");
            }
            this.chainKey = chainKey;
            return this;
        }

        public SignalDistributionMessageBuilder signingKey(byte @NonNull [] signingKey) {
            if (signingKey == null) {
                throw new NullPointerException("signingKey is marked non-null but is null");
            }
            this.signingKey = signingKey;
            return this;
        }

        public SignalDistributionMessageBuilder serialized(byte[] serialized) {
            this.serialized = serialized;
            return this;
        }

        public SignalDistributionMessage build() {
            return new SignalDistributionMessage(this.version, this.id, this.iteration, this.chainKey, this.signingKey, this.serialized);
        }

        public String toString() {
            return "SignalDistributionMessage.SignalDistributionMessageBuilder(version=" + this.version + ", id=" + this.id + ", iteration=" + this.iteration + ", chainKey=" + this.chainKey + ", signingKey=" + this.signingKey + ", serialized=" + Arrays.toString(this.serialized) + ")";
        }
    }
}

