/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.sender;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.signal.sender.SenderChainKey;
import it.auties.whatsapp.model.signal.sender.SenderMessageKey;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@JsonDeserialize(builder=SenderKeyStateBuilder.class)
public class SenderKeyState
implements ProtobufMessage {
    private final int id;
    private final SignalKeyPair signingKey;
    private final ConcurrentHashMap<Integer, SenderMessageKey> messageKeys;
    private SenderChainKey chainKey;

    public SenderKeyState(int id, int iteration, byte[] seed, SignalKeyPair signingKey) {
        this.id = id;
        this.chainKey = new SenderChainKey(iteration, seed);
        this.signingKey = signingKey;
        this.messageKeys = new ConcurrentHashMap();
    }

    public void addSenderMessageKey(SenderMessageKey senderMessageKey) {
        this.messageKeys.put(senderMessageKey.iteration(), senderMessageKey);
    }

    public Optional<SenderMessageKey> findSenderMessageKey(int iteration) {
        return Optional.ofNullable(this.messageKeys.get(iteration));
    }

    public int hashCode() {
        return Objects.hashCode(this.id());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof SenderKeyState)) return false;
        SenderKeyState that = (SenderKeyState)other;
        if (!Objects.equals(this.id(), that.id())) return false;
        return true;
    }

    public static SenderKeyStateBuilder builder() {
        return new SenderKeyStateBuilder();
    }

    public SenderKeyState(int id, SignalKeyPair signingKey, ConcurrentHashMap<Integer, SenderMessageKey> messageKeys, SenderChainKey chainKey) {
        this.id = id;
        this.signingKey = signingKey;
        this.messageKeys = messageKeys;
        this.chainKey = chainKey;
    }

    public int id() {
        return this.id;
    }

    public SignalKeyPair signingKey() {
        return this.signingKey;
    }

    public ConcurrentHashMap<Integer, SenderMessageKey> messageKeys() {
        return this.messageKeys;
    }

    public SenderChainKey chainKey() {
        return this.chainKey;
    }

    public SenderKeyState chainKey(SenderChainKey chainKey) {
        this.chainKey = chainKey;
        return this;
    }

    public String toString() {
        return "SenderKeyState(id=" + this.id() + ", signingKey=" + this.signingKey() + ", messageKeys=" + this.messageKeys() + ", chainKey=" + this.chainKey() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        return protobufOutputStream.toByteArray();
    }

    public static SenderKeyState ofProtobuf(byte[] byArray) {
        int n;
        SenderKeyStateBuilder senderKeyStateBuilder = SenderKeyState.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                default: 
            }
            protobufInputStream.readBytes();
        }
        return senderKeyStateBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class SenderKeyStateBuilder {
        private int id;
        private SignalKeyPair signingKey;
        private ConcurrentHashMap<Integer, SenderMessageKey> messageKeys;
        private SenderChainKey chainKey;

        SenderKeyStateBuilder() {
        }

        public SenderKeyStateBuilder id(int id) {
            this.id = id;
            return this;
        }

        public SenderKeyStateBuilder signingKey(SignalKeyPair signingKey) {
            this.signingKey = signingKey;
            return this;
        }

        public SenderKeyStateBuilder messageKeys(ConcurrentHashMap<Integer, SenderMessageKey> messageKeys) {
            this.messageKeys = messageKeys;
            return this;
        }

        public SenderKeyStateBuilder chainKey(SenderChainKey chainKey) {
            this.chainKey = chainKey;
            return this;
        }

        public SenderKeyState build() {
            return new SenderKeyState(this.id, this.signingKey, this.messageKeys, this.chainKey);
        }

        public String toString() {
            return "SenderKeyState.SenderKeyStateBuilder(id=" + this.id + ", signingKey=" + this.signingKey + ", messageKeys=" + this.messageKeys + ", chainKey=" + this.chainKey + ")";
        }
    }
}

