/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.session;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.whatsapp.model.signal.session.SessionState;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

@JsonDeserialize(builder=SessionBuilder.class)
public record Session(Set<@NonNull SessionState> states) {
    public Session(Set<SessionState> states) {
        this.states = Objects.requireNonNullElseGet(states, ConcurrentHashMap::newKeySet);
    }

    public Session() {
        this(ConcurrentHashMap.newKeySet());
    }

    public Session closeCurrentState() {
        Optional<SessionState> currentState = this.currentState();
        currentState.ifPresent(value -> value.closed(true));
        return this;
    }

    public Optional<SessionState> currentState() {
        return this.states.stream().filter(state -> !state.closed()).findFirst();
    }

    public boolean hasState(int version, byte[] baseKey) {
        return this.states.stream().anyMatch(state -> state.contentEquals(version, baseKey));
    }

    public Optional<SessionState> findState(int version, byte[] baseKey) {
        return this.states.stream().filter(state -> state.contentEquals(version, baseKey)).findFirst();
    }

    public void addState(SessionState state) {
        this.states.add(state);
    }

    public static SessionBuilder builder() {
        return new SessionBuilder();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class SessionBuilder {
        private Set<@NonNull SessionState> states;

        SessionBuilder() {
        }

        public SessionBuilder states(Set<@NonNull SessionState> states) {
            this.states = states;
            return this;
        }

        public Session build() {
            return new Session(this.states);
        }

        public String toString() {
            return "Session.SessionBuilder(states=" + this.states + ")";
        }
    }
}

