/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufName;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.message.model.MessageKey;
import it.auties.whatsapp.model.sync.HistorySyncMessage;
import it.auties.whatsapp.model.sync.SyncActionMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

@ProtobufName(value="SyncActionMessageRange")
@JsonDeserialize(builder=ActionMessageRangeSyncBuilder.class)
public class ActionMessageRangeSync
implements ProtobufMessage {
    @ProtobufProperty(index=1, type=ProtobufType.INT64)
    private Long lastMessageTimestamp;
    @ProtobufProperty(index=2, type=ProtobufType.INT64)
    private Long lastSystemMessageTimestamp;
    @ProtobufProperty(index=3, type=ProtobufType.MESSAGE, implementation=SyncActionMessage.class, repeated=true)
    private List<SyncActionMessage> messages;

    public ActionMessageRangeSync(@NonNull Chat chat, boolean allMessages) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        chat.newestMessage().ifPresent(message -> {
            this.lastMessageTimestamp = message.timestampSeconds();
        });
        chat.newestServerMessage().ifPresent(message -> {
            this.lastSystemMessageTimestamp = message.timestampSeconds();
        });
        this.messages = this.createMessages(chat, allMessages);
    }

    private List<SyncActionMessage> createMessages(Chat chat, boolean allMessages) {
        if (allMessages) {
            return chat.messages().stream().map(HistorySyncMessage::messageInfo).map(this::createActionMessage).toList();
        }
        return chat.newestMessage().map(this::createActionMessage).stream().toList();
    }

    private SyncActionMessage createActionMessage(MessageInfo info) {
        Long timestamp = info != null ? Long.valueOf(info.timestampSeconds()) : null;
        MessageKey key = info != null ? this.checkSenderKey(info.key().copy()) : null;
        return new SyncActionMessage(key, timestamp);
    }

    private MessageKey checkSenderKey(MessageKey key) {
        key.senderJid().ifPresent(jid -> key.senderJid(jid.toWhatsappJid()));
        return key;
    }

    public long lastMessageTimestamp() {
        return this.lastMessageTimestamp == null ? 0L : this.lastMessageTimestamp;
    }

    public long lastSystemMessageTimestamp() {
        return this.lastSystemMessageTimestamp == null ? 0L : this.lastSystemMessageTimestamp;
    }

    public List<SyncActionMessage> messages() {
        return Collections.unmodifiableList(this.messages == null ? List.of() : this.messages);
    }

    public static ActionMessageRangeSyncBuilder builder() {
        return new ActionMessageRangeSyncBuilder();
    }

    public ActionMessageRangeSync(Long lastMessageTimestamp, Long lastSystemMessageTimestamp, List<SyncActionMessage> messages) {
        this.lastMessageTimestamp = lastMessageTimestamp;
        this.lastSystemMessageTimestamp = lastSystemMessageTimestamp;
        this.messages = messages;
    }

    public ActionMessageRangeSync lastMessageTimestamp(Long lastMessageTimestamp) {
        this.lastMessageTimestamp = lastMessageTimestamp;
        return this;
    }

    public ActionMessageRangeSync lastSystemMessageTimestamp(Long lastSystemMessageTimestamp) {
        this.lastSystemMessageTimestamp = lastSystemMessageTimestamp;
        return this;
    }

    public ActionMessageRangeSync messages(List<SyncActionMessage> messages) {
        this.messages = messages;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionMessageRangeSync)) {
            return false;
        }
        ActionMessageRangeSync other = (ActionMessageRangeSync)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.lastMessageTimestamp() != other.lastMessageTimestamp()) {
            return false;
        }
        if (this.lastSystemMessageTimestamp() != other.lastSystemMessageTimestamp()) {
            return false;
        }
        List<SyncActionMessage> this$messages = this.messages();
        List<SyncActionMessage> other$messages = other.messages();
        return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActionMessageRangeSync;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lastMessageTimestamp = this.lastMessageTimestamp();
        result = result * 59 + (int)($lastMessageTimestamp >>> 32 ^ $lastMessageTimestamp);
        long $lastSystemMessageTimestamp = this.lastSystemMessageTimestamp();
        result = result * 59 + (int)($lastSystemMessageTimestamp >>> 32 ^ $lastSystemMessageTimestamp);
        List<SyncActionMessage> $messages = this.messages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        return result;
    }

    public String toString() {
        return "ActionMessageRangeSync(lastMessageTimestamp=" + this.lastMessageTimestamp() + ", lastSystemMessageTimestamp=" + this.lastSystemMessageTimestamp() + ", messages=" + this.messages() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.lastSystemMessageTimestamp != null) {
            protobufOutputStream.writeInt64(2, this.lastSystemMessageTimestamp);
        }
        if (this.lastMessageTimestamp != null) {
            protobufOutputStream.writeInt64(1, this.lastMessageTimestamp);
        }
        if (this.messages != null) {
            for (SyncActionMessage syncActionMessage : this.messages) {
                protobufOutputStream.writeBytes(3, syncActionMessage.toEncodedProtobuf());
            }
        }
        return protobufOutputStream.toByteArray();
    }

    public static ActionMessageRangeSync ofProtobuf(byte[] byArray) {
        int n;
        ActionMessageRangeSyncBuilder actionMessageRangeSyncBuilder = ActionMessageRangeSync.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        ArrayList<SyncActionMessage> arrayList = new ArrayList<SyncActionMessage>();
        block5: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 2: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    actionMessageRangeSyncBuilder.lastSystemMessageTimestamp(protobufInputStream.readInt64());
                    continue block5;
                }
                case 1: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    actionMessageRangeSyncBuilder.lastMessageTimestamp(protobufInputStream.readInt64());
                    continue block5;
                }
                case 3: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    arrayList.add(SyncActionMessage.ofProtobuf(protobufInputStream.readBytes()));
                    continue block5;
                }
            }
            protobufInputStream.readBytes();
        }
        actionMessageRangeSyncBuilder.messages(arrayList);
        return actionMessageRangeSyncBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ActionMessageRangeSyncBuilder {
        private Long lastMessageTimestamp;
        private Long lastSystemMessageTimestamp;
        private List<SyncActionMessage> messages;

        ActionMessageRangeSyncBuilder() {
        }

        public ActionMessageRangeSyncBuilder lastMessageTimestamp(Long lastMessageTimestamp) {
            this.lastMessageTimestamp = lastMessageTimestamp;
            return this;
        }

        public ActionMessageRangeSyncBuilder lastSystemMessageTimestamp(Long lastSystemMessageTimestamp) {
            this.lastSystemMessageTimestamp = lastSystemMessageTimestamp;
            return this;
        }

        public ActionMessageRangeSyncBuilder messages(List<SyncActionMessage> messages) {
            this.messages = messages;
            return this;
        }

        public ActionMessageRangeSync build() {
            return new ActionMessageRangeSync(this.lastMessageTimestamp, this.lastSystemMessageTimestamp, this.messages);
        }

        public String toString() {
            return "ActionMessageRangeSync.ActionMessageRangeSyncBuilder(lastMessageTimestamp=" + this.lastMessageTimestamp + ", lastSystemMessageTimestamp=" + this.lastSystemMessageTimestamp + ", messages=" + this.messages + ")";
        }
    }
}

