/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.binary.BinaryPatchType;
import it.auties.whatsapp.model.action.Action;
import it.auties.whatsapp.model.setting.Setting;
import it.auties.whatsapp.model.sync.ActionValueSync;
import it.auties.whatsapp.model.sync.RecordSync;
import it.auties.whatsapp.util.Json;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public record PatchRequest(BinaryPatchType type, List<PatchEntry> entries) {

    public record PatchEntry(ActionValueSync sync, String index, int version, RecordSync.Operation operation) {
        public static PatchEntry of(ActionValueSync sync, RecordSync.Operation operation) {
            return PatchEntry.of(sync, operation, 3, new String[0]);
        }

        public static PatchEntry of(ActionValueSync sync, RecordSync.Operation operation, int version, String ... args) {
            String index = Json.writeValueAsString(PatchEntry.createArguments(sync, args));
            return new PatchEntry(sync, index, version, operation);
        }

        private static List<String> createArguments(ActionValueSync sync, String ... args) {
            Action action = sync.action();
            if (action != null) {
                ArrayList<String> index = new ArrayList<String>();
                index.add(action.indexName());
                index.addAll(Arrays.asList(args));
                return index;
            }
            Setting setting = sync.setting();
            if (setting != null) {
                return List.of(setting.indexName());
            }
            throw new IllegalArgumentException("Cannot encode %s".formatted(sync));
        }
    }
}

