/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.socket;

import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.ErrorHandler;
import it.auties.whatsapp.binary.BinaryPatchType;
import it.auties.whatsapp.crypto.AesCbc;
import it.auties.whatsapp.crypto.Hmac;
import it.auties.whatsapp.crypto.LTHash;
import it.auties.whatsapp.exception.HmacValidationException;
import it.auties.whatsapp.model.action.Action;
import it.auties.whatsapp.model.action.ArchiveChatAction;
import it.auties.whatsapp.model.action.ClearChatAction;
import it.auties.whatsapp.model.action.ContactAction;
import it.auties.whatsapp.model.action.DeleteChatAction;
import it.auties.whatsapp.model.action.DeleteMessageForMeAction;
import it.auties.whatsapp.model.action.MarkChatAsReadAction;
import it.auties.whatsapp.model.action.MuteAction;
import it.auties.whatsapp.model.action.PinAction;
import it.auties.whatsapp.model.action.StarAction;
import it.auties.whatsapp.model.action.TimeFormatAction;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatMute;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.contact.ContactJidProvider;
import it.auties.whatsapp.model.info.MessageIndexInfo;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.request.Attributes;
import it.auties.whatsapp.model.request.Node;
import it.auties.whatsapp.model.setting.EphemeralSetting;
import it.auties.whatsapp.model.setting.LocaleSetting;
import it.auties.whatsapp.model.setting.PushNameSetting;
import it.auties.whatsapp.model.setting.Setting;
import it.auties.whatsapp.model.setting.UnarchiveChatsSetting;
import it.auties.whatsapp.model.sync.ActionDataSync;
import it.auties.whatsapp.model.sync.ActionMessageRangeSync;
import it.auties.whatsapp.model.sync.ActionValueSync;
import it.auties.whatsapp.model.sync.AppStateSyncKey;
import it.auties.whatsapp.model.sync.AppStateSyncKeyData;
import it.auties.whatsapp.model.sync.ExternalBlobReference;
import it.auties.whatsapp.model.sync.IndexSync;
import it.auties.whatsapp.model.sync.KeyId;
import it.auties.whatsapp.model.sync.LTHashState;
import it.auties.whatsapp.model.sync.MutationKeys;
import it.auties.whatsapp.model.sync.MutationSync;
import it.auties.whatsapp.model.sync.MutationsSync;
import it.auties.whatsapp.model.sync.PatchRequest;
import it.auties.whatsapp.model.sync.PatchSync;
import it.auties.whatsapp.model.sync.RecordSync;
import it.auties.whatsapp.model.sync.SnapshotSync;
import it.auties.whatsapp.model.sync.SyncActionMessage;
import it.auties.whatsapp.model.sync.Syncable;
import it.auties.whatsapp.model.sync.ValueSync;
import it.auties.whatsapp.model.sync.VersionSync;
import it.auties.whatsapp.socket.SocketHandler;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Medias;
import it.auties.whatsapp.util.Protobuf;
import it.auties.whatsapp.util.Validate;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

class AppStateHandler {
    private static final int TIMEOUT = 120;
    private static final int PULL_ATTEMPTS = 3;
    private final SocketHandler socketHandler;
    private final Map<BinaryPatchType, Integer> attempts;
    private ExecutorService executor;

    protected AppStateHandler(SocketHandler socketHandler) {
        this.socketHandler = socketHandler;
        this.attempts = new HashMap<BinaryPatchType, Integer>();
    }

    private synchronized ExecutorService getOrCreateAppService() {
        if (this.executor == null || this.executor.isShutdown()) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        return this.executor;
    }

    protected CompletableFuture<Void> push(@NonNull ContactJid jid, @NonNull List<PatchRequest> patches) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        if (patches == null) {
            throw new NullPointerException("patches is marked non-null but is null");
        }
        return this.runPushTask(() -> {
            ClientType clientType = this.socketHandler.store().clientType();
            CompletableFuture<Object> pullOperation = switch (clientType) {
                default -> throw new IncompatibleClassChangeError();
                case ClientType.MOBILE -> CompletableFuture.completedFuture(null);
                case ClientType.WEB -> this.pullUninterruptedly(jid, this.getPatchesTypes(patches));
            };
            return ((CompletableFuture)pullOperation.thenComposeAsync(ignored -> this.sendPush(jid, patches, clientType != ClientType.MOBILE))).orTimeout(120L, TimeUnit.SECONDS).exceptionallyAsync(throwable -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.PUSH_APP_STATE, (Throwable)throwable));
        });
    }

    private Set<BinaryPatchType> getPatchesTypes(List<PatchRequest> patches) {
        return patches.stream().map(PatchRequest::type).collect(Collectors.toUnmodifiableSet());
    }

    private CompletableFuture<Void> runPushTask(Supplier<CompletableFuture<?>> task) {
        ExecutorService executor = this.getOrCreateAppService();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        executor.execute(() -> {
            try {
                ((CompletableFuture)task.get()).join();
                future.complete(null);
            }
            catch (Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        });
        return future;
    }

    private CompletableFuture<Void> sendPush(ContactJid jid, List<PatchRequest> patches, boolean readPatches) {
        List<PushRequest> requests = patches.stream().map(entry -> this.createPushRequest(jid, (PatchRequest)entry)).toList();
        boolean mobile = this.socketHandler.store().clientType() == ClientType.MOBILE;
        List<Node> body = requests.stream().map(request -> this.createPushRequestNode((PushRequest)request, mobile)).toList();
        ConcurrentHashMap<String, Object> syncAttributes = Attributes.of(new Map.Entry[0]).put("data_namespace", (Object)3, mobile).toMap();
        Node sync = Node.of("sync", syncAttributes, body);
        return this.socketHandler.sendQuery("set", "w:sync:app:state", sync).thenRunAsync(() -> this.onPush(jid, requests, readPatches));
    }

    private PushRequest createPushRequest(ContactJid jid, PatchRequest request) {
        LTHashState oldState = this.socketHandler.keys().findHashStateByName(jid, request.type()).orElseGet(() -> new LTHashState(request.type()));
        LTHashState newState = oldState.copy();
        AppStateSyncKey key = this.socketHandler.keys().getLatestAppKey(jid);
        MutationKeys mutationKeys = MutationKeys.of(key.keyData().keyData());
        KeyId syncId = new KeyId(key.keyId().keyId());
        List<MutationResult> mutations = request.entries().stream().map(patch -> this.createMutationSync((PatchRequest.PatchEntry)patch, mutationKeys, key, syncId)).toList();
        LTHash newStateGenerator = new LTHash(newState);
        mutations.forEach(mutation -> newStateGenerator.mix(mutation.indexMac(), mutation.valueMac(), mutation.operation()));
        LTHash.Result result = newStateGenerator.finish();
        newState.hash(result.hash());
        newState.indexValueMap(result.indexValueMap());
        newState.version(newState.version() + 1L);
        byte[] snapshotMac = this.generateSnapshotMac(newState.hash(), newState.version(), request.type(), mutationKeys.snapshotMacKey());
        byte[][] concatValueMac = (byte[][])mutations.stream().map(MutationResult::valueMac).toArray(x$0 -> new byte[x$0][]);
        byte[] patchMac = this.generatePatchMac(snapshotMac, concatValueMac, newState.version(), request.type(), mutationKeys.patchMacKey());
        List<MutationSync> syncs = mutations.stream().map(MutationResult::sync).toList();
        PatchSync sync = PatchSync.builder().patchMac(patchMac).snapshotMac(snapshotMac).keyId(syncId).mutations(syncs).build();
        return new PushRequest(request.type(), oldState, newState, sync);
    }

    private MutationResult createMutationSync(PatchRequest.PatchEntry patch, MutationKeys mutationKeys, AppStateSyncKey key, KeyId syncId) {
        byte[] index = patch.index().getBytes(StandardCharsets.UTF_8);
        ActionDataSync actionData = ActionDataSync.builder().index(index).value(patch.sync()).padding(new byte[0]).version(patch.version()).build();
        byte[] encoded = Protobuf.writeMessage(actionData);
        byte[] encrypted = AesCbc.encryptAndPrefix(encoded, mutationKeys.encKey());
        byte[] valueMac = this.generateMac(patch.operation(), encrypted, key.keyId().keyId(), mutationKeys.macKey());
        byte[] indexMac = Hmac.calculateSha256(index, mutationKeys.indexKey());
        RecordSync record = RecordSync.builder().index(new IndexSync(indexMac)).value(new ValueSync(BytesHelper.concat(encrypted, valueMac))).keyId(syncId).build();
        MutationSync sync = MutationSync.builder().operation(patch.operation()).record(record).build();
        return new MutationResult(sync, indexMac, valueMac, patch.operation());
    }

    private Node createPushRequestNode(PushRequest request, boolean mobile) {
        long version = request.oldState().version();
        ConcurrentHashMap<String, Object> collectionAttributes = Attributes.of(new Map.Entry[0]).put("name", (Object)request.type()).put("version", (Object)version, !mobile).put("return_snapshot", (Object)false, !mobile).put("order", (Object)(request.type() != BinaryPatchType.CRITICAL_UNBLOCK_LOW ? "1" : "0"), mobile).toMap();
        return Node.of("collection", collectionAttributes, (Object)Node.of("patch", Protobuf.writeMessage(request.sync())));
    }

    private void onPush(ContactJid jid, List<PushRequest> requests, boolean readPatches) {
        requests.forEach(request -> {
            this.socketHandler.keys().putState(jid, request.newState());
            if (!readPatches) {
                return;
            }
            List<PatchSync> patches = List.of(request.sync().withVersion(new VersionSync(request.newState().version())));
            SyncRecord results = this.decodePatches(jid, request.type(), patches, request.oldState());
            results.records().forEach(this::processActions);
        });
    }

    protected void pull(BinaryPatchType ... patchTypes) {
        if (patchTypes == null || patchTypes.length == 0) {
            return;
        }
        this.getOrCreateAppService().execute(() -> ((CompletableFuture)this.pullUninterruptedly(this.socketHandler.store().jid(), Set.of(patchTypes)).thenAcceptAsync(success -> this.onPull(false, (boolean)success))).exceptionallyAsync(exception -> this.onPullError(false, (Throwable)exception)));
    }

    protected CompletableFuture<Void> pullInitial() {
        if (this.socketHandler.keys().initialAppSync()) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)this.pullUninterruptedly(this.socketHandler.store().jid(), Set.of(BinaryPatchType.values())).thenAcceptAsync(success -> this.onPull(true, (boolean)success))).exceptionallyAsync(exception -> this.onPullError(true, (Throwable)exception));
    }

    private void onPull(boolean initial, boolean success) {
        if (!this.socketHandler.keys().initialAppSync()) {
            this.socketHandler.keys().initialAppSync(initial && success || this.isSyncComplete());
        }
        this.attempts.clear();
    }

    private boolean isSyncComplete() {
        return Arrays.stream(BinaryPatchType.values()).allMatch(this::isSyncComplete);
    }

    private boolean isSyncComplete(BinaryPatchType entry) {
        return this.socketHandler.keys().findHashStateByName(this.socketHandler.store().jid(), entry).filter(type -> type.version() > 0L).isPresent();
    }

    private Void onPullError(boolean initial, Throwable exception) {
        this.attempts.clear();
        if (initial) {
            return (Void)this.socketHandler.handleFailure(ErrorHandler.Location.INITIAL_APP_STATE_SYNC, exception);
        }
        return (Void)this.socketHandler.handleFailure(ErrorHandler.Location.PULL_APP_STATE, exception);
    }

    private CompletableFuture<Boolean> pullUninterruptedly(ContactJid jid, Set<BinaryPatchType> patchTypes) {
        HashMap<BinaryPatchType, LTHashState> tempStates = new HashMap<BinaryPatchType, LTHashState>();
        List<Node> nodes = this.getPullNodes(jid, patchTypes, tempStates);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.socketHandler.sendQuery("set", "w:sync:app:state", Node.of("sync", nodes)).thenApplyAsync(this::parseSyncRequest)).thenApplyAsync(records -> this.decodeSyncs(jid, (Map<BinaryPatchType, LTHashState>)tempStates, (List<SnapshotSyncRecord>)records))).thenComposeAsync(remaining -> this.handlePullResult(jid, (Set<BinaryPatchType>)remaining))).orTimeout(120L, TimeUnit.SECONDS);
    }

    private CompletableFuture<Boolean> handlePullResult(ContactJid jid, Set<BinaryPatchType> remaining) {
        return remaining.isEmpty() ? CompletableFuture.completedFuture(true) : this.pullUninterruptedly(jid, remaining);
    }

    private List<Node> getPullNodes(ContactJid jid, Set<BinaryPatchType> patchTypes, Map<BinaryPatchType, LTHashState> tempStates) {
        return patchTypes.stream().map(name -> this.createStateWithVersion(jid, (BinaryPatchType)((Object)name))).peek(state -> tempStates.put(state.name(), (LTHashState)state)).map(LTHashState::toNode).toList();
    }

    private LTHashState createStateWithVersion(ContactJid jid, BinaryPatchType name) {
        return this.socketHandler.keys().findHashStateByName(jid, name).orElseGet(() -> new LTHashState(name));
    }

    private Set<BinaryPatchType> decodeSyncs(ContactJid jid, Map<BinaryPatchType, LTHashState> tempStates, List<SnapshotSyncRecord> records) {
        return records.stream().map(record -> {
            PatchChunk chunk = this.decodeSync(jid, (SnapshotSyncRecord)record, tempStates);
            chunk.records().forEach(this::processActions);
            return chunk;
        }).filter(PatchChunk::hasMore).map(PatchChunk::patchType).collect(Collectors.toUnmodifiableSet());
    }

    private PatchChunk decodeSync(ContactJid jid, SnapshotSyncRecord record, Map<BinaryPatchType, LTHashState> tempStates) {
        try {
            ArrayList<ActionDataSync> results = new ArrayList<ActionDataSync>();
            if (record.hasSnapshot()) {
                Optional<SyncRecord> snapshot = this.decodeSnapshot(jid, record.patchType(), record.snapshot());
                snapshot.ifPresent(decodedSnapshot -> {
                    results.addAll(decodedSnapshot.records());
                    tempStates.put(record.patchType(), decodedSnapshot.state());
                    this.socketHandler.keys().putState(jid, decodedSnapshot.state());
                });
            }
            if (record.hasPatches()) {
                SyncRecord decodedPatches = this.decodePatches(jid, record.patchType(), record.patches(), tempStates.get((Object)record.patchType()));
                results.addAll(decodedPatches.records());
                this.socketHandler.keys().putState(jid, decodedPatches.state());
            }
            return new PatchChunk(record.patchType(), results, record.hasMore());
        }
        catch (Throwable throwable) {
            LTHashState hashState = new LTHashState(record.patchType());
            this.socketHandler.keys().putState(jid, hashState);
            this.attempts.put(record.patchType(), this.attempts.getOrDefault((Object)record.patchType(), 0) + 1);
            if (this.attempts.get((Object)record.patchType()) >= 3) {
                throw new RuntimeException("Cannot parse patch(%s tries)".formatted(3), throwable);
            }
            return this.decodeSync(jid, record, tempStates);
        }
    }

    private List<SnapshotSyncRecord> parseSyncRequest(Node node) {
        return Stream.ofNullable(node).map(sync -> sync.findNodes("sync")).flatMap(Collection::stream).map(sync -> sync.findNodes("collection")).flatMap(Collection::stream).map(this::parseSync).flatMap(Optional::stream).toList();
    }

    private Optional<SnapshotSyncRecord> parseSync(Node sync) {
        BinaryPatchType name = BinaryPatchType.of(sync.attributes().getString("name"));
        String type = sync.attributes().getString("type");
        if (Objects.equals(type, "error")) {
            return Optional.empty();
        }
        boolean more = sync.attributes().getBoolean("has_more_patches");
        SnapshotSync snapshotSync = sync.findNode("snapshot").flatMap(this::decodeSnapshot).orElse(null);
        int versionCode = sync.attributes().getInt("version");
        List<PatchSync> patches = sync.findNode("patches").orElse(sync).findNodes("patch").stream().map(patch -> this.decodePatch((Node)patch, versionCode)).flatMap(Optional::stream).toList();
        return Optional.of(new SnapshotSyncRecord(name, snapshotSync, patches, more));
    }

    private Optional<SnapshotSync> decodeSnapshot(Node snapshot) {
        return snapshot == null ? Optional.empty() : snapshot.contentAsBytes().map(bytes -> Protobuf.readMessage(bytes, ExternalBlobReference.class)).map(Medias::download).flatMap(CompletableFuture::join).map(value -> Protobuf.readMessage(value, SnapshotSync.class));
    }

    private Optional<PatchSync> decodePatch(Node patch, long versionCode) {
        if (!patch.hasContent()) {
            return Optional.empty();
        }
        PatchSync patchSync = Protobuf.readMessage(patch.contentAsBytes().orElseThrow(), PatchSync.class);
        if (!patchSync.hasVersion()) {
            VersionSync version = new VersionSync(versionCode + 1L);
            patchSync.version(version);
        }
        return Optional.of(patchSync);
    }

    private void processActions(ActionDataSync mutation) {
        Optional<ActionValueSync.PrimaryFeature> features;
        Setting setting;
        ActionValueSync value = mutation.value();
        if (value == null) {
            return;
        }
        Action action = value.action();
        if (action != null) {
            MessageIndexInfo messageIndex = mutation.messageIndex();
            Optional targetContact = messageIndex.chatJid().flatMap(this.socketHandler.store()::findContactByJid);
            Optional targetChat = messageIndex.chatJid().flatMap(this.socketHandler.store()::findChatByJid);
            Optional targetMessage = targetChat.flatMap(chat -> this.socketHandler.store().findMessageById((ContactJidProvider)chat, mutation.messageIndex().messageId().orElse(null)));
            if (action instanceof ClearChatAction) {
                ClearChatAction clearChatAction = (ClearChatAction)action;
                this.clearMessages(targetChat.orElse(null), clearChatAction);
            } else if (action instanceof ContactAction) {
                ContactAction contactAction = (ContactAction)action;
                this.updateName(targetContact.orElseGet(() -> this.createContact(messageIndex)), targetChat.orElseGet(() -> this.createChat(messageIndex)), contactAction);
            } else if (action instanceof DeleteChatAction) {
                targetChat.ifPresent(Chat::removeMessages);
            } else if (action instanceof DeleteMessageForMeAction) {
                targetMessage.ifPresent(message -> targetChat.ifPresent(chat -> this.deleteMessage((MessageInfo)message, (Chat)chat)));
            } else if (action instanceof MarkChatAsReadAction) {
                MarkChatAsReadAction markAction = (MarkChatAsReadAction)action;
                targetChat.ifPresent(chat -> chat.unreadMessagesCount(markAction.read() ? 0 : -1));
            } else if (action instanceof MuteAction) {
                MuteAction muteAction = (MuteAction)action;
                targetChat.ifPresent(chat -> chat.mute(ChatMute.muted(muteAction.muteEndTimestampSeconds())));
            } else if (action instanceof PinAction) {
                PinAction pinAction = (PinAction)action;
                targetChat.ifPresent(chat -> chat.pinnedTimestampSeconds(pinAction.pinned() ? (int)mutation.value().timestamp() : 0));
            } else if (action instanceof StarAction) {
                StarAction starAction = (StarAction)action;
                targetMessage.ifPresent(message -> message.starred(starAction.starred()));
            } else if (action instanceof ArchiveChatAction) {
                ArchiveChatAction archiveChatAction = (ArchiveChatAction)action;
                targetChat.ifPresent(chat -> chat.archived(archiveChatAction.archived()));
            } else if (action instanceof TimeFormatAction) {
                TimeFormatAction timeFormatAction = (TimeFormatAction)action;
                this.socketHandler.store().twentyFourHourFormat(timeFormatAction.twentyFourHourFormatEnabled());
            }
            this.socketHandler.onAction(action, messageIndex);
        }
        if ((setting = value.setting()) != null) {
            if (setting instanceof EphemeralSetting) {
                EphemeralSetting ephemeralSetting = (EphemeralSetting)setting;
                this.showEphemeralMessageWarning(ephemeralSetting);
            } else if (setting instanceof LocaleSetting) {
                LocaleSetting localeSetting = (LocaleSetting)setting;
                this.socketHandler.updateLocale(localeSetting.locale(), this.socketHandler.store().locale());
            } else if (setting instanceof PushNameSetting) {
                PushNameSetting pushNameSetting = (PushNameSetting)setting;
                this.socketHandler.updateUserName(pushNameSetting.name(), this.socketHandler.store().name());
            } else if (setting instanceof UnarchiveChatsSetting) {
                UnarchiveChatsSetting unarchiveChatsSetting = (UnarchiveChatsSetting)setting;
                this.socketHandler.store().unarchiveChats(unarchiveChatsSetting.unarchiveChats());
            }
            this.socketHandler.onSetting(setting);
        }
        if ((features = mutation.value().primaryFeature()).isPresent() && !features.get().flags().isEmpty()) {
            this.socketHandler.onFeatures(features.get());
        }
    }

    private Chat createChat(MessageIndexInfo messageIndex) {
        ContactJid chat = messageIndex.chatJid().orElseThrow();
        return this.socketHandler.store().addNewChat(chat);
    }

    private Contact createContact(MessageIndexInfo messageIndex) {
        ContactJid chatJid = messageIndex.chatJid().orElseThrow();
        Contact contact = this.socketHandler.store().addContact(chatJid);
        this.socketHandler.onNewContact(contact);
        return contact;
    }

    private void showEphemeralMessageWarning(EphemeralSetting ephemeralSetting) {
        System.Logger logger = System.getLogger("AppStateHandler");
        logger.log(System.Logger.Level.WARNING, "An ephemeral status update was received as a setting. " + "Data: %s".formatted(ephemeralSetting) + "This should not be possible. Open an issue on Github please");
    }

    private void clearMessages(Chat targetChat, ClearChatAction clearChatAction) {
        if (targetChat == null) {
            return;
        }
        if (clearChatAction.messageRange().isEmpty()) {
            targetChat.removeMessages();
            return;
        }
        clearChatAction.messageRange().stream().map(ActionMessageRangeSync::messages).flatMap(Collection::stream).map(SyncActionMessage::key).filter(Objects::nonNull).forEach(key -> targetChat.removeMessage(entry -> Objects.equals(entry.id(), key.id())));
    }

    private void updateName(Contact contact, Chat chat, ContactAction contactAction) {
        contactAction.fullName().ifPresent(contact::fullName);
        contactAction.firstName().ifPresent(contact::shortName);
        chat.name(contactAction.name());
    }

    private void deleteMessage(MessageInfo message, Chat chat) {
        chat.removeMessage(message);
        this.socketHandler.onMessageDeleted(message, false);
    }

    private SyncRecord decodePatches(ContactJid jid, BinaryPatchType name, List<PatchSync> patches, LTHashState state) {
        LTHashState newState = state.copy();
        List<ActionDataSync> results = patches.stream().map(patch -> this.decodePatch(jid, name, newState, (PatchSync)patch)).map(MutationsRecord::records).flatMap(Collection::stream).toList();
        return new SyncRecord(newState, results);
    }

    private MutationsRecord decodePatch(ContactJid jid, BinaryPatchType patchType, LTHashState newState, PatchSync patch) {
        if (patch.hasExternalMutations()) {
            Medias.download(patch.externalMutations()).join().ifPresent(blob -> this.handleExternalMutation(patch, (byte[])blob));
        }
        newState.version(patch.encodedVersion());
        Optional<byte[]> syncMac = this.calculatePatchMac(jid, patch, patchType);
        Validate.isTrue(!this.socketHandler.store().checkPatchMacs() || syncMac.isEmpty() || Arrays.equals(syncMac.get(), patch.patchMac()), "sync_mac", HmacValidationException.class, new Object[0]);
        MutationsRecord mutations = this.decodeMutations(jid, patch.mutations(), newState);
        newState.hash(mutations.result().hash());
        newState.indexValueMap(mutations.result().indexValueMap());
        Optional<byte[]> snapshotMac = this.calculateSnapshotMac(jid, patchType, newState, patch);
        Validate.isTrue(!this.socketHandler.store().checkPatchMacs() || snapshotMac.isEmpty() || Arrays.equals(snapshotMac.get(), patch.snapshotMac()), "patch_mac", HmacValidationException.class, new Object[0]);
        return mutations;
    }

    private void handleExternalMutation(PatchSync patch, byte[] blob) {
        MutationsSync mutationsSync = Protobuf.readMessage(blob, MutationsSync.class);
        patch.mutations().addAll(mutationsSync.mutations());
    }

    private Optional<byte[]> calculateSnapshotMac(ContactJid jid, BinaryPatchType name, LTHashState newState, PatchSync patch) {
        return this.getMutationKeys(jid, patch.keyId()).map(mutationKeys -> this.generateSnapshotMac(newState.hash(), newState.version(), name, mutationKeys.snapshotMacKey()));
    }

    private Optional<byte[]> calculatePatchMac(ContactJid jid, PatchSync patch, BinaryPatchType patchType) {
        return this.getMutationKeys(jid, patch.keyId()).map(mutationKeys -> this.generatePatchMac(patch.snapshotMac(), this.getSyncMutationMac(patch), patch.encodedVersion(), patchType, mutationKeys.patchMacKey()));
    }

    private byte[][] getSyncMutationMac(PatchSync patch) {
        return (byte[][])patch.mutations().stream().map(mutation -> mutation.record().value().blob()).map(entry -> Arrays.copyOfRange(entry, ((byte[])entry).length - 32, ((byte[])entry).length)).toArray(x$0 -> new byte[x$0][]);
    }

    private Optional<SyncRecord> decodeSnapshot(ContactJid jid, BinaryPatchType name, SnapshotSync snapshot) {
        Optional<MutationKeys> mutationKeys = this.getMutationKeys(jid, snapshot.keyId());
        if (mutationKeys.isEmpty()) {
            return Optional.empty();
        }
        LTHashState newState = new LTHashState(name, snapshot.version().version());
        MutationsRecord mutations = this.decodeMutations(jid, snapshot.records(), newState);
        newState.hash(mutations.result().hash());
        newState.indexValueMap(mutations.result().indexValueMap());
        Validate.isTrue(!this.socketHandler.store().checkPatchMacs() || Arrays.equals(snapshot.mac(), this.generateSnapshotMac(newState.hash(), newState.version(), name, mutationKeys.get().snapshotMacKey())), "decode_snapshot", HmacValidationException.class, new Object[0]);
        return Optional.of(new SyncRecord(newState, mutations.records()));
    }

    private Optional<MutationKeys> getMutationKeys(ContactJid jid, KeyId snapshot) {
        return this.socketHandler.keys().findAppKeyById(jid, snapshot.id()).map(AppStateSyncKey::keyData).map(AppStateSyncKeyData::keyData).map(MutationKeys::of);
    }

    private MutationsRecord decodeMutations(ContactJid jid, List<? extends Syncable> syncs, LTHashState state) {
        LTHash generator = new LTHash(state);
        List<ActionDataSync> mutations = syncs.stream().map(mutation -> this.decodeMutation(jid, mutation.operation(), mutation.record(), generator)).flatMap(Optional::stream).collect(Collectors.toList());
        return new MutationsRecord(generator.finish(), mutations);
    }

    private Optional<ActionDataSync> decodeMutation(ContactJid jid, RecordSync.Operation operation, RecordSync sync, LTHash generator) {
        Optional<MutationKeys> mutationKeys = this.getMutationKeys(jid, sync.keyId());
        if (mutationKeys.isEmpty()) {
            return Optional.empty();
        }
        byte[] blob = sync.value().blob();
        byte[] encryptedBlob = Arrays.copyOfRange(blob, 0, blob.length - 32);
        byte[] encryptedMac = Arrays.copyOfRange(blob, blob.length - 32, blob.length);
        Validate.isTrue(!this.socketHandler.store().checkPatchMacs() || Arrays.equals(encryptedMac, this.generateMac(operation, encryptedBlob, sync.keyId().id(), mutationKeys.get().macKey())), "decode_mutation", HmacValidationException.class, new Object[0]);
        byte[] result = AesCbc.decrypt(encryptedBlob, mutationKeys.get().encKey());
        ActionDataSync actionSync = Protobuf.readMessage(result, ActionDataSync.class);
        Validate.isTrue(!this.socketHandler.store().checkPatchMacs() || Arrays.equals(sync.index().blob(), Hmac.calculateSha256(actionSync.index(), mutationKeys.get().indexKey())), "decode_mutation", HmacValidationException.class, new Object[0]);
        generator.mix(sync.index().blob(), encryptedMac, operation);
        return Optional.of(actionSync);
    }

    private byte[] generateMac(RecordSync.Operation operation, byte[] data, byte[] keyId, byte[] key) {
        byte[] keyData = BytesHelper.concat(operation.content(), keyId);
        byte[] last = new byte[8];
        last[last.length - 1] = (byte)keyData.length;
        byte[] total = BytesHelper.concat(keyData, data, last);
        byte[] sha512 = Hmac.calculateSha512(total, key);
        return Arrays.copyOfRange(sha512, 0, 32);
    }

    private byte[] generateSnapshotMac(byte[] ltHash, long version, BinaryPatchType patchType, byte[] key) {
        byte[] total = BytesHelper.concat(ltHash, BytesHelper.longToBytes(version), patchType.toString().getBytes(StandardCharsets.UTF_8));
        return Hmac.calculateSha256(total, key);
    }

    private byte[] generatePatchMac(byte[] snapshotMac, byte[][] valueMac, long version, BinaryPatchType patchType, byte[] key) {
        byte[] total = BytesHelper.concat(snapshotMac, BytesHelper.concat(valueMac), BytesHelper.longToBytes(version), patchType.toString().getBytes(StandardCharsets.UTF_8));
        return Hmac.calculateSha256(total, key);
    }

    protected void dispose() {
        this.attempts.clear();
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdownNow();
        }
    }

    private record PushRequest(BinaryPatchType type, LTHashState oldState, LTHashState newState, PatchSync sync) {
    }

    public record MutationResult(MutationSync sync, byte[] indexMac, byte[] valueMac, RecordSync.Operation operation) {
    }

    private record SnapshotSyncRecord(BinaryPatchType patchType, SnapshotSync snapshot, List<PatchSync> patches, boolean hasMore) {
        public boolean hasSnapshot() {
            return this.snapshot != null;
        }

        public boolean hasPatches() {
            return this.patches != null && !this.patches.isEmpty();
        }
    }

    private record SyncRecord(LTHashState state, List<ActionDataSync> records) {
    }

    private record PatchChunk(BinaryPatchType patchType, List<ActionDataSync> records, boolean hasMore) {
    }

    private record MutationsRecord(LTHash.Result result, List<ActionDataSync> records) {
    }
}

