/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.socket;

import com.fasterxml.jackson.databind.ObjectMapper;
import it.auties.curve25519.Curve25519;
import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.DisconnectReason;
import it.auties.whatsapp.api.ErrorHandler;
import it.auties.whatsapp.api.PairingCodeHandler;
import it.auties.whatsapp.api.QrHandler;
import it.auties.whatsapp.api.SocketEvent;
import it.auties.whatsapp.api.WebVerificationSupport;
import it.auties.whatsapp.binary.BinaryPatchType;
import it.auties.whatsapp.crypto.AesGmc;
import it.auties.whatsapp.crypto.Hkdf;
import it.auties.whatsapp.crypto.Hmac;
import it.auties.whatsapp.exception.HmacValidationException;
import it.auties.whatsapp.model.business.BusinessCategory;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificate;
import it.auties.whatsapp.model.business.BusinessVerifiedNameDetails;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatEphemeralTimer;
import it.auties.whatsapp.model.chat.GroupRole;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.contact.ContactStatus;
import it.auties.whatsapp.model.info.MessageInfo;
import it.auties.whatsapp.model.media.MediaConnection;
import it.auties.whatsapp.model.message.model.MessageKey;
import it.auties.whatsapp.model.message.model.MessageStatus;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.privacy.PrivacySettingEntry;
import it.auties.whatsapp.model.privacy.PrivacySettingType;
import it.auties.whatsapp.model.privacy.PrivacySettingValue;
import it.auties.whatsapp.model.request.Attributes;
import it.auties.whatsapp.model.request.MessageSendRequest;
import it.auties.whatsapp.model.request.Node;
import it.auties.whatsapp.model.response.ContactStatusResponse;
import it.auties.whatsapp.model.signal.auth.DeviceIdentity;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentity;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentityHMAC;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalPreKeyPair;
import it.auties.whatsapp.socket.SocketHandler;
import it.auties.whatsapp.socket.SocketState;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.Protobuf;
import it.auties.whatsapp.util.Spec;
import it.auties.whatsapp.util.Validate;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;

class StreamHandler {
    private static final int REQUIRED_PRE_KEYS_SIZE = 5;
    private static final int PRE_KEYS_UPLOAD_CHUNK = 30;
    private static final int PING_INTERVAL = 30;
    private static final int MEDIA_CONNECTION_DEFAULT_INTERVAL = 60;
    private static final int MAX_ATTEMPTS = 5;
    private final SocketHandler socketHandler;
    private final WebVerificationSupport webVerificationSupport;
    private final Map<String, Integer> retries;
    private final AtomicBoolean badMac;
    private final AtomicReference<String> lastLinkCodeKey;
    private ScheduledExecutorService service;

    protected StreamHandler(SocketHandler socketHandler, WebVerificationSupport webVerificationSupport) {
        this.socketHandler = socketHandler;
        this.webVerificationSupport = webVerificationSupport;
        this.retries = new HashMap<String, Integer>();
        this.badMac = new AtomicBoolean();
        this.lastLinkCodeKey = new AtomicReference();
    }

    protected void digest(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        switch (node.description()) {
            case "ack": {
                this.digestAck(node);
                break;
            }
            case "call": {
                this.digestCall(node);
                break;
            }
            case "failure": {
                this.digestFailure(node);
                break;
            }
            case "ib": {
                this.digestIb(node);
                break;
            }
            case "iq": {
                this.digestIq(node);
                break;
            }
            case "receipt": {
                this.digestReceipt(node);
                break;
            }
            case "stream:error": {
                this.digestError(node);
                break;
            }
            case "success": {
                this.digestSuccess(node);
                break;
            }
            case "message": {
                this.socketHandler.decodeMessage(node);
                break;
            }
            case "notification": {
                this.digestNotification(node);
                break;
            }
            case "presence": 
            case "chatstate": {
                this.digestChatState(node);
                break;
            }
            case "xmlstreamend": {
                this.digestStreamEnd();
            }
        }
    }

    private void digestStreamEnd() {
        if (this.socketHandler.state() != SocketState.CONNECTED || this.badMac.get()) {
            return;
        }
        this.socketHandler.disconnect(DisconnectReason.DISCONNECTED);
    }

    private void digestFailure(Node node) {
        int reason = node.attributes().getInt("reason");
        if (reason == 401 || reason == 403 || reason == 405) {
            this.socketHandler.disconnect(DisconnectReason.LOGGED_OUT);
            return;
        }
        this.socketHandler.disconnect(DisconnectReason.RECONNECTING);
    }

    private void digestChatState(Node node) {
        CompletableFuture.runAsync(() -> {
            ContactJid chatJid = node.attributes().getJid("from").orElseThrow(() -> new NoSuchElementException("Missing from in chat state update"));
            ContactJid participantJid = node.attributes().getJid("participant").orElse(chatJid);
            this.updateContactPresence(chatJid, this.getUpdateType(node), participantJid);
        });
    }

    private ContactStatus getUpdateType(Node node) {
        Optional<Node> metadata = node.findNode();
        boolean recording = metadata.map(entry -> entry.attributes().getString("media")).filter(entry -> entry.equals("audio")).isPresent();
        if (recording) {
            return ContactStatus.RECORDING;
        }
        return node.attributes().getOptionalString("type").or(() -> metadata.map(Node::description)).flatMap(ContactStatus::of).orElse(ContactStatus.AVAILABLE);
    }

    private void updateContactPresence(ContactJid chatJid, ContactStatus status, ContactJid contact) {
        this.socketHandler.store().findChatByJid(chatJid).ifPresent(chat -> this.socketHandler.onUpdateChatPresence(status, contact, (Chat)chat));
    }

    private void digestReceipt(Node node) {
        Chat chat = node.attributes().getJid("from").filter(jid -> jid.type() != ContactJid.Type.STATUS).flatMap(this.socketHandler.store()::findChatByJid).orElse(null);
        this.getReceiptsMessageIds(node).stream().map(messageId -> chat == null ? this.socketHandler.store().findStatusById((String)messageId) : this.socketHandler.store().findMessageById(chat, (String)messageId)).flatMap(Optional::stream).forEach(message -> this.digestReceipt(node, chat, (MessageInfo)message));
        this.socketHandler.sendMessageAck(node);
    }

    private void digestReceipt(Node node, Chat chat, MessageInfo message) {
        Optional<String> type = node.attributes().getOptionalString("type");
        MessageStatus status = type.flatMap(MessageStatus::of).orElse(MessageStatus.DELIVERED);
        Contact participant = node.attributes().getJid("participant").flatMap(this.socketHandler.store()::findContactByJid).orElse(null);
        if (chat != null && chat.unreadMessagesCount() > 0) {
            chat.unreadMessagesCount(chat.unreadMessagesCount() - 1);
        }
        message.status(status);
        this.updateReceipt(status, chat, participant, message);
        this.socketHandler.onMessageStatus(status, participant, message, chat);
        if (Objects.equals(type.orElse(null), "retry")) {
            this.sendMessageRetry(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageRetry(MessageInfo message) {
        if (!message.fromMe()) {
            return;
        }
        Integer attempts = this.retries.getOrDefault(message.id(), 0);
        if (attempts > 5) {
            return;
        }
        try {
            boolean all = message.senderJid().device() == 0;
            this.socketHandler.querySessionsForcefully(message.senderJid());
            message.chat().participantsPreKeys().clear();
            MessageSendRequest request = MessageSendRequest.builder().info(message).recipients(all ? null : List.of(message.senderJid())).force(!all).build();
            this.socketHandler.sendMessage(request);
        }
        finally {
            this.retries.put(message.id(), attempts + 1);
        }
    }

    private void updateReceipt(MessageStatus status, Chat chat, Contact participant, MessageInfo message) {
        List<ContactJid> container = status == MessageStatus.READ ? message.receipt().readJids() : message.receipt().deliveredJids();
        container.add(participant != null ? participant.jid() : message.senderJid());
        if (chat != null && participant != null && chat.participants().size() != container.size()) {
            return;
        }
        switch (status) {
            case READ: {
                message.receipt().readTimestampSeconds(Clock.nowSeconds());
                break;
            }
            case PLAYED: {
                message.receipt().playedTimestampSeconds(Clock.nowSeconds());
            }
        }
    }

    private List<String> getReceiptsMessageIds(Node node) {
        List<String> messageIds = Stream.ofNullable(node.findNode("list")).flatMap(Optional::stream).map(list -> list.findNodes("item")).flatMap(Collection::stream).map(item -> item.attributes().getOptionalString("id")).flatMap(Optional::stream).collect(Collectors.toList());
        messageIds.add(node.attributes().getRequiredString("id"));
        return messageIds;
    }

    private void digestCall(Node node) {
        Node call = node.children().peekFirst();
        if (call == null) {
            return;
        }
        this.socketHandler.sendMessageAck(node);
    }

    private void digestAck(Node node) {
        int error = node.attributes().getInt("error");
        String messageId = node.id();
        ContactJid from = node.attributes().getJid("from").orElseThrow(() -> new NoSuchElementException("Cannot digest ack: missing from"));
        Optional<MessageInfo> match = this.socketHandler.store().findMessageById(from, messageId);
        if (error != 0) {
            match.ifPresent(message -> message.status(MessageStatus.ERROR));
        } else {
            match.filter(message -> message.status().index() < MessageStatus.SERVER_ACK.index()).ifPresent(message -> message.status(MessageStatus.SERVER_ACK));
        }
    }

    private void digestNotification(Node node) {
        String type;
        this.socketHandler.sendMessageAck(node);
        switch (type = node.attributes().getString("type", null)) {
            case "w:gp2": {
                this.handleGroupNotification(node);
                break;
            }
            case "server_sync": {
                this.handleServerSyncNotification(node);
                break;
            }
            case "account_sync": {
                this.handleAccountSyncNotification(node);
                break;
            }
            case "encrypt": {
                this.handleEncryptNotification(node);
                break;
            }
            case "picture": {
                this.handlePictureNotification(node);
                break;
            }
            case "registration": {
                this.handleRegistrationNotification(node);
                break;
            }
            case "link_code_companion_reg": {
                this.confirmCompanionWebRegistration(node);
            }
        }
    }

    private void confirmCompanionWebRegistration(Node node) {
        ContactJid phoneNumber = this.getPhoneNumberAsJid();
        Node linkCodeCompanionReg = node.findNode("link_code_companion_reg").orElseThrow(() -> new NoSuchElementException("Missing link_code_companion_reg: " + node));
        byte[] ref = (byte[])linkCodeCompanionReg.findNode("link_code_pairing_ref").flatMap(Node::contentAsBytes).orElseThrow(() -> new IllegalArgumentException("Missing link_code_pairing_ref: " + node));
        byte[] primaryIdentityPublicKey = (byte[])linkCodeCompanionReg.findNode("primary_identity_pub").flatMap(Node::contentAsBytes).orElseThrow(() -> new IllegalArgumentException("Missing primary_identity_pub: " + node));
        byte[] primaryEphemeralPublicKeyWrapped = (byte[])linkCodeCompanionReg.findNode("link_code_pairing_wrapped_primary_ephemeral_pub").flatMap(Node::contentAsBytes).orElseThrow(() -> new IllegalArgumentException("Missing link_code_pairing_wrapped_primary_ephemeral_pub: " + node));
        byte[] codePairingPublicKey = this.decipherLinkPublicKey(primaryEphemeralPublicKeyWrapped);
        byte[] companionSharedKey = Curve25519.sharedKey((byte[])codePairingPublicKey, (byte[])this.socketHandler.keys().companionKeyPair().privateKey());
        byte[] random = BytesHelper.random(32);
        byte[] linkCodeSalt = BytesHelper.random(32);
        byte[] linkCodePairingExpanded = Hkdf.extractAndExpand(companionSharedKey, linkCodeSalt, "link_code_pairing_key_bundle_encryption_key".getBytes(StandardCharsets.UTF_8), 32);
        byte[] encryptPayload = BytesHelper.concat(this.socketHandler.keys().identityKeyPair().publicKey(), primaryIdentityPublicKey, random);
        byte[] encryptIv = BytesHelper.random(12);
        byte[] encrypted = AesGmc.encrypt(encryptIv, encryptPayload, linkCodePairingExpanded);
        byte[] encryptedPayload = BytesHelper.concat(linkCodeSalt, encryptIv, encrypted);
        byte[] identitySharedKey = Curve25519.sharedKey((byte[])primaryIdentityPublicKey, (byte[])this.socketHandler.keys().identityKeyPair().privateKey());
        byte[] identityPayload = BytesHelper.concat(companionSharedKey, identitySharedKey, random);
        byte[] advSecretPublicKey = Hkdf.extractAndExpand(identityPayload, "adv_secret".getBytes(StandardCharsets.UTF_8), 32);
        this.socketHandler.keys().companionKeyPair(SignalKeyPair.of(advSecretPublicKey));
        Node confirmation = Node.of("link_code_companion_reg", Map.of("jid", phoneNumber, "stage", "companion_finish"), Node.of("link_code_pairing_wrapped_key_bundle", encryptedPayload), Node.of("companion_identity_public", this.socketHandler.keys().identityKeyPair().publicKey()), Node.of("link_code_pairing_ref", ref));
        this.socketHandler.sendQuery("set", "md", confirmation);
    }

    private byte[] decipherLinkPublicKey(byte[] primaryEphemeralPublicKeyWrapped) {
        try {
            byte[] salt = Arrays.copyOfRange(primaryEphemeralPublicKeyWrapped, 0, 32);
            SecretKey secretKey = this.generatePairingKey(this.lastLinkCodeKey.get(), salt);
            byte[] iv = Arrays.copyOfRange(primaryEphemeralPublicKeyWrapped, 32, 48);
            byte[] payload = Arrays.copyOfRange(primaryEphemeralPublicKeyWrapped, 48, 80);
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
            return cipher.doFinal(payload);
        }
        catch (GeneralSecurityException exception) {
            throw new RuntimeException("Cannot decipher link code pairing key", exception);
        }
    }

    private void handleRegistrationNotification(Node node) {
        Optional<Node> child = node.findNode("wa_old_registration");
        if (child.isEmpty()) {
            return;
        }
        Optional<Long> code = child.get().attributes().getOptionalLong("code");
        if (code.isEmpty()) {
            return;
        }
        this.socketHandler.onRegistrationCode(code.get());
    }

    private void handlePictureNotification(Node node) {
        ContactJid fromJid = node.attributes().getJid("from").orElseThrow(() -> new NoSuchElementException("Missing from in notification"));
        Chat fromChat = this.socketHandler.store().findChatByJid(fromJid).orElseGet(() -> this.socketHandler.store().addNewChat(fromJid));
        long timestamp = node.attributes().getLong("t");
        if (fromChat.isGroup()) {
            this.addMessageForGroupStubType(fromChat, MessageInfo.StubType.GROUP_CHANGE_ICON, timestamp, node);
            this.socketHandler.onGroupPictureChange(fromChat);
            return;
        }
        Contact fromContact = this.socketHandler.store().findContactByJid(fromJid).orElseGet(() -> {
            Contact contact = this.socketHandler.store().addContact(fromJid);
            this.socketHandler.onNewContact(contact);
            return contact;
        });
        this.socketHandler.onContactPictureChange(fromContact);
    }

    private void handleGroupNotification(Node node) {
        Optional<Node> child = node.findNode();
        if (child.isEmpty()) {
            return;
        }
        Optional<MessageInfo.StubType> stubType = MessageInfo.StubType.of(child.get().description());
        if (stubType.isEmpty()) {
            return;
        }
        this.handleGroupStubNotification(node, stubType.get());
    }

    private void handleGroupStubNotification(Node node, MessageInfo.StubType stubType) {
        long timestamp = node.attributes().getLong("t");
        ContactJid fromJid = node.attributes().getJid("from").orElseThrow(() -> new NoSuchElementException("Missing chat in notification"));
        Chat fromChat = this.socketHandler.store().findChatByJid(fromJid).orElseGet(() -> this.socketHandler.store().addNewChat(fromJid));
        this.addMessageForGroupStubType(fromChat, stubType, timestamp, node);
    }

    private void addMessageForGroupStubType(Chat chat, MessageInfo.StubType stubType, long timestamp, Node metadata) {
        ContactJid participantJid = metadata.attributes().getJid("participant").orElse(null);
        List<String> parameters = this.getStubTypeParameters(metadata);
        MessageKey key = MessageKey.builder().chatJid(chat.jid()).senderJid(participantJid).build();
        MessageInfo message = MessageInfo.builder().timestampSeconds(timestamp).key(key).ignore(true).stubType(stubType).stubParameters(parameters).senderJid(participantJid).build();
        this.socketHandler.store().attribute(message);
        chat.addNewMessage(message);
        this.socketHandler.onNewMessage(message, false);
        if (participantJid == null) {
            return;
        }
        this.handleGroupStubType(chat, stubType, participantJid);
    }

    private void handleGroupStubType(Chat chat, MessageInfo.StubType stubType, ContactJid participantJid) {
        switch (stubType) {
            case GROUP_PARTICIPANT_ADD: {
                chat.addParticipant(participantJid, GroupRole.USER);
                break;
            }
            case GROUP_PARTICIPANT_REMOVE: 
            case GROUP_PARTICIPANT_LEAVE: {
                chat.removeParticipant(participantJid);
                break;
            }
            case GROUP_PARTICIPANT_PROMOTE: {
                chat.findParticipant(participantJid).ifPresent(participant -> participant.role(GroupRole.ADMIN));
                break;
            }
            case GROUP_PARTICIPANT_DEMOTE: {
                chat.removeParticipant(participantJid).ifPresent(participant -> participant.role(GroupRole.USER));
            }
        }
    }

    private List<String> getStubTypeParameters(Node metadata) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add(mapper.writeValueAsString(metadata.attributes().toMap()));
            for (Node child : metadata.children()) {
                Attributes data = child.attributes();
                if (data.isEmpty()) continue;
                attributes.add(mapper.writeValueAsString(data.toMap()));
            }
            return Collections.unmodifiableList(attributes);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot encode stub parameters", exception);
        }
    }

    private void handleEncryptNotification(Node node) {
        ContactJid chat = node.attributes().getJid("from").orElseThrow(() -> new NoSuchElementException("Missing chat in notification"));
        if (!chat.isServerJid(ContactJid.Server.WHATSAPP)) {
            return;
        }
        long keysSize = node.findNode("count").orElseThrow(() -> new NoSuchElementException("Missing count in notification")).attributes().getLong("value");
        if (keysSize >= 5L) {
            return;
        }
        this.sendPreKeys();
    }

    private void handleAccountSyncNotification(Node node) {
        Optional<Node> child = node.findNode();
        if (child.isEmpty()) {
            return;
        }
        switch (child.get().description()) {
            case "devices": {
                this.handleDevices(child.get());
                break;
            }
            case "privacy": {
                this.changeUserPrivacySetting(child.get());
                break;
            }
            case "disappearing_mode": {
                this.updateUserDisappearingMode(child.get());
                break;
            }
            case "status": {
                this.updateUserStatus(true);
                break;
            }
            case "picture": {
                this.updateUserPicture(true);
                break;
            }
            case "blocklist": {
                this.updateBlocklist(child.orElse(null));
            }
        }
    }

    private void handleDevices(Node child) {
        String deviceHash = child.attributes().getString("dhash");
        this.socketHandler.store().deviceHash(deviceHash);
        LinkedHashMap devices = child.findNodes("device").stream().collect(Collectors.toMap(entry -> entry.attributes().getJid("jid").orElseThrow(), entry -> entry.attributes().getInt("key-index"), (first, second) -> second, LinkedHashMap::new));
        ContactJid companionJid = this.socketHandler.store().jid().toWhatsappJid();
        Integer companionDevice = (Integer)devices.remove(companionJid);
        devices.put(companionJid, companionDevice);
        this.socketHandler.store().linkedDevicesKeys(devices);
        this.socketHandler.onDevices(devices);
        Node keyIndexListNode = child.findNode("key-index-list").orElseThrow(() -> new NoSuchElementException("Missing index key node from device sync"));
        byte[] signedKeyIndexBytes = keyIndexListNode.contentAsBytes().orElseThrow(() -> new NoSuchElementException("Missing index key from device sync"));
        this.socketHandler.keys().signedKeyIndex(signedKeyIndexBytes);
        long signedKeyIndexTimestamp = keyIndexListNode.attributes().getLong("ts");
        this.socketHandler.keys().signedKeyIndexTimestamp(signedKeyIndexTimestamp);
    }

    private void updateBlocklist(Node child) {
        child.findNodes("item").forEach(this::updateBlocklistEntry);
    }

    private void updateBlocklistEntry(Node entry) {
        entry.attributes().getJid("jid").flatMap(this.socketHandler.store()::findContactByJid).ifPresent(contact -> {
            contact.blocked(Objects.equals(entry.attributes().getString("action"), "block"));
            this.socketHandler.onContactBlocked((Contact)contact);
        });
    }

    private void changeUserPrivacySetting(Node child) {
        List<Node> category = child.findNodes("category");
        category.forEach(entry -> this.addPrivacySetting((Node)entry, true));
    }

    private void updateUserDisappearingMode(Node child) {
        ChatEphemeralTimer timer = ChatEphemeralTimer.of(child.attributes().getLong("duration"));
        this.socketHandler.store().newChatsEphemeralTimer(timer);
    }

    private CompletableFuture<Void> addPrivacySetting(Node node, boolean update) {
        String privacySettingName = node.attributes().getString("name");
        PrivacySettingType privacyType = PrivacySettingType.of(privacySettingName).orElseThrow(() -> new NoSuchElementException("Unknown privacy option: %s".formatted(privacySettingName)));
        String privacyValueName = node.attributes().getString("value");
        PrivacySettingValue privacyValue = PrivacySettingValue.of(privacyValueName).orElseThrow(() -> new NoSuchElementException("Unknown privacy value: %s".formatted(privacyValueName)));
        if (!update) {
            return this.queryPrivacyExcludedContacts(privacyType, privacyValue).thenAcceptAsync(response -> this.socketHandler.store().addPrivacySetting(privacyType, new PrivacySettingEntry(privacyType, privacyValue, (List<ContactJid>)response)));
        }
        PrivacySettingEntry oldEntry = this.socketHandler.store().findPrivacySetting(privacyType);
        List<ContactJid> newValues = this.getUpdatedBlockedList(node, oldEntry, privacyValue);
        PrivacySettingEntry newEntry = new PrivacySettingEntry(privacyType, privacyValue, Collections.unmodifiableList(newValues));
        this.socketHandler.store().addPrivacySetting(privacyType, newEntry);
        this.socketHandler.onPrivacySettingChanged(oldEntry, newEntry);
        return CompletableFuture.completedFuture(null);
    }

    private List<ContactJid> getUpdatedBlockedList(Node node, PrivacySettingEntry privacyEntry, PrivacySettingValue privacyValue) {
        if (privacyValue != PrivacySettingValue.CONTACTS_EXCEPT) {
            return List.of();
        }
        ArrayList<ContactJid> newValues = new ArrayList<ContactJid>(privacyEntry.excluded());
        for (Node entry : node.findNodes("user")) {
            ContactJid jid = entry.attributes().getJid("jid").orElseThrow(() -> new NoSuchElementException("Missing jid in response: %s".formatted(entry)));
            if (entry.attributes().hasKey("action", "add")) {
                newValues.add(jid);
                continue;
            }
            newValues.remove(jid);
        }
        return newValues;
    }

    private CompletableFuture<List<ContactJid>> queryPrivacyExcludedContacts(PrivacySettingType type, PrivacySettingValue value) {
        if (value != PrivacySettingValue.CONTACTS_EXCEPT) {
            return CompletableFuture.completedFuture(List.of());
        }
        return this.socketHandler.sendQuery("get", "privacy", Node.of("privacy", (Object)Node.of("list", Map.of("name", type.data(), "value", value.data())))).thenApplyAsync(this::parsePrivacyExcludedContacts);
    }

    private List<ContactJid> parsePrivacyExcludedContacts(Node result) {
        return result.findNode("privacy").orElseThrow(() -> new NoSuchElementException("Missing privacy in result: %s".formatted(result))).findNode("list").orElseThrow(() -> new NoSuchElementException("Missing list in result: %s".formatted(result))).findNodes("user").stream().map(user -> user.attributes().getJid("jid")).flatMap(Optional::stream).toList();
    }

    private void handleServerSyncNotification(Node node) {
        BinaryPatchType[] patches = (BinaryPatchType[])node.findNodes("collection").stream().map(entry -> entry.attributes().getRequiredString("name")).map(BinaryPatchType::of).toArray(BinaryPatchType[]::new);
        this.socketHandler.pullPatch(patches);
    }

    private void digestIb(Node node) {
        Optional<Node> dirty = node.findNode("dirty");
        if (dirty.isEmpty()) {
            Validate.isTrue(!node.hasNode("downgrade_webclient"), "Multi device beta is not enabled. Please enable it from Whatsapp", new Object[0]);
            return;
        }
        String type = dirty.get().attributes().getString("type");
        if (!Objects.equals(type, "account_sync")) {
            return;
        }
        String timestamp = dirty.get().attributes().getString("timestamp");
        this.socketHandler.sendQuery("set", "urn:xmpp:whatsapp:dirty", Node.of("clean", Map.of("type", type, "timestamp", timestamp)));
    }

    private void digestError(Node node) {
        if (node.hasNode("bad-mac")) {
            this.badMac.set(true);
            this.socketHandler.handleFailure(ErrorHandler.Location.CRYPTOGRAPHY, new RuntimeException("Detected a bad mac, last node: %s".formatted(this.socketHandler.lastNode())));
            return;
        }
        int statusCode = node.attributes().getInt("code");
        switch (statusCode) {
            case 503: 
            case 515: {
                this.socketHandler.disconnect(DisconnectReason.RECONNECTING);
                break;
            }
            case 401: {
                this.handleStreamError(node);
                break;
            }
            default: {
                node.children().forEach(error -> this.socketHandler.store().resolvePendingRequest((Node)error, true));
            }
        }
    }

    private void handleStreamError(Node node) {
        Node child = node.children().getFirst();
        String type = child.attributes().getString("type");
        String reason = child.attributes().getString("reason", type);
        if (!Objects.equals(reason, "device_removed")) {
            this.socketHandler.handleFailure(ErrorHandler.Location.STREAM, new RuntimeException(reason));
            return;
        }
        this.socketHandler.disconnect(DisconnectReason.LOGGED_OUT);
    }

    private void digestSuccess(Node node) {
        node.attributes().getJid("lid").ifPresent(this.socketHandler.store()::lid);
        this.socketHandler.sendQuery("set", "passive", Node.of("active"));
        if (!this.socketHandler.keys().hasPreKeys()) {
            this.sendPreKeys();
        }
        this.schedulePing();
        this.createMediaConnection(0, null);
        CompletionStage loggedInFuture = ((CompletableFuture)this.queryInitialInfo().thenRunAsync(this::onInitialInfo)).exceptionallyAsync(throwable -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)throwable));
        if (!this.socketHandler.keys().registered()) {
            return;
        }
        CompletionStage chatsFuture = this.socketHandler.store().serializer().attributeStore(this.socketHandler.store()).exceptionallyAsync(exception -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.MESSAGE, (Throwable)exception));
        CompletableFuture.allOf(new CompletableFuture[]{loggedInFuture, chatsFuture}).thenRunAsync(this.socketHandler::onChats);
    }

    private CompletableFuture<Node> setBusinessCertificate() {
        BusinessVerifiedNameDetails details = BusinessVerifiedNameDetails.builder().name("").issuer("smb:wa").serial(Math.abs(new SecureRandom().nextLong())).build();
        byte[] encodedDetails = Protobuf.writeMessage(details);
        BusinessVerifiedNameCertificate certificate = BusinessVerifiedNameCertificate.builder().details(encodedDetails).signature(Curve25519.sign((byte[])this.socketHandler.keys().identityKeyPair().privateKey(), (byte[])encodedDetails, (boolean)true)).build();
        return this.socketHandler.sendQuery("set", "w:biz", Node.of("verified_name", Map.of("v", 2), (Object)Protobuf.writeMessage(certificate)));
    }

    private CompletableFuture<Node> setBusinessProfile() {
        String version = this.socketHandler.store().properties().get("biz_profile_options");
        ArrayList body = new ArrayList();
        this.socketHandler.store().businessAddress().ifPresent(value -> body.add(Node.of("address", value)));
        this.socketHandler.store().businessLongitude().ifPresent(value -> body.add(Node.of("longitude", value)));
        this.socketHandler.store().businessLatitude().ifPresent(value -> body.add(Node.of("latitude", value)));
        this.socketHandler.store().businessDescription().ifPresent(value -> body.add(Node.of("description", value)));
        this.socketHandler.store().businessWebsite().ifPresent(value -> body.add(Node.of("website", value)));
        this.socketHandler.store().businessEmail().ifPresent(value -> body.add(Node.of("email", value)));
        return this.getBusinessCategoryNode().thenComposeAsync(result -> {
            body.add(Node.of("categories", (Object)Node.of("category", Map.of("id", result.id()))));
            return this.socketHandler.sendQuery("set", "w:biz", Node.of("business_profile", Map.of("v", version), (Object)body));
        });
    }

    private CompletableFuture<Node> getBusinessCategoryNode() {
        return this.socketHandler.store().businessCategory().map(businessCategory -> CompletableFuture.completedFuture(Node.of("category", Map.of("id", businessCategory.id())))).orElseGet(() -> this.socketHandler.queryBusinessCategories().thenApplyAsync(entries -> Node.of("category", Map.of("id", ((BusinessCategory)entries.get(0)).id()))));
    }

    private synchronized void schedulePing() {
        if (this.service != null && !this.service.isShutdown()) {
            return;
        }
        this.service = Executors.newSingleThreadScheduledExecutor();
        this.service.scheduleAtFixedRate(this::sendPing, 30L, 30L, TimeUnit.SECONDS);
    }

    private void onInitialInfo() {
        this.socketHandler.onLoggedIn();
        if (!this.socketHandler.keys().registered()) {
            if (this.socketHandler.store().clientType() == ClientType.WEB) {
                this.socketHandler.keys().registered(true);
            }
            return;
        }
        this.socketHandler.onContacts();
    }

    private CompletableFuture<Void> queryInitialInfo() {
        return this.queryRequiredInfo().thenComposeAsync(ignored -> CompletableFuture.allOf(this.updateSelfPresence(), this.queryInitialBlockList(), this.queryInitialPrivacySettings(), this.updateUserStatus(false), this.updateUserPicture(false)));
    }

    private CompletableFuture<Void> queryRequiredInfo() {
        return switch (this.socketHandler.store().clientType()) {
            default -> throw new IncompatibleClassChangeError();
            case ClientType.WEB -> {
                CompletionStage requiredFuture = ((CompletableFuture)this.socketHandler.sendQuery("get", "w", Node.of("props")).thenAcceptAsync(this::parseProps)).exceptionallyAsync(exception -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)exception));
                this.socketHandler.sendQuery("get", "abt", Node.of("props", Map.of("protocol", "1"))).exceptionallyAsync(exception -> (Node)this.socketHandler.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)exception));
                yield requiredFuture;
            }
            case ClientType.MOBILE -> {
                CompletionStage requiredFuture = ((CompletableFuture)((CompletableFuture)this.socketHandler.sendQuery("get", "w", Node.of("props", Map.of("protocol", "2", "hash", ""))).thenAcceptAsync(this::parseProps)).thenComposeAsync(ignored -> this.checkBusinessStatus())).exceptionallyAsync(exception -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)exception));
                this.socketHandler.sendQuery("get", "urn:xmpp:whatsapp:push", Node.of("config", Map.of("version", 1))).exceptionallyAsync(exception -> (Node)this.socketHandler.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)exception));
                this.socketHandler.store().locale(Objects.requireNonNullElse(this.socketHandler.store().locale(), "en-US"));
                this.socketHandler.sendQuery("set", "urn:xmpp:whatsapp:dirty", Node.of("clean", Map.of("timestamp", 0, "type", "account_sync"))).exceptionallyAsync(exception -> (Node)this.socketHandler.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)exception));
                if (this.socketHandler.store().business()) {
                    this.socketHandler.sendQuery("get", "fb:thrift_iq", Map.of("smax_id", 42), Node.of("linked_accounts")).exceptionallyAsync(exception -> (Node)this.socketHandler.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)exception));
                }
                yield requiredFuture;
            }
        };
    }

    private CompletableFuture<Void> checkBusinessStatus() {
        if (!this.socketHandler.store().business() || this.socketHandler.keys().businessCertificate()) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.allOf(this.setBusinessCertificate(), this.setBusinessProfile()).thenRunAsync(() -> this.socketHandler.keys().businessCertificate(true));
    }

    private CompletableFuture<Void> queryInitialPrivacySettings() {
        if (this.socketHandler.store().business()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.socketHandler.sendQuery("get", "privacy", Node.of("privacy")).thenComposeAsync(this::parsePrivacySettings);
    }

    private CompletableFuture<Void> queryInitialBlockList() {
        return this.socketHandler.queryBlockList().thenAcceptAsync(entry -> entry.forEach(this::markBlocked));
    }

    private CompletableFuture<Void> updateSelfPresence() {
        if (!this.socketHandler.store().automaticPresenceUpdates()) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)this.socketHandler.sendWithNoResponse(Node.of("presence", Map.of("name", this.socketHandler.store().name(), "type", "available"))).thenRun(this::onPresenceUpdated)).exceptionally(exception -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.STREAM, (Throwable)exception));
    }

    private void onPresenceUpdated() {
        this.socketHandler.store().online(true);
        this.socketHandler.store().findContactByJid(this.socketHandler.store().jid().toWhatsappJid()).ifPresent(entry -> entry.lastKnownPresence(ContactStatus.AVAILABLE).lastSeen(ZonedDateTime.now()));
    }

    private CompletableFuture<Void> updateUserStatus(boolean update) {
        return this.socketHandler.queryAbout(this.socketHandler.store().jid().toWhatsappJid()).thenAcceptAsync(result -> this.parseNewStatus(result.orElse(null), update));
    }

    private void parseNewStatus(ContactStatusResponse result, boolean update) {
        if (result == null) {
            return;
        }
        String oldStatus = this.socketHandler.store().about();
        this.socketHandler.store().about(result.status());
        if (!update) {
            return;
        }
        this.socketHandler.onUserAboutChange(result.status(), oldStatus);
    }

    private CompletableFuture<Void> updateUserPicture(boolean update) {
        return this.socketHandler.queryPicture(this.socketHandler.store().jid().toWhatsappJid()).thenAcceptAsync(result -> this.handleUserPictureChange(result.orElse(null), update));
    }

    private void handleUserPictureChange(URI newPicture, boolean update) {
        URI oldStatus = this.socketHandler.store().profilePicture().orElse(null);
        this.socketHandler.store().profilePicture(newPicture);
        if (!update) {
            return;
        }
        this.socketHandler.onUserPictureChange(newPicture, oldStatus);
    }

    private void markBlocked(ContactJid entry) {
        this.socketHandler.store().findContactByJid(entry).orElseGet(() -> {
            Contact contact = this.socketHandler.store().addContact(entry);
            this.socketHandler.onNewContact(contact);
            return contact;
        }).blocked(true);
    }

    private CompletableFuture<Void> parsePrivacySettings(Node result) {
        CompletableFuture[] privacy = (CompletableFuture[])result.findNode("privacy").orElseThrow(() -> new NoSuchElementException("Missing privacy in response: %s".formatted(result))).children().stream().map(entry -> this.addPrivacySetting((Node)entry, false)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(privacy);
    }

    private void parseProps(Node result) {
        ConcurrentHashMap properties = result.findNode("props").stream().map(entry -> entry.findNodes("prop")).flatMap(Collection::stream).map(node -> Map.entry(node.attributes().getString("name"), node.attributes().getString("value"))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (first, second) -> second, ConcurrentHashMap::new));
        this.socketHandler.store().properties(properties);
        this.socketHandler.onMetadata(properties);
    }

    private void sendPing() {
        if (this.socketHandler.state() != SocketState.CONNECTED) {
            return;
        }
        this.socketHandler.sendQueryWithNoResponse("get", "w:p", Node.of("ping")).exceptionallyAsync(throwable -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.STREAM, (Throwable)throwable));
        this.socketHandler.onSocketEvent(SocketEvent.PING);
    }

    private void createMediaConnection(int tries, Throwable error) {
        if (this.socketHandler.state() != SocketState.CONNECTED) {
            return;
        }
        if (tries >= 5) {
            this.socketHandler.store().mediaConnection((MediaConnection)null);
            this.socketHandler.handleFailure(ErrorHandler.Location.MEDIA_CONNECTION, error);
            this.scheduleMediaConnection(60);
            return;
        }
        ((CompletableFuture)((CompletableFuture)this.socketHandler.sendQuery("set", "w:m", Node.of("media_conn")).thenApplyAsync(MediaConnection::of)).thenAcceptAsync(result -> {
            this.socketHandler.store().mediaConnection((MediaConnection)result);
            this.scheduleMediaConnection(result.ttl());
        })).exceptionallyAsync(throwable -> {
            this.createMediaConnection(tries + 1, (Throwable)throwable);
            return null;
        });
    }

    private void scheduleMediaConnection(int seconds) {
        Executor executor = CompletableFuture.delayedExecutor(seconds, TimeUnit.SECONDS);
        CompletableFuture.runAsync(() -> this.createMediaConnection(0, null), executor);
    }

    private void digestIq(Node node) {
        Node container = node.findNode().orElse(null);
        if (container == null) {
            return;
        }
        switch (container.description()) {
            case "pair-device": {
                this.generateQrCode(node, container);
                break;
            }
            case "pair-success": {
                this.confirmQrCode(node, container);
            }
        }
    }

    private void sendPreKeys() {
        int startId = this.socketHandler.keys().lastPreKeyId() + 1;
        List<Node> preKeys = IntStream.range(startId, startId + 30).mapToObj(SignalPreKeyPair::random).peek(this.socketHandler.keys()::addPreKey).map(SignalPreKeyPair::toNode).toList();
        this.socketHandler.sendQuery("set", "encrypt", Node.of("registration", this.socketHandler.keys().encodedRegistrationId()), Node.of("type", Spec.Signal.KEY_BUNDLE_TYPE), Node.of("identity", this.socketHandler.keys().identityKeyPair().publicKey()), Node.of("list", preKeys), this.socketHandler.keys().signedKeyPair().toNode());
    }

    private void generateQrCode(Node node, Node container) {
        WebVerificationSupport webVerificationSupport = this.webVerificationSupport;
        if (webVerificationSupport instanceof QrHandler) {
            QrHandler qrHandler = (QrHandler)webVerificationSupport;
            this.printQrCode(qrHandler, container);
            this.sendConfirmNode(node, null);
        } else {
            webVerificationSupport = this.webVerificationSupport;
            if (webVerificationSupport instanceof PairingCodeHandler) {
                PairingCodeHandler codeHandler = (PairingCodeHandler)webVerificationSupport;
                this.askPairingCode(codeHandler);
            } else {
                throw new IllegalArgumentException("Cannot verify account: unknown verification method");
            }
        }
    }

    private void askPairingCode(PairingCodeHandler codeHandler) {
        String code = BytesHelper.bytesToCrockford(BytesHelper.random(5));
        Node registration = Node.of("link_code_companion_reg", Map.of("jid", this.getPhoneNumberAsJid(), "stage", "companion_hello", "should_show_push_notification", true), Node.of("link_code_pairing_wrapped_companion_ephemeral_pub", this.cipherLinkPublicKey(code)), Node.of("companion_server_auth_key_pub", this.socketHandler.keys().noiseKeyPair().publicKey()), Node.of("companion_platform_id", 49), Node.of("companion_platform_display", this.socketHandler.store().name()), Node.of("link_code_pairing_nonce", 0));
        this.socketHandler.sendQuery("set", "md", registration).thenAcceptAsync(result -> this.onAskedPairingCode(codeHandler, code));
    }

    private byte[] cipherLinkPublicKey(String linkCodeKey) {
        try {
            byte[] salt = BytesHelper.random(32);
            byte[] randomIv = BytesHelper.random(16);
            SecretKey secretKey = this.generatePairingKey(linkCodeKey, salt);
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            cipher.init(1, (Key)secretKey, new IvParameterSpec(randomIv));
            byte[] ciphered = cipher.doFinal(this.socketHandler.keys().companionKeyPair().publicKey());
            return BytesHelper.concat(salt, randomIv, ciphered);
        }
        catch (GeneralSecurityException exception) {
            throw new RuntimeException("Cannot cipher link code pairing key", exception);
        }
    }

    private void onAskedPairingCode(PairingCodeHandler codeHandler, String code) {
        this.lastLinkCodeKey.set(code);
        codeHandler.accept(code);
    }

    private ContactJid getPhoneNumberAsJid() {
        return this.socketHandler.store().phoneNumber().map(PhoneNumber::toJid).orElseThrow(() -> new IllegalArgumentException("Missing phone number while registering via OTP"));
    }

    private SecretKey generatePairingKey(String password, byte[] salt) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, 131072, 256);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            cipher.init(1, secret);
            return secret;
        }
        catch (GeneralSecurityException exception) {
            throw new RuntimeException("Cannot compute pairing key", exception);
        }
    }

    private void printQrCode(QrHandler qrHandler, Node container) {
        String ref = (String)container.findNode("ref").flatMap(Node::contentAsString).orElseThrow(() -> new NoSuchElementException("Missing ref"));
        String qr = String.join((CharSequence)",", ref, Base64.getEncoder().encodeToString(this.socketHandler.keys().noiseKeyPair().publicKey()), Base64.getEncoder().encodeToString(this.socketHandler.keys().identityKeyPair().publicKey()), Base64.getEncoder().encodeToString(this.socketHandler.keys().companionKeyPair().publicKey()), "1");
        qrHandler.accept(qr);
    }

    private void confirmQrCode(Node node, Node container) {
        this.saveCompanion(container);
        Node deviceIdentity = container.findNode("device-identity").orElseThrow(() -> new NoSuchElementException("Missing device identity"));
        SignedDeviceIdentityHMAC advIdentity = Protobuf.readMessage(deviceIdentity.contentAsBytes().orElseThrow(), SignedDeviceIdentityHMAC.class);
        byte[] advSign = Hmac.calculateSha256(advIdentity.details(), this.socketHandler.keys().companionKeyPair().publicKey());
        if (!Arrays.equals(advIdentity.hmac(), advSign)) {
            this.socketHandler.handleFailure(ErrorHandler.Location.LOGIN, new HmacValidationException("adv_sign"));
            return;
        }
        SignedDeviceIdentity account = Protobuf.readMessage(advIdentity.details(), SignedDeviceIdentity.class);
        byte[] message = BytesHelper.concat(Spec.Whatsapp.ACCOUNT_SIGNATURE_HEADER, account.details(), this.socketHandler.keys().identityKeyPair().publicKey());
        if (!Curve25519.verifySignature((byte[])account.accountSignatureKey(), (byte[])message, (byte[])account.accountSignature())) {
            this.socketHandler.handleFailure(ErrorHandler.Location.LOGIN, new HmacValidationException("message_header"));
            return;
        }
        byte[] deviceSignatureMessage = BytesHelper.concat(Spec.Whatsapp.DEVICE_WEB_SIGNATURE_HEADER, account.details(), this.socketHandler.keys().identityKeyPair().publicKey(), account.accountSignatureKey());
        account.deviceSignature(Curve25519.sign((byte[])this.socketHandler.keys().identityKeyPair().privateKey(), (byte[])deviceSignatureMessage, (boolean)true));
        int keyIndex = Protobuf.readMessage(account.details(), DeviceIdentity.class).keyIndex();
        byte[] outgoingDeviceIdentity = Protobuf.writeMessage(new SignedDeviceIdentity(account.details(), null, account.accountSignature(), account.deviceSignature()));
        Node devicePairNode = Node.of("pair-device-sign", (Object)Node.of("device-identity", Map.of("key-index", keyIndex), (Object)outgoingDeviceIdentity));
        this.socketHandler.keys().companionIdentity(account);
        this.sendConfirmNode(node, devicePairNode);
    }

    private void sendConfirmNode(Node node, Node content) {
        ConcurrentHashMap<String, Object> attributes = Attributes.of(new Map.Entry[0]).put("id", node.id()).put("type", "result").put("to", ContactJid.Server.WHATSAPP.toJid()).toMap();
        Node request = Node.of("iq", attributes, (Object)content);
        this.socketHandler.sendWithNoResponse(request);
    }

    private void saveCompanion(Node container) {
        Node node = container.findNode("device").orElseThrow(() -> new NoSuchElementException("Missing device"));
        boolean isBusiness = container.hasNode("business");
        ContactJid companion = node.attributes().getJid("jid").orElseThrow(() -> new NoSuchElementException("Missing companion"));
        this.socketHandler.store().jid(companion);
        this.socketHandler.store().phoneNumber(PhoneNumber.of(companion.user()));
        this.socketHandler.markConnected();
        UserAgent.UserAgentPlatform companionOs = container.findNode("platform").map(entry -> entry.attributes().getNullableString("name")).map(this::getCompanionOs).orElseThrow(() -> new NoSuchElementException("Unknown platform: " + container));
        this.socketHandler.store().companionDeviceOs(companionOs);
        this.socketHandler.store().business(isBusiness);
        this.socketHandler.store().addContact(Contact.ofJid(this.socketHandler.store().jid().toWhatsappJid()));
    }

    private UserAgent.UserAgentPlatform getCompanionOs(String name) {
        return switch (name.toLowerCase()) {
            case "smba" -> UserAgent.UserAgentPlatform.SMB_ANDROID;
            case "smbi" -> UserAgent.UserAgentPlatform.SMB_IOS;
            case "android" -> UserAgent.UserAgentPlatform.ANDROID;
            case "iphone", "ipad", "ios" -> UserAgent.UserAgentPlatform.IOS;
            default -> null;
        };
    }

    protected void dispose() {
        this.retries.clear();
        if (this.service != null) {
            this.service.shutdownNow();
        }
        this.badMac.set(false);
        this.lastLinkCodeKey.set(null);
    }
}

