/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.auties.whatsapp.model.message.model.Message;
import it.auties.whatsapp.model.message.model.MessageContainer;
import it.auties.whatsapp.util.KeyHelper;
import it.auties.whatsapp.util.Protobuf;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import lombok.NonNull;

public final class BytesHelper {
    private static final String CROCKFORD_CHARACTERS = "123456789ABCDEFGHJKLMNPQRSTVWXYZ";

    public static byte[] random(int length) {
        byte[] bytes = new byte[length];
        ThreadLocalRandom.current().nextBytes(bytes);
        return bytes;
    }

    public static byte[] concat(byte[] ... entries) {
        return Arrays.stream(entries).filter(Objects::nonNull).reduce(new byte[0], BytesHelper::concat);
    }

    public static byte[] concat(byte first, byte[] second) {
        if (second == null) {
            return new byte[]{first};
        }
        byte[] result = new byte[1 + second.length];
        result[0] = first;
        System.arraycopy(second, 0, result, 1, second.length);
        return result;
    }

    public static byte[] concat(byte[] first, byte[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        byte[] result = new byte[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static ByteBuf newBuffer() {
        return Unpooled.buffer();
    }

    public static ByteBuf newBuffer(int size) {
        return Unpooled.buffer((int)size);
    }

    public static ByteBuf newBuffer(byte @NonNull [] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        ByteBuf buffer = BytesHelper.newBuffer(data.length);
        buffer.writeBytes(data);
        return buffer;
    }

    public static byte[] readBuffer(ByteBuf byteBuf) {
        return BytesHelper.readBuffer(byteBuf, byteBuf.readableBytes());
    }

    public static byte[] readBuffer(ByteBuf byteBuf, int length) {
        byte[] result = new byte[length];
        byteBuf.readBytes(result);
        return result;
    }

    public static byte versionToBytes(int version) {
        return (byte)(version << 4 | 3);
    }

    public static int bytesToVersion(byte version) {
        return Byte.toUnsignedInt(version) >> 4;
    }

    public static byte[] compress(byte[] uncompressed) {
        Deflater deflater = new Deflater();
        deflater.setInput(uncompressed);
        deflater.finish();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            result.write(buffer, 0, count);
        }
        return result.toByteArray();
    }

    public static byte[] decompress(byte[] compressed) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressed);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (!decompressor.finished()) {
            int count = decompressor.inflate(buffer);
            result.write(buffer, 0, count);
        }
        return result.toByteArray();
    }

    public static byte[] messageToBytes(Message message) {
        return BytesHelper.messageToBytes(MessageContainer.of(message));
    }

    public static byte[] messageToBytes(MessageContainer container) {
        if (container.isEmpty()) {
            return null;
        }
        int padRandomByte = KeyHelper.header();
        byte[] padding = new byte[padRandomByte];
        Arrays.fill(padding, (byte)padRandomByte);
        return BytesHelper.concat(Protobuf.writeMessage(container), padding);
    }

    public static MessageContainer bytesToMessage(byte[] bytes) {
        byte[] message = Arrays.copyOfRange(bytes, 0, bytes.length - bytes[bytes.length - 1]);
        return Protobuf.readMessage(message, MessageContainer.class);
    }

    public static byte[] longToBytes(long number) {
        ByteBuf buffer = BytesHelper.newBuffer();
        buffer.writeLong(number);
        return BytesHelper.readBuffer(buffer);
    }

    public static byte[] intToBytes(int input, int length) {
        byte[] result = new byte[length];
        for (int i = length - 1; i >= 0; --i) {
            result[i] = (byte)(0xFF & input);
            input >>>= 8;
        }
        return result;
    }

    public static int bytesToInt(byte[] bytes, int length) {
        int result = 0;
        for (int i = 0; i < length; ++i) {
            result = 256 * result + Byte.toUnsignedInt(bytes[i]);
        }
        return result;
    }

    public static String bytesToCrockford(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int value = 0;
        int bitCount = 0;
        StringBuilder crockford = new StringBuilder();
        for (int i = 0; i < buffer.limit(); ++i) {
            value = value << 8 | buffer.get(i) & 0xFF;
            bitCount += 8;
            while (bitCount >= 5) {
                crockford.append(CROCKFORD_CHARACTERS.charAt(value >>> bitCount - 5 & 0x1F));
                bitCount -= 5;
            }
        }
        if (bitCount > 0) {
            crockford.append(CROCKFORD_CHARACTERS.charAt(value << 5 - bitCount & 0x1F));
        }
        return crockford.toString();
    }

    private BytesHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

