/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class Json {
    private static final ObjectMapper json;

    public static byte[] writeValueAsBytes(Object object) {
        try {
            return json.writer().writeValueAsBytes(object);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot write json", exception);
        }
    }

    public static String writeValueAsString(Object object) {
        return Json.writeValueAsString(object, false);
    }

    public static String writeValueAsString(Object object, boolean pretty) {
        try {
            ObjectWriter writer = pretty ? json.writerWithDefaultPrettyPrinter() : json.writer();
            return writer.writeValueAsString(object);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot write json", exception);
        }
    }

    public static <T> T readValue(String value, Class<T> clazz) {
        try {
            return (T)json.readValue(value, clazz);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot read json", exception);
        }
    }

    public static <T> T readValue(String value, TypeReference<T> clazz) {
        try {
            return (T)json.readValue(value, clazz);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot read json", exception);
        }
    }

    private Json() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        try {
            json = new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).setSerializationInclusion(JsonInclude.Include.NON_DEFAULT).enable(SerializationFeature.FAIL_ON_EMPTY_BEANS).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY).setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.NONE);
        }
        catch (Throwable throwable) {
            System.Logger logger = System.getLogger("Json");
            logger.log(System.Logger.Level.ERROR, "An exception occurred while initializing json", throwable);
            throw new RuntimeException("Cannot initialize json", throwable);
        }
    }
}

