/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.whatsapp.crypto.MD5;
import it.auties.whatsapp.model.response.WebVersionResponse;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.Version;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Json;
import it.auties.whatsapp.util.Medias;
import it.auties.whatsapp.util.Spec;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HexFormat;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;
import net.dongliu.apk.parser.ByteArrayApkFile;
import net.dongliu.apk.parser.bean.ApkSigner;
import net.dongliu.apk.parser.bean.CertificateMeta;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class MetadataHelper {
    private static final System.Logger LOGGER;
    private static final Pattern IOS_VERSION_PATTERN;
    private static volatile Version webVersion;
    private static volatile Version iosVersion;
    private static volatile WhatsappApk cachedApk;
    private static volatile WhatsappApk cachedBusinessApk;
    private static Path androidCache;

    public static void setAndroidCache(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            androidCache = path;
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    public static CompletableFuture<Version> getVersion(UserAgent.UserAgentPlatform platform, boolean business) {
        return MetadataHelper.getVersion(platform, business, true);
    }

    public static CompletableFuture<Version> getVersion(UserAgent.UserAgentPlatform platform, boolean business, boolean useJarCache) {
        return switch (platform) {
            case UserAgent.UserAgentPlatform.WEB, UserAgent.UserAgentPlatform.WINDOWS, UserAgent.UserAgentPlatform.MACOS -> MetadataHelper.getWebVersion();
            case UserAgent.UserAgentPlatform.ANDROID -> MetadataHelper.getAndroidData(business, useJarCache).thenApply(WhatsappApk::version);
            case UserAgent.UserAgentPlatform.IOS -> MetadataHelper.getIosVersion();
            default -> throw new IllegalStateException("Unsupported mobile os: " + platform);
        };
    }

    private static CompletableFuture<Version> getIosVersion() {
        return CompletableFuture.completedFuture(Objects.requireNonNullElse(iosVersion, Spec.Whatsapp.DEFAULT_MOBILE_IOS_VERSION));
    }

    private static Version parseIosVersion(HttpResponse<String> result) {
        iosVersion = IOS_VERSION_PATTERN.matcher(result.body()).results().map(MatchResult::group).reduce((first, second) -> second).map(version -> new Version("2." + version)).orElseGet(MetadataHelper::getDefaultIosVersion);
        return iosVersion;
    }

    private static Version getDefaultIosVersion() {
        LOGGER.log(System.Logger.Level.WARNING, "Cannot fetch latest IOS version, falling back to %s".formatted(Spec.Whatsapp.DEFAULT_MOBILE_IOS_VERSION));
        return Spec.Whatsapp.DEFAULT_MOBILE_IOS_VERSION;
    }

    private static CompletableFuture<Version> getWebVersion() {
        try {
            if (webVersion != null) {
                return CompletableFuture.completedFuture(webVersion);
            }
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create("https://web.whatsapp.com/check-update?version=2.2245.9&platform=web")).build();
            return ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApplyAsync(response -> Json.readValue((String)response.body(), WebVersionResponse.class))).thenApplyAsync(version -> {
                webVersion = new Version(version.currentVersion());
                return webVersion;
            });
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Cannot fetch latest web version", throwable);
        }
    }

    public static CompletableFuture<String> getToken(long phoneNumber, UserAgent.UserAgentPlatform platform, boolean business, boolean useJarCache) {
        return switch (platform) {
            case UserAgent.UserAgentPlatform.ANDROID -> MetadataHelper.getAndroidToken(String.valueOf(phoneNumber), business, useJarCache);
            case UserAgent.UserAgentPlatform.IOS -> MetadataHelper.getIosToken(phoneNumber, platform, business, useJarCache);
            default -> throw new IllegalStateException("Unsupported mobile os: " + platform);
        };
    }

    private static CompletableFuture<String> getIosToken(long phoneNumber, UserAgent.UserAgentPlatform platform, boolean business, boolean useJarCache) {
        return MetadataHelper.getVersion(platform, business, useJarCache).thenApply(version -> MetadataHelper.getIosToken(phoneNumber, version));
    }

    private static String getIosToken(long phoneNumber, Version version) {
        String token = "0a1mLfGUIBVrMKF1RdvLI5lkRBvof6vn0fD2QRSM" + HexFormat.of().formatHex(version.toHash()) + phoneNumber;
        return HexFormat.of().formatHex(MD5.calculate(token));
    }

    private static CompletableFuture<String> getAndroidToken(String phoneNumber, boolean business, boolean useJarCache) {
        return MetadataHelper.getAndroidData(business, useJarCache).thenApplyAsync(whatsappData -> MetadataHelper.getAndroidToken(phoneNumber, whatsappData));
    }

    private static String getAndroidToken(String phoneNumber, WhatsappApk whatsappData) {
        try {
            Mac mac = Mac.getInstance("HMACSHA1");
            byte[] secretKeyBytes = whatsappData.secretKey();
            SecretKeySpec secretKey = new SecretKeySpec(secretKeyBytes, 0, secretKeyBytes.length, "PBKDF2");
            mac.init(secretKey);
            whatsappData.certificates().forEach(mac::update);
            mac.update(whatsappData.md5Hash());
            mac.update(phoneNumber.getBytes(StandardCharsets.UTF_8));
            return URLEncoder.encode(Base64.getEncoder().encodeToString(mac.doFinal()), StandardCharsets.UTF_8);
        }
        catch (GeneralSecurityException throwable) {
            throw new RuntimeException("Cannot compute mobile token", throwable);
        }
    }

    private static synchronized CompletableFuture<WhatsappApk> getAndroidData(boolean business, boolean useJarCache) {
        if (!business && cachedApk != null) {
            return CompletableFuture.completedFuture(cachedApk);
        }
        if (business && cachedBusinessApk != null) {
            return CompletableFuture.completedFuture(cachedBusinessApk);
        }
        return MetadataHelper.getCachedApk(business, useJarCache).map(CompletableFuture::completedFuture).orElseGet(() -> MetadataHelper.downloadWhatsappApk(business));
    }

    public static CompletableFuture<WhatsappApk> downloadWhatsappApk(boolean business) {
        return Medias.downloadAsync(business ? "https://d.apkpure.com/b/APK/com.whatsapp.w4b?version=latest" : "https://www.whatsapp.com/android/current/WhatsApp.apk").thenApplyAsync(result -> MetadataHelper.getAndroidData(result, business));
    }

    private static Optional<WhatsappApk> getCachedApk(boolean business, boolean useJarCache) {
        try {
            Path localCache = MetadataHelper.getAndroidLocalCache(business);
            if (Files.notExists(localCache, new LinkOption[0])) {
                if (useJarCache) {
                    Path jarCache = MetadataHelper.getAndroidJarCache(business);
                    return Optional.of(Json.readValue(Files.readString(jarCache), WhatsappApk.class));
                }
                return Optional.empty();
            }
            Instant now = Instant.now();
            FileTime fileTime = Files.getLastModifiedTime(localCache, new LinkOption[0]);
            if (fileTime.toInstant().until(now, ChronoUnit.WEEKS) > 1L) {
                return Optional.empty();
            }
            return Optional.of(Json.readValue(Files.readString(localCache), WhatsappApk.class));
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    private static Path getAndroidJarCache(boolean business) throws URISyntaxException {
        URL url = business ? ClassLoader.getSystemResource("token/android/whatsapp_business.json") : ClassLoader.getSystemResource("token/android/whatsapp.json");
        return Path.of(url.toURI());
    }

    private static Path getAndroidLocalCache(boolean business) {
        return androidCache.resolve(business ? "whatsapp_business.json" : "whatsapp.json");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static WhatsappApk getAndroidData(byte[] apk, boolean business) {
        try (ByteArrayApkFile apkFile = new ByteArrayApkFile(apk);){
            Version version = new Version(apkFile.getApkMeta().getVersionName());
            byte[] md5Hash = MD5.calculate(apkFile.getFileData("classes.dex"));
            SecretKey secretKey = MetadataHelper.getSecretKey(apkFile.getApkMeta().getPackageName(), MetadataHelper.getAboutLogo(apkFile));
            List<byte[]> certificates = MetadataHelper.getCertificates(apkFile);
            if (business) {
                WhatsappApk result = new WhatsappApk(version, md5Hash, secretKey.getEncoded(), certificates, true);
                WhatsappApk whatsappApk = cachedBusinessApk = MetadataHelper.cacheWhatsappData(result);
                return whatsappApk;
            }
            WhatsappApk result = new WhatsappApk(version, md5Hash, secretKey.getEncoded(), certificates, false);
            WhatsappApk whatsappApk = cachedApk = MetadataHelper.cacheWhatsappData(result);
            return whatsappApk;
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new RuntimeException("Cannot extract certificates from APK", exception);
        }
    }

    private static WhatsappApk cacheWhatsappData(WhatsappApk apk) {
        CompletableFuture.runAsync(() -> {
            try {
                String json = Json.writeValueAsString(apk, true);
                Path file = MetadataHelper.getAndroidLocalCache(apk.business());
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.writeString(file, (CharSequence)json, new OpenOption[0]);
            }
            catch (Throwable throwable) {
                LOGGER.log(System.Logger.Level.WARNING, "Cannot update local cache", throwable);
            }
        });
        return apk;
    }

    private static byte[] getAboutLogo(ByteArrayApkFile apkFile) throws IOException {
        byte[] resource = apkFile.getFileData("res/drawable-hdpi/about_logo.png");
        if (resource != null) {
            return resource;
        }
        byte[] resourceV4 = apkFile.getFileData("res/drawable-hdpi-v4/about_logo.png");
        if (resourceV4 != null) {
            return resourceV4;
        }
        byte[] xxResourceV4 = apkFile.getFileData("res/drawable-xxhdpi-v4/about_logo.png");
        if (xxResourceV4 != null) {
            return xxResourceV4;
        }
        throw new NoSuchElementException("Missing about_logo.png from apk");
    }

    private static List<byte[]> getCertificates(ByteArrayApkFile apkFile) throws IOException, CertificateException {
        return apkFile.getApkSingers().stream().map(ApkSigner::getCertificateMetas).flatMap(Collection::stream).map(CertificateMeta::getData).toList();
    }

    private static SecretKey getSecretKey(String packageName, byte[] resource) throws IOException, GeneralSecurityException {
        byte[] result = BytesHelper.concat(packageName.getBytes(StandardCharsets.UTF_8), resource);
        char[] whatsappLogoChars = new char[result.length];
        for (int i = 0; i < result.length; ++i) {
            whatsappLogoChars[i] = (char)result[i];
        }
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1And8BIT");
        PBEKeySpec key = new PBEKeySpec(whatsappLogoChars, Spec.Whatsapp.MOBILE_ANDROID_SALT, 128, 512);
        return factory.generateSecret(key);
    }

    private MetadataHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        LOGGER = System.getLogger("Metadata");
        IOS_VERSION_PATTERN = Pattern.compile("(?<=Minimum Requirements \\(Version )\\d+\\.\\d+\\.\\d+");
        androidCache = Path.of(System.getProperty("user.home") + "/.whatsapp4j/token/android", new String[0]);
    }

    @JsonDeserialize(builder=WhatsappApkBuilder.class)
    public record WhatsappApk(Version version, byte[] md5Hash, byte[] secretKey, Collection<byte[]> certificates, boolean business) {
        public static WhatsappApkBuilder builder() {
            return new WhatsappApkBuilder();
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        public static class WhatsappApkBuilder {
            private Version version;
            private byte[] md5Hash;
            private byte[] secretKey;
            private Collection<byte[]> certificates;
            private boolean business;

            WhatsappApkBuilder() {
            }

            public WhatsappApkBuilder version(Version version) {
                this.version = version;
                return this;
            }

            public WhatsappApkBuilder md5Hash(byte[] md5Hash) {
                this.md5Hash = md5Hash;
                return this;
            }

            public WhatsappApkBuilder secretKey(byte[] secretKey) {
                this.secretKey = secretKey;
                return this;
            }

            public WhatsappApkBuilder certificates(Collection<byte[]> certificates) {
                this.certificates = certificates;
                return this;
            }

            public WhatsappApkBuilder business(boolean business) {
                this.business = business;
                return this;
            }

            public WhatsappApk build() {
                return new WhatsappApk(this.version, this.md5Hash, this.secretKey, this.certificates, this.business);
            }

            public String toString() {
                return "MetadataHelper.WhatsappApk.WhatsappApkBuilder(version=" + this.version + ", md5Hash=" + Arrays.toString(this.md5Hash) + ", secretKey=" + Arrays.toString(this.secretKey) + ", certificates=" + this.certificates + ", business=" + this.business + ")";
            }
        }
    }
}

