/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.extra.cpp;

import com.github.autostyle.FormatterFunc;
import com.github.autostyle.Provisioner;
import com.github.autostyle.ThrowingEx;
import com.github.autostyle.extra.EclipseBasedStepBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public final class EclipseCdtFormatterStep {
    private static final String NAME = "eclipse cdt formatter";
    private static final String FORMATTER_CLASS = "com.diffplug.spotless.extra.eclipse.cdt.EclipseCdtFormatterStepImpl";
    private static final String DEFAULT_VERSION = "4.13.0";
    private static final String FORMATTER_METHOD = "format";

    private EclipseCdtFormatterStep() {
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    public static EclipseBasedStepBuilder createBuilder(Provisioner provisioner) {
        return new EclipseBasedStepBuilder(NAME, provisioner, (ThrowingEx.Function<EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.Function)EclipseCdtFormatterStep::apply));
    }

    private static FormatterFunc apply(EclipseBasedStepBuilder.State state) throws Exception {
        Class<?> formatterClazz = state.loadClass(FORMATTER_CLASS);
        Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(state.getPreferences());
        Method method = formatterClazz.getMethod(FORMATTER_METHOD, String.class);
        return input -> {
            try {
                return (String)method.invoke(formatter, input);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        };
    }
}

