/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.extra.integration;

import com.github.autostyle.extra.integration.DiffMessageFormatter$WhenMappings;
import com.github.autostyle.extra.integration.WriteSpaceAwareDiffFormatter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\b\u0018\u0000 C2\u00020\u0001:\u0002CDB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%J\u0018\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001dH\u0002J\u0018\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u001dH\u0002J \u0010(\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%H\u0002J\u0006\u0010,\u001a\u00020-J(\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\b2\u0006\u00101\u001a\u00020\u001dH\u0002J(\u00102\u001a\u00020!2\u0006\u00100\u001a\u00020\u00032\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000206H\u0002J$\u00108\u001a\u0004\u0018\u00010\u001d2\u0006\u00107\u001a\u0002062\u0006\u00109\u001a\u00020:2\b\b\u0002\u0010;\u001a\u00020\bH\u0002J\u001c\u0010<\u001a\u00020=*\u00020=2\u0006\u0010>\u001a\u00020%2\b\b\u0002\u0010?\u001a\u00020%J\n\u0010@\u001a\u00020\u001d*\u00020\u001dJ\n\u0010A\u001a\u00020\u001d*\u00020\u001dJ\f\u0010B\u001a\u00020\u001d*\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001a\u0010\n\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0012\"\u0004\b\u0018\u0010\u0014R\u000e\u0010\u0019\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\u00020\u001d*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006E"}, d2={"Lcom/github/autostyle/extra/integration/DiffMessageFormatter;", "", "baseDir", "Ljava/io/File;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "maxCheckMessageLines", "", "maxFilesToList", "minLinesPerFile", "(Ljava/io/File;Ljava/lang/StringBuilder;III)V", "getBaseDir", "()Ljava/io/File;", "files", "", "Lcom/github/autostyle/extra/integration/DiffMessageFormatter$FileInfo;", "getMaxCheckMessageLines", "()I", "setMaxCheckMessageLines", "(I)V", "getMaxFilesToList", "setMaxFilesToList", "getMinLinesPerFile", "setMinLinesPerFile", "numLines", "getSb", "()Ljava/lang/StringBuilder;", "plural", "", "getPlural", "(I)Ljava/lang/String;", "addDiff", "", "old", "new", "encoding", "Ljava/nio/charset/Charset;", "addFile", "relativePath", "diff", "addIntendedLine", "indent", "line", "finishWithoutErrors", "", "issueCommand", "command", "file", "message", "printGitHubActionsErrors", "edits", "Lorg/eclipse/jgit/diff/EditList;", "a", "Lorg/eclipse/jgit/diff/RawText;", "b", "suggestion", "edit", "Lorg/eclipse/jgit/diff/Edit;", "maxLines", "convertFromTo", "", "from", "to", "escapeData", "escapeProperty", "relativize", "Companion", "FileInfo", "autostyle-lib-extra"})
public final class DiffMessageFormatter {
    private int numLines;
    private final List<FileInfo> files;
    @NotNull
    private final File baseDir;
    @NotNull
    private final StringBuilder sb;
    private int maxCheckMessageLines;
    private int maxFilesToList;
    private int minLinesPerFile;
    private static final int MAX_CHECK_MESSAGE_LINES = 50;
    public static final int MAX_FILES_TO_LIST = 10;
    private static final int MIN_LINES_PER_FILE = 4;
    private static final String NORMAL_INDENT = "  ";
    private static final String DIFF_INDENT = "    ";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final String relativize(File $this$relativize) {
        return FilesKt.toRelativeString((File)$this$relativize, (File)this.baseDir);
    }

    public final void addDiff(@NotNull File old, @NotNull File file, @NotNull Charset encoding) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)file, (String)"new");
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        Collection collection = this.files;
        FileInfo fileInfo = new FileInfo(old, file, encoding);
        boolean bl = false;
        collection.add(fileInfo);
    }

    public final boolean finishWithoutErrors() {
        if (this.files.isEmpty()) {
            return true;
        }
        int addedFiles = 0;
        int displayedInDiffFiles = 0;
        List<FileInfo> $this$sortBy$iv = this.files;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            boolean bl = false;
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    FileInfo it = (FileInfo)a;
                    boolean bl2 = false;
                    Comparable comparable = it.getOld();
                    it = (FileInfo)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    File file = it.getOld();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)file);
                }
            });
        }
        $i$f$sortBy = false;
        List extraFiles = new ArrayList();
        for (FileInfo info : this.files) {
            ++addedFiles;
            String relativePath = this.relativize(info.getOld());
            if (this.numLines >= this.maxCheckMessageLines) {
                if (addedFiles > this.maxFilesToList) continue;
                extraFiles.add(relativePath);
                continue;
            }
            ++displayedInDiffFiles;
            this.addFile(relativePath, this.diff(info.getOld(), info.getNew(), info.getEncoding()));
        }
        if (extraFiles.isEmpty()) {
            return false;
        }
        if (this.files.size() - displayedInDiffFiles > this.maxFilesToList) {
            int rest = addedFiles - displayedInDiffFiles;
            this.sb.append("Violations also present in ").append(rest).append(" other file" + (rest != 1 ? "s" : "") + ".\n");
            return false;
        }
        this.sb.append("Violations also present in:\n");
        for (FileInfo file : this.files.subList(displayedInDiffFiles, this.files.size())) {
            this.addIntendedLine(NORMAL_INDENT, this.relativize(file.getOld()));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void addFile(String relativePath, String diff) {
        List lines = StringsKt.split$default((CharSequence)diff, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null);
        this.addIntendedLine(NORMAL_INDENT, relativePath);
        int n = 0;
        int n2 = RangesKt.coerceAtMost((int)lines.size(), (int)(this.minLinesPerFile - 1));
        while (n < n2) {
            void i;
            this.addIntendedLine(DIFF_INDENT, (String)lines.get((int)i));
            ++i;
        }
        ListIterator iter = lines.listIterator(RangesKt.coerceAtMost((int)lines.size(), (int)(this.minLinesPerFile - 1)));
        while (iter.hasNext() && (this.numLines < this.maxCheckMessageLines || lines.size() - iter.nextIndex() == 1)) {
            this.addIntendedLine(DIFF_INDENT, (String)iter.next());
        }
        if (this.numLines >= this.maxCheckMessageLines && iter.hasNext()) {
            int linesLeft = lines.size() - iter.nextIndex();
            this.addIntendedLine(NORMAL_INDENT, "... (" + linesLeft + " more lines that didn't fit)");
        }
    }

    private final void addIntendedLine(String indent, String line) {
        this.sb.append(indent);
        this.sb.append(line);
        this.sb.append('\n');
        DiffMessageFormatter diffMessageFormatter = this;
        ++diffMessageFormatter.numLines;
        int cfr_ignored_0 = diffMessageFormatter.numLines;
    }

    @NotNull
    public final byte[] convertFromTo(@NotNull byte[] $this$convertFromTo, @NotNull Charset from, @NotNull Charset to) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$convertFromTo, (String)"$this$convertFromTo");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Charset charset = from;
        if (Intrinsics.areEqual((Object)charset, (Object)to)) {
            byArray = $this$convertFromTo;
        } else {
            Object object = $this$convertFromTo;
            boolean bl = false;
            boolean bl2 = false;
            object = new String((byte[])object, from);
            bl = false;
            byte[] byArray2 = ((String)object).getBytes(to);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        }
        return byArray;
    }

    public static /* synthetic */ byte[] convertFromTo$default(DiffMessageFormatter diffMessageFormatter, byte[] byArray, Charset charset, Charset charset2, int n, Object object) {
        if ((n & 2) != 0) {
            Charset charset3 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"StandardCharsets.UTF_8");
            charset2 = charset3;
        }
        return diffMessageFormatter.convertFromTo(byArray, charset, charset2);
    }

    private final String diff(File old, File file, Charset encoding) {
        EditList edits;
        RawText a = new RawText(DiffMessageFormatter.convertFromTo$default(this, FilesKt.readBytes((File)old), encoding, null, 2, null));
        RawText b = new RawText(DiffMessageFormatter.convertFromTo$default(this, FilesKt.readBytes((File)file), encoding, null, 2, null));
        EditList editList = edits = new HistogramDiff().diff((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)a, (Sequence)b);
        Intrinsics.checkNotNullExpressionValue((Object)editList, (String)"edits");
        this.printGitHubActionsErrors(old, editList, a, b);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.defaultCharset()");
        new WriteSpaceAwareDiffFormatter(out, charset).format(edits, a, b);
        byte[] byArray = out.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"out.toByteArray()");
        byte[] byArray2 = byArray;
        Charset charset2 = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"StandardCharsets.UTF_8");
        Charset charset3 = charset2;
        boolean bl = false;
        boolean bl2 = false;
        return new String(byArray2, charset3);
    }

    private final void printGitHubActionsErrors(File file, EditList edits, RawText a, RawText b) {
        String string = System.getenv("GITHUB_WORKSPACE");
        if (string == null) {
            return;
        }
        String workspace = string;
        String string2 = System.getenv("AUTOSTYLE_SKIP_GITHUB_ACTIONS");
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            if (Boolean.parseBoolean(string3)) {
                return;
            }
        }
        String relativePath = FilesKt.toRelativeString((File)file, (File)new File(workspace));
        Iterator iterator = edits.iterator();
        while (iterator.hasNext()) {
            Edit edit;
            Edit edit2 = edit = (Edit)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)edit2, (String)"edit");
            Edit.Type type = edit2.getType();
            if (type == null) continue;
            switch (DiffMessageFormatter$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.issueCommand("error", relativePath, edit.getBeginA() + 1, "Remove " + edit.getLengthA() + " line" + this.getPlural(edit.getLengthA()) + ": " + (edit.getBeginA() + 1) + ".." + edit.getEndA());
                    break;
                }
                case 3: {
                    this.issueCommand("error", relativePath, edit.getBeginA() + 1, "Insert " + edit.getLengthB() + " line" + this.getPlural(edit.getLengthB()) + ":\n" + DiffMessageFormatter.suggestion$default(this, b, edit, 0, 4, null));
                    break;
                }
                case 4: {
                    this.issueCommand("error", relativePath, edit.getBeginA() + 1, "Replace " + edit.getLengthB() + " line" + this.getPlural(edit.getLengthB()) + ' ' + (edit.getBeginA() + 1) + ".." + edit.getEndA() + " with\n" + DiffMessageFormatter.suggestion$default(this, b, edit, 0, 4, null));
                    break;
                }
            }
        }
    }

    private final String suggestion(RawText b, Edit edit, int maxLines) {
        if (edit.getLengthB() <= maxLines) {
            return b.getString(edit.getBeginB(), edit.getEndB(), true);
        }
        int linesLeft = edit.getLengthB() - maxLines;
        return b.getString(edit.getBeginB(), edit.getBeginB() + maxLines, true) + "\n..." + linesLeft + " more line" + this.getPlural(linesLeft);
    }

    static /* synthetic */ String suggestion$default(DiffMessageFormatter diffMessageFormatter, RawText rawText, Edit edit, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 20;
        }
        return diffMessageFormatter.suggestion(rawText, edit, n);
    }

    private final String getPlural(int $this$plural) {
        return $this$plural == 1 ? "" : "s";
    }

    private final void issueCommand(String command, String file, int line, String message) {
        String string = "::" + command + " file=" + this.escapeProperty(file) + ",line=" + line + "::" + this.escapeData(message);
        boolean bl = false;
        System.out.println((Object)string);
    }

    @NotNull
    public final String escapeData(@NotNull String $this$escapeData) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeData, (String)"$this$escapeData");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$escapeData, (String)"%", (String)"%25", (boolean)false, (int)4, null), (String)"\r", (String)"%0D", (boolean)false, (int)4, null), (String)"\n", (String)"%0A", (boolean)false, (int)4, null);
    }

    @NotNull
    public final String escapeProperty(@NotNull String $this$escapeProperty) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeProperty, (String)"$this$escapeProperty");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$escapeProperty, (String)"%", (String)"%25", (boolean)false, (int)4, null), (String)"\r", (String)"%0D", (boolean)false, (int)4, null), (String)"\n", (String)"%0A", (boolean)false, (int)4, null), (String)":", (String)"%3A", (boolean)false, (int)4, null), (String)",", (String)"%2C", (boolean)false, (int)4, null);
    }

    @NotNull
    public final File getBaseDir() {
        return this.baseDir;
    }

    @NotNull
    public final StringBuilder getSb() {
        return this.sb;
    }

    public final int getMaxCheckMessageLines() {
        return this.maxCheckMessageLines;
    }

    public final void setMaxCheckMessageLines(int n) {
        this.maxCheckMessageLines = n;
    }

    public final int getMaxFilesToList() {
        return this.maxFilesToList;
    }

    public final void setMaxFilesToList(int n) {
        this.maxFilesToList = n;
    }

    public final int getMinLinesPerFile() {
        return this.minLinesPerFile;
    }

    public final void setMinLinesPerFile(int n) {
        this.minLinesPerFile = n;
    }

    public DiffMessageFormatter(@NotNull File baseDir, @NotNull StringBuilder sb, int maxCheckMessageLines, int maxFilesToList, int minLinesPerFile) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        this.baseDir = baseDir;
        this.sb = sb;
        this.maxCheckMessageLines = maxCheckMessageLines;
        this.maxFilesToList = maxFilesToList;
        this.minLinesPerFile = minLinesPerFile;
        boolean bl = false;
        this.files = new ArrayList();
    }

    public /* synthetic */ DiffMessageFormatter(File file, StringBuilder stringBuilder, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            stringBuilder = new StringBuilder(3200);
        }
        if ((n4 & 4) != 0) {
            n = 50;
        }
        if ((n4 & 8) != 0) {
            n2 = 10;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 4;
        }
        this(file, stringBuilder, n, n2, n3);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/github/autostyle/extra/integration/DiffMessageFormatter$FileInfo;", "", "old", "Ljava/io/File;", "new", "encoding", "Ljava/nio/charset/Charset;", "(Ljava/io/File;Ljava/io/File;Ljava/nio/charset/Charset;)V", "getEncoding", "()Ljava/nio/charset/Charset;", "getNew", "()Ljava/io/File;", "getOld", "autostyle-lib-extra"})
    private static final class FileInfo {
        @NotNull
        private final File old;
        @NotNull
        private final File new;
        @NotNull
        private final Charset encoding;

        @NotNull
        public final File getOld() {
            return this.old;
        }

        @NotNull
        public final File getNew() {
            return this.new;
        }

        @NotNull
        public final Charset getEncoding() {
            return this.encoding;
        }

        public FileInfo(@NotNull File old, @NotNull File file, @NotNull Charset encoding) {
            Intrinsics.checkNotNullParameter((Object)old, (String)"old");
            Intrinsics.checkNotNullParameter((Object)file, (String)"new");
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            this.old = old;
            this.new = file;
            this.encoding = encoding;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/github/autostyle/extra/integration/DiffMessageFormatter$Companion;", "", "()V", "DIFF_INDENT", "", "MAX_CHECK_MESSAGE_LINES", "", "MAX_FILES_TO_LIST", "MIN_LINES_PER_FILE", "NORMAL_INDENT", "autostyle-lib-extra"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

