/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.extra.integration;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.util.IntList;
import org.eclipse.jgit.util.RawParseUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J(\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rH\u0002J0\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J \u0010\"\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\rH\u0002J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\rH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/github/autostyle/extra/integration/WriteSpaceAwareDiffFormatter;", "", "out", "Ljava/io/ByteArrayOutputStream;", "charset", "Ljava/nio/charset/Charset;", "(Ljava/io/ByteArrayOutputStream;Ljava/nio/charset/Charset;)V", "cr", "", "lf", "middleDot", "tab", "findCombinedEnd", "", "edits", "Lorg/eclipse/jgit/diff/EditList;", "startingEdit", "format", "", "a", "Lorg/eclipse/jgit/diff/RawText;", "b", "header", "lineA", "endA", "lineB", "endB", "line", "prefix", "", "lines", "Lorg/eclipse/jgit/util/IntList;", "showWhitespace", "", "range", "begin", "length", "writeInt", "num", "Companion", "autostyle-lib-extra"})
public final class WriteSpaceAwareDiffFormatter {
    private final byte[] middleDot;
    private final byte[] cr;
    private final byte[] lf;
    private final byte[] tab;
    private final ByteArrayOutputStream out;
    private static final int CONTEXT_LINES = 3;
    private static final String MIDDLE_DOT = "\u00b7";
    private static final String CR = "\u240d";
    private static final String LF = "\u240a";
    private static final String TAB = "\u21e5";
    private static final byte[] MIDDLE_DOT_UTF8;
    private static final byte[] CR_UTF8;
    private static final byte[] LF_UTF8;
    private static final byte[] TAB_UTF8;
    private static final byte[] SPACE_SIMPLE;
    private static final byte[] CR_SIMPLE;
    private static final byte[] LF_SIMPLE;
    private static final byte[] TAB_SIMPLE;
    private static final boolean isWindows;
    @NotNull
    public static final Companion Companion;

    public final void format(@NotNull EditList edits, @NotNull RawText a, @NotNull RawText b) throws IOException {
        Intrinsics.checkNotNullParameter((Object)edits, (String)"edits");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        IntList linesA = RawParseUtils.lineMap((byte[])a.getRawContent(), (int)0, (int)a.getRawContent().length);
        IntList linesB = RawParseUtils.lineMap((byte[])b.getRawContent(), (int)0, (int)b.getRawContent().length);
        boolean firstLine = true;
        block0: for (int i = 0; i < edits.size(); ++i) {
            boolean showWhitespace;
            Edit endEdit;
            Edit edit;
            Edit edit2 = edit = (Edit)edits.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)edit2, (String)"edit");
            int lineA = RangesKt.coerceAtLeast((int)(edit2.getBeginA() - 3), (int)0);
            int lineB = RangesKt.coerceAtLeast((int)(edit.getBeginB() - 3), (int)0);
            int endIdx = this.findCombinedEnd(edits, i);
            Edit edit3 = endEdit = (Edit)edits.get(endIdx);
            Intrinsics.checkNotNullExpressionValue((Object)edit3, (String)"endEdit");
            int endA = RangesKt.coerceAtMost((int)(edit3.getEndA() + 3), (int)a.size());
            int endB = RangesKt.coerceAtMost((int)(endEdit.getEndB() + 3), (int)b.size());
            if (firstLine) {
                firstLine = false;
            } else {
                this.out.write(10);
            }
            this.header(lineA, endA, lineB, endB);
            boolean bl = showWhitespace = edit.getType() == Edit.Type.REPLACE;
            while (true) {
                if (lineA >= endA) {
                    if (lineB >= endB) continue block0;
                }
                if (lineA < edit.getBeginA()) {
                    IntList intList = linesA;
                    Intrinsics.checkNotNullExpressionValue((Object)intList, (String)"linesA");
                    this.line(' ', a, lineA, intList, false);
                    ++lineA;
                    ++lineB;
                } else if (lineA < edit.getEndA()) {
                    IntList intList = linesA;
                    Intrinsics.checkNotNullExpressionValue((Object)intList, (String)"linesA");
                    this.line('-', a, lineA, intList, showWhitespace);
                    ++lineA;
                } else if (lineB < edit.getEndB()) {
                    IntList intList = linesB;
                    Intrinsics.checkNotNullExpressionValue((Object)intList, (String)"linesB");
                    this.line('+', b, lineB, intList, showWhitespace);
                    ++lineB;
                } else {
                    IntList intList = linesA;
                    Intrinsics.checkNotNullExpressionValue((Object)intList, (String)"linesA");
                    this.line(' ', a, lineA, intList, false);
                    ++lineA;
                    ++lineB;
                }
                if (lineA != edit.getEndA() || lineB != edit.getEndB() || i >= endIdx) continue;
                Edit edit4 = edit = (Edit)edits.get(++i);
                Intrinsics.checkNotNullExpressionValue((Object)edit4, (String)"edit");
                showWhitespace = edit4.getType() == Edit.Type.REPLACE;
            }
        }
    }

    private final int findCombinedEnd(EditList edits, int startingEdit) {
        int i;
        for (i = startingEdit; i < edits.size() - 1; ++i) {
            Edit next;
            Edit current = (Edit)edits.get(i);
            Edit edit = next = (Edit)edits.get(i + 1);
            Intrinsics.checkNotNullExpressionValue((Object)edit, (String)"next");
            int n = edit.getBeginA();
            Edit edit2 = current;
            Intrinsics.checkNotNullExpressionValue((Object)edit2, (String)"current");
            if (n - edit2.getEndA() > 7 && next.getBeginB() - current.getEndB() > 7) break;
        }
        return i;
    }

    private final void header(int lineA, int endA, int lineB, int endB) {
        this.out.write(64);
        this.out.write(64);
        this.range('-', lineA + 1, endA - lineA);
        this.range('+', lineB + 1, endB - lineB);
        this.out.write(32);
        this.out.write(64);
        this.out.write(64);
    }

    private final void range(char prefix, int begin, int length) {
        this.out.write(32);
        this.out.write(prefix);
        if (length == 0) {
            this.writeInt(begin - 1);
            this.out.write(44);
            this.out.write(48);
        } else {
            this.writeInt(begin);
            if (length > 1) {
                this.out.write(44);
                this.writeInt(length);
            }
        }
    }

    private final void writeInt(int num) {
        String str = String.valueOf(num);
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            this.out.write(str.charAt(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void line(char prefix, RawText a, int lineA, IntList lines, boolean showWhitespace) {
        this.out.write(10);
        this.out.write(prefix);
        if (!showWhitespace) {
            a.writeLine((OutputStream)this.out, lineA);
            return;
        }
        byte[] bytes = a.getRawContent();
        int end = lines.get(lineA + 2);
        block6: for (int i = lines.get(lineA + 1); i < end; ++i) {
            void b;
            byte by = bytes[i];
            switch (b) {
                case 32: {
                    this.out.write(this.middleDot);
                    continue block6;
                }
                case 9: {
                    this.out.write(this.tab);
                    continue block6;
                }
                case 13: {
                    this.out.write(this.cr);
                    continue block6;
                }
                case 10: {
                    this.out.write(this.lf);
                    continue block6;
                }
                default: {
                    this.out.write((int)b);
                }
            }
        }
    }

    public WriteSpaceAwareDiffFormatter(@NotNull ByteArrayOutputStream out, @NotNull Charset charset) {
        CharsetEncoder charsetEncoder;
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.out = out;
        CharsetEncoder charsetEncoder2 = charsetEncoder = charset.newEncoder();
        Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder2, (String)"charsetEncoder");
        this.middleDot = WriteSpaceAwareDiffFormatter.Companion.replacementFor(charsetEncoder2, MIDDLE_DOT, WriteSpaceAwareDiffFormatter.MIDDLE_DOT_UTF8, WriteSpaceAwareDiffFormatter.SPACE_SIMPLE);
        this.cr = WriteSpaceAwareDiffFormatter.Companion.replacementFor(charsetEncoder, CR, WriteSpaceAwareDiffFormatter.CR_UTF8, WriteSpaceAwareDiffFormatter.CR_SIMPLE);
        this.lf = WriteSpaceAwareDiffFormatter.Companion.replacementFor(charsetEncoder, LF, WriteSpaceAwareDiffFormatter.LF_UTF8, WriteSpaceAwareDiffFormatter.LF_SIMPLE);
        this.tab = WriteSpaceAwareDiffFormatter.Companion.replacementFor(charsetEncoder, TAB, WriteSpaceAwareDiffFormatter.TAB_UTF8, WriteSpaceAwareDiffFormatter.TAB_SIMPLE);
    }

    static {
        Companion = new Companion(null);
        String string = MIDDLE_DOT;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        MIDDLE_DOT_UTF8 = byArray;
        string = CR;
        Charset charset3 = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"StandardCharsets.UTF_8");
        charset2 = charset3;
        bl = false;
        byte[] byArray2 = string.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        CR_UTF8 = byArray2;
        string = LF;
        Charset charset4 = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset4, (String)"StandardCharsets.UTF_8");
        charset2 = charset4;
        bl = false;
        byte[] byArray3 = string.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        LF_UTF8 = byArray3;
        string = TAB;
        Charset charset5 = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset5, (String)"StandardCharsets.UTF_8");
        charset2 = charset5;
        bl = false;
        byte[] byArray4 = string.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"(this as java.lang.String).getBytes(charset)");
        TAB_UTF8 = byArray4;
        SPACE_SIMPLE = new byte[]{(byte)32};
        CR_SIMPLE = new byte[]{(byte)92, (byte)114};
        LF_SIMPLE = new byte[]{(byte)92, (byte)110};
        TAB_SIMPLE = new byte[]{(byte)92, (byte)116};
        String string2 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"System.getProperty(\"os.name\")");
        string = string2;
        boolean bl2 = false;
        String string3 = string;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        isWindows = StringsKt.contains$default((CharSequence)string4, (CharSequence)"win", (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/autostyle/extra/integration/WriteSpaceAwareDiffFormatter$Companion;", "", "()V", "CONTEXT_LINES", "", "CR", "", "CR_SIMPLE", "", "CR_UTF8", "LF", "LF_SIMPLE", "LF_UTF8", "MIDDLE_DOT", "MIDDLE_DOT_UTF8", "SPACE_SIMPLE", "TAB", "TAB_SIMPLE", "TAB_UTF8", "isWindows", "", "replacementFor", "charsetEncoder", "Ljava/nio/charset/CharsetEncoder;", "value", "fancy", "simple", "autostyle-lib-extra"})
    public static final class Companion {
        private final byte[] replacementFor(CharsetEncoder charsetEncoder, String value, byte[] fancy, byte[] simple) {
            return !isWindows && charsetEncoder.canEncode(value) ? fancy : simple;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

