/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.extra.java;

import com.github.autostyle.FormatterFunc;
import com.github.autostyle.Provisioner;
import com.github.autostyle.ThrowingEx;
import com.github.autostyle.extra.EclipseBasedStepBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public final class EclipseJdtFormatterStep {
    private static final String NAME = "eclipse jdt formatter";
    private static final String FORMATTER_CLASS_OLD = "com.diffplug.gradle.spotless.java.eclipse.EclipseFormatterStepImpl";
    private static final String FORMATTER_CLASS = "com.diffplug.spotless.extra.eclipse.java.EclipseJdtFormatterStepImpl";
    private static final String MAVEN_GROUP_ARTIFACT = "com.diffplug.spotless:spotless-eclipse-jdt";
    private static final String DEFAULT_VERSION = "4.13.0";
    private static final String FORMATTER_METHOD = "format";

    private EclipseJdtFormatterStep() {
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    public static EclipseBasedStepBuilder createBuilder(Provisioner provisioner) {
        return new EclipseBasedStepBuilder(NAME, provisioner, (ThrowingEx.Function<EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.Function)EclipseJdtFormatterStep::apply));
    }

    private static FormatterFunc apply(EclipseBasedStepBuilder.State state) throws Exception {
        Class<?> formatterClazz = EclipseJdtFormatterStep.getClass(state);
        Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(state.getPreferences());
        Method method = formatterClazz.getMethod(FORMATTER_METHOD, String.class);
        return input -> {
            try {
                return (String)method.invoke(formatter, input);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        };
    }

    private static Class<?> getClass(EclipseBasedStepBuilder.State state) {
        if (state.getMavenCoordinate(MAVEN_GROUP_ARTIFACT) != null) {
            return state.loadClass(FORMATTER_CLASS);
        }
        return state.loadClass(FORMATTER_CLASS_OLD);
    }
}

