/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle;

import com.github.autostyle.FeatureClassLoader;
import com.github.autostyle.JarState;
import com.github.autostyle.LazyForwardingEquality;
import com.github.autostyle.ThrowingEx;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class AutostyleCache {
    final Map<SerializedKey, URLClassLoader> cache = new HashMap<SerializedKey, URLClassLoader>();
    private static final AutostyleCache instance = new AutostyleCache();

    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"})
    synchronized ClassLoader classloader(JarState state) {
        return this.classloader(state, state);
    }

    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"})
    synchronized ClassLoader classloader(Serializable key, JarState state) {
        SerializedKey serializedKey = new SerializedKey(key);
        return this.cache.computeIfAbsent(serializedKey, k -> new FeatureClassLoader(state.jarUrls(), this.getClass().getClassLoader()));
    }

    static AutostyleCache instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        ArrayList<URLClassLoader> toDelete;
        AutostyleCache autostyleCache = instance;
        synchronized (autostyleCache) {
            toDelete = new ArrayList<URLClassLoader>(AutostyleCache.instance.cache.values());
            AutostyleCache.instance.cache.clear();
        }
        for (URLClassLoader classLoader : toDelete) {
            try {
                classLoader.close();
            }
            catch (IOException e) {
                throw ThrowingEx.asRuntime(e);
            }
        }
    }

    static final class SerializedKey {
        final byte[] serialized;
        final int hashCode;

        SerializedKey(Serializable key) {
            Objects.requireNonNull(key);
            this.serialized = LazyForwardingEquality.toBytes(key);
            this.hashCode = Arrays.hashCode(this.serialized);
        }

        public final boolean equals(Object other) {
            return other instanceof SerializedKey && Arrays.equals(this.serialized, ((SerializedKey)other).serialized);
        }

        public final int hashCode() {
            return this.hashCode;
        }
    }
}

