/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle;

import com.github.autostyle.ThrowingEx;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

class FeatureClassLoader
extends URLClassLoader {
    static final List<String> BUILD_TOOLS_PACKAGES;
    private final ClassLoader buildToolClassLoader;

    FeatureClassLoader(URL[] urls, ClassLoader buildToolClassLoader) {
        super(urls, FeatureClassLoader.getParentClassLoader());
        Objects.requireNonNull(buildToolClassLoader);
        this.buildToolClassLoader = buildToolClassLoader;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (String buildToolPackage : BUILD_TOOLS_PACKAGES) {
            if (!name.startsWith(buildToolPackage)) continue;
            return this.buildToolClassLoader.loadClass(name);
        }
        return super.findClass(name);
    }

    @Nullable
    private static ClassLoader getParentClassLoader() {
        double version = Double.parseDouble(System.getProperty("java.specification.version"));
        if (version > 1.8) {
            try {
                return (ClassLoader)ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw ThrowingEx.asRuntime(e);
            }
        }
        return null;
    }

    static {
        ClassLoader.registerAsParallelCapable();
        BUILD_TOOLS_PACKAGES = Collections.unmodifiableList(Arrays.asList("org.slf4j."));
    }
}

