/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle;

import com.github.autostyle.ThrowingEx;
import java.io.File;
import java.util.Objects;

public interface FormatterFunc
extends ThrowingEx.Function<String, String>,
ThrowingEx.BiFunction<String, File, String> {
    @Override
    default public String apply(String input, File source) throws Throwable {
        return (String)this.apply(input);
    }

    public static interface Closeable
    extends FormatterFunc,
    AutoCloseable {
        @Override
        public void close();

        public static Closeable of(final AutoCloseable closeable, final FormatterFunc function) {
            Objects.requireNonNull(closeable, "closeable");
            Objects.requireNonNull(function, "function");
            return new Closeable(){

                @Override
                public void close() {
                    ThrowingEx.run(closeable::close);
                }

                @Override
                public String apply(String input, File source) throws Throwable {
                    return function.apply(Objects.requireNonNull(input), Objects.requireNonNull(source));
                }

                @Override
                public String apply(String input) throws Throwable {
                    return (String)function.apply(Objects.requireNonNull(input));
                }
            };
        }
    }
}

