/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle;

import com.github.autostyle.FilterByFileFormatterStep;
import com.github.autostyle.FormatterFunc;
import com.github.autostyle.FormatterStepImpl;
import com.github.autostyle.LazyForwardingEquality;
import com.github.autostyle.SerializableFileFilter;
import com.github.autostyle.ThrowingEx;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

public interface FormatterStep
extends Serializable {
    public String getName();

    @Nullable
    public String format(String var1, File var2) throws Throwable;

    default public FormatterStep filterByFile(SerializableFileFilter filter) {
        return new FilterByFileFormatterStep(this, filter);
    }

    public static <State extends Serializable> FormatterStep createLazy(String name, ThrowingEx.Supplier<State> stateSupplier, ThrowingEx.Function<State, FormatterFunc> stateToFormatter) {
        return new FormatterStepImpl.Standard<State>(name, stateSupplier, stateToFormatter);
    }

    public static <State extends Serializable> FormatterStep create(String name, State state, ThrowingEx.Function<State, FormatterFunc> stateToFormatter) {
        Objects.requireNonNull(state, "state");
        return FormatterStep.createLazy(name, () -> state, stateToFormatter);
    }

    public static FormatterStep createNeverUpToDateLazy(String name, ThrowingEx.Supplier<FormatterFunc> functionSupplier) {
        return new FormatterStepImpl.NeverUpToDate(name, functionSupplier);
    }

    public static FormatterStep createNeverUpToDate(String name, FormatterFunc function) {
        Objects.requireNonNull(function, "function");
        return FormatterStep.createNeverUpToDateLazy(name, () -> function);
    }

    public static abstract class Strict<State extends Serializable>
    extends LazyForwardingEquality<State>
    implements FormatterStep {
        private static final long serialVersionUID = 1L;

        protected abstract String format(State var1, String var2, File var3) throws Throwable;

        @Override
        public final String format(String rawUnix, File file) throws Throwable {
            return this.format(this.state(), rawUnix, file);
        }
    }
}

