/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle;

import com.github.autostyle.LibPreconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class MoreIterables {
    private MoreIterables() {
    }

    static <T> List<T> toNullHostileList(Iterable<T> input) {
        LibPreconditions.requireElementsNonNull(input);
        ArrayList shallowCopy = input instanceof Collection ? new ArrayList(((Collection)input).size()) : new ArrayList();
        input.forEach(shallowCopy::add);
        return shallowCopy;
    }

    static <T extends Comparable<T>> List<T> toSortedSet(Iterable<T> raw) {
        List<T> toBeSorted = MoreIterables.toNullHostileList(raw);
        Collections.sort(toBeSorted);
        if (toBeSorted.size() > 1) {
            Iterator<T> iter = toBeSorted.iterator();
            Comparable last = (Comparable)iter.next();
            while (iter.hasNext()) {
                Comparable next = (Comparable)iter.next();
                if (next.compareTo(last) == 0) {
                    iter.remove();
                    continue;
                }
                last = next;
            }
        }
        return toBeSorted;
    }
}

