/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle;

import com.github.autostyle.MoreIterables;
import com.github.autostyle.NoLambda;
import com.github.autostyle.SerializableFileFilter;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

class SerializableFileFilterImpl {
    SerializableFileFilterImpl() {
    }

    static class SkipFilesNamed
    extends NoLambda.EqualityBasedOnSerialization
    implements SerializableFileFilter {
        private static final long serialVersionUID = 1L;
        private final String[] namesToSkip;

        SkipFilesNamed(String ... namesToSkip) {
            Objects.requireNonNull(namesToSkip);
            List<String> sorted = MoreIterables.toSortedSet(Arrays.asList(namesToSkip));
            this.namesToSkip = sorted.toArray(new String[sorted.size()]);
        }

        @Override
        public boolean accept(File pathname) {
            String name = pathname.getName();
            return Arrays.stream(this.namesToSkip).noneMatch(name::equals);
        }
    }
}

