/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle;

public final class ThrowingEx {
    private ThrowingEx() {
    }

    public static void run(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            throw ThrowingEx.asRuntime(t);
        }
    }

    public static <T> T get(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            throw ThrowingEx.asRuntime(t);
        }
    }

    public static <T, R> java.util.function.Function<T, R> wrap(Function<T, R> function) {
        return input -> {
            try {
                return function.apply(input);
            }
            catch (Throwable t) {
                throw ThrowingEx.asRuntime(t);
            }
        };
    }

    public static RuntimeException asRuntime(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new WrappedAsRuntimeException(e);
    }

    public static RuntimeException unwrapCause(Throwable e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            return ThrowingEx.asRuntimeRethrowError(e);
        }
        return ThrowingEx.asRuntimeRethrowError(cause);
    }

    static RuntimeException asRuntimeRethrowError(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new WrappedAsRuntimeException(e);
    }

    public static class WrappedAsRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = -912202209702586994L;

        public WrappedAsRuntimeException(Throwable e) {
            super(e);
        }
    }

    @FunctionalInterface
    public static interface Runnable {
        public void run() throws Throwable;
    }

    @FunctionalInterface
    public static interface Supplier<T> {
        public T get() throws Throwable;
    }

    @FunctionalInterface
    public static interface BiFunction<T1, T2, R> {
        public R apply(T1 var1, T2 var2) throws Throwable;
    }

    @FunctionalInterface
    public static interface Function<T, R> {
        public R apply(T var1) throws Throwable;
    }
}

