/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.generic;

import com.github.autostyle.FormatterStep;
import com.github.autostyle.generic.CopyrightStyle;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/github/autostyle/generic/ImprovedLicenseHeaderStep;", "Lcom/github/autostyle/FormatterStep;", "copyright", "", "extraNewline", "", "styles", "", "Lcom/github/autostyle/generic/CopyrightStyle;", "(Ljava/lang/String;ZLjava/util/Map;)V", "getCopyright", "()Ljava/lang/String;", "getExtraNewline", "()Z", "formatted", "", "getStyles", "()Ljava/util/Map;", "format", "rawUnix", "file", "Ljava/io/File;", "getName", "autostyle-lib"})
public final class ImprovedLicenseHeaderStep
implements FormatterStep {
    private final transient Map<CopyrightStyle, String> formatted;
    @NotNull
    private final String copyright;
    private final boolean extraNewline;
    @NotNull
    private final Map<String, CopyrightStyle> styles;

    @Override
    @NotNull
    public String getName() {
        return "licenseHeader";
    }

    @Override
    @Nullable
    public String format(@NotNull String rawUnix, @NotNull File file) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)rawUnix, (String)"rawUnix");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        CopyrightStyle copyrightStyle = this.styles.get(FilesKt.getExtension((File)file));
        if (copyrightStyle == null) {
            copyrightStyle = this.styles.get("");
        }
        if (copyrightStyle == null) {
            return null;
        }
        CopyrightStyle style = copyrightStyle;
        Map<CopyrightStyle, String> $this$getOrPut$iv = this.formatted;
        boolean $i$f$getOrPut = false;
        String value$iv = $this$getOrPut$iv.get(style);
        if (value$iv == null) {
            boolean bl = false;
            String string2 = style.getLicenseFormatter().apply(this.copyright);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"style.licenseFormatter.apply(copyright)");
            String v = Regex.Companion.escapeReplacement(string2);
            String answer$iv = this.extraNewline ? v + "\n\n" : v + '\n';
            $this$getOrPut$iv.put(style, answer$iv);
            string = answer$iv;
        } else {
            string = value$iv;
        }
        String newCopyright = string;
        return style.getReplacer().replace(rawUnix, newCopyright);
    }

    @NotNull
    public final String getCopyright() {
        return this.copyright;
    }

    public final boolean getExtraNewline() {
        return this.extraNewline;
    }

    @NotNull
    public final Map<String, CopyrightStyle> getStyles() {
        return this.styles;
    }

    public ImprovedLicenseHeaderStep(@NotNull String copyright, boolean extraNewline, @NotNull Map<String, ? extends CopyrightStyle> styles) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)copyright, (String)"copyright");
        Intrinsics.checkParameterIsNotNull(styles, (String)"styles");
        this.copyright = copyright;
        this.extraNewline = extraNewline;
        this.styles = styles;
        ImprovedLicenseHeaderStep improvedLicenseHeaderStep = this;
        boolean bl = false;
        improvedLicenseHeaderStep.formatted = map = (Map)new LinkedHashMap();
    }
}

