/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.generic;

import com.github.autostyle.FormatterFunc;
import com.github.autostyle.FormatterStep;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Pattern;

public final class ReplaceRegexStep {
    private ReplaceRegexStep() {
    }

    public static FormatterStep create(String name, String regex, String replacement) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(regex, "regex");
        Objects.requireNonNull(replacement, "replacement");
        return FormatterStep.createLazy(name, () -> new State(Pattern.compile(regex, 9), replacement), State::toFormatter);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Pattern regex;
        private final String replacement;

        State(Pattern regex, String replacement) {
            this.regex = regex;
            this.replacement = replacement;
        }

        FormatterFunc toFormatter() {
            return raw -> this.regex.matcher((CharSequence)raw).replaceAll(this.replacement);
        }
    }
}

