/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.java;

import com.github.autostyle.FormatterFunc;
import com.github.autostyle.FormatterStep;
import com.github.autostyle.java.ImportSorter;
import com.github.autostyle.java.LibJavaPreconditions;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ImportOrderStep {
    private final String lineFormat;

    public static ImportOrderStep forGroovy() {
        return new ImportOrderStep("import %s");
    }

    public static ImportOrderStep forJava() {
        return new ImportOrderStep("import %s;");
    }

    private ImportOrderStep(String lineFormat) {
        this.lineFormat = lineFormat;
    }

    public FormatterStep createFrom(String ... importOrder) {
        List<String> importOrderList = LibJavaPreconditions.requireElementsNonNull(Arrays.asList(importOrder));
        return this.createFrom(() -> importOrderList);
    }

    private FormatterStep createFrom(Supplier<List<String>> importOrder) {
        return FormatterStep.createLazy("importOrder", () -> new State((List)importOrder.get(), this.lineFormat), State::toFormatter);
    }

    @Deprecated
    public static FormatterStep createFromOrder(List<String> importOrder) {
        List importOrderCopy = LibJavaPreconditions.requireElementsNonNull(new ArrayList<String>(importOrder));
        return ImportOrderStep.forJava().createFrom(() -> importOrderCopy);
    }

    @Deprecated
    public static FormatterStep createFromOrder(String ... importOrder) {
        return ImportOrderStep.forJava().createFrom(importOrder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> getImportOrder(File importsFile) {
        try (Stream<String> lines = Files.lines(importsFile.toPath());){
            List list = lines.filter(line -> !line.startsWith("#")).map(ImportOrderStep::splitIntoIndexAndName).sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toCollection(ArrayList::new));
            return list;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Map.Entry<Integer, String> splitIntoIndexAndName(String line) {
        String[] pieces = line.split("=");
        Integer index = Integer.valueOf(pieces[0]);
        String name = pieces.length == 2 ? pieces[1] : "";
        return new AbstractMap.SimpleImmutableEntry<Integer, String>(index, name);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<String> importOrder;
        private final String lineFormat;

        State(List<String> importOrder, String lineFormat) {
            this.importOrder = importOrder;
            this.lineFormat = lineFormat;
        }

        FormatterFunc toFormatter() {
            return raw -> new ImportSorter(this.importOrder).format((String)raw, this.lineFormat);
        }
    }
}

