/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.markdown;

import com.github.autostyle.FormatterFunc;
import com.github.autostyle.FormatterStep;
import com.github.autostyle.JarState;
import com.github.autostyle.Provisioner;
import com.github.autostyle.ThrowingEx;
import com.github.autostyle.markdown.LibMarkdownPreconditions;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class FreshMarkStep {
    private static final String DEFAULT_VERSION = "1.3.1";
    private static final String NAME = "freshmark";
    private static final String MAVEN_COORDINATE = "com.diffplug.freshmark:freshmark:";
    private static final String FORMATTER_CLASS = "com.diffplug.freshmark.FreshMark";
    private static final String FORMATTER_METHOD = "compile";

    private FreshMarkStep() {
    }

    public static FormatterStep create(Provisioner provisioner, ThrowingEx.Supplier<Map<String, ?>> properties) {
        return FreshMarkStep.create(FreshMarkStep.defaultVersion(), properties, provisioner);
    }

    public static FormatterStep create(String version, ThrowingEx.Supplier<Map<String, ?>> properties, Provisioner provisioner) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.createLazy(NAME, () -> new State(JarState.from(MAVEN_COORDINATE + version, provisioner), (Map)properties.get()), State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    private static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final JarState jarState;
        final NavigableMap<String, ?> properties;

        State(JarState jarState, Map<String, ?> properties) {
            this.jarState = jarState;
            this.properties = new TreeMap(properties);
            LibMarkdownPreconditions.requireKeysAndValuesNonNull(this.properties);
        }

        FormatterFunc createFormat() throws Exception {
            Logger logger = Logger.getLogger(FreshMarkStep.class.getName());
            Consumer<String> loggingStream = logger::warning;
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterClazz = classLoader.loadClass(FreshMarkStep.FORMATTER_CLASS);
            Object formatter = formatterClazz.getConstructor(Map.class, Consumer.class).newInstance(this.properties, loggingStream);
            Method method = formatterClazz.getMethod(FreshMarkStep.FORMATTER_METHOD, String.class);
            return input -> {
                try {
                    return (String)method.invoke(formatter, input);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            };
        }
    }
}

