/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.npm;

import java.util.Locale;
import java.util.Objects;

class PlatformInfo {
    private PlatformInfo() {
    }

    static OS normalizedOS() {
        String osNameProperty = System.getProperty("os.name");
        if (osNameProperty == null) {
            throw new RuntimeException("No info about OS available, cannot decide which implementation of j2v8 to use");
        }
        String normalizedOsName = osNameProperty.toLowerCase(Locale.ROOT);
        if (normalizedOsName.contains("win")) {
            return OS.WINDOWS;
        }
        if (normalizedOsName.contains("mac")) {
            return OS.MACOS;
        }
        if (normalizedOsName.contains("nix") || normalizedOsName.contains("nux") || normalizedOsName.contains("aix")) {
            return OS.LINUX;
        }
        throw new RuntimeException("Cannot handle os " + osNameProperty);
    }

    static String normalizedOSName() {
        return PlatformInfo.normalizedOS().normalizedOsName();
    }

    static String normalizedArchName() {
        String osArchProperty = System.getProperty("os.arch");
        if (osArchProperty == null) {
            throw new RuntimeException("No info about ARCH available, cannot decide which implementation of j2v8 to use");
        }
        String normalizedOsArch = osArchProperty.toLowerCase(Locale.ROOT);
        if (normalizedOsArch.contains("64")) {
            return "x86_64";
        }
        if (normalizedOsArch.contains("x86") || normalizedOsArch.contains("32")) {
            return "x86";
        }
        throw new RuntimeException("Cannot handle arch " + osArchProperty);
    }

    static enum OS {
        WINDOWS("win32"),
        MACOS("macosx"),
        LINUX("linux");

        private final String normalizedOsName;

        private OS(String normalizedOsName) {
            this.normalizedOsName = Objects.requireNonNull(normalizedOsName);
        }

        public String normalizedOsName() {
            return this.normalizedOsName;
        }
    }
}

