/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.npm;

import com.github.autostyle.FileSignature;
import com.github.autostyle.ThrowingEx;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class PrettierConfig
implements Serializable {
    private static final long serialVersionUID = -8709340269833126583L;
    @Nullable
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private final transient File prettierConfigPath;
    private final FileSignature prettierConfigPathSignature;
    private final TreeMap<String, Object> options;

    public PrettierConfig(@Nullable File prettierConfigPath, @Nullable Map<String, Object> options) {
        try {
            this.prettierConfigPath = prettierConfigPath;
            this.prettierConfigPathSignature = prettierConfigPath != null ? FileSignature.signAsList(this.prettierConfigPath) : FileSignature.signAsList(new File[0]);
            this.options = options == null ? new TreeMap() : new TreeMap<String, Object>(options);
        }
        catch (IOException e) {
            throw ThrowingEx.asRuntime(e);
        }
    }

    @Nullable
    public File getPrettierConfigPath() {
        return this.prettierConfigPath;
    }

    public Map<String, Object> getOptions() {
        return new TreeMap<String, Object>((SortedMap<String, Object>)this.options);
    }
}

