/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.npm;

import com.github.autostyle.npm.Reflective;
import java.util.Objects;
import java.util.function.Function;

abstract class ReflectiveObjectWrapper
implements AutoCloseable {
    private final Object wrappedObj;
    private final Reflective reflective;

    public ReflectiveObjectWrapper(Reflective reflective, Object wrappedObj) {
        this.reflective = Objects.requireNonNull(reflective);
        this.wrappedObj = Objects.requireNonNull(wrappedObj);
    }

    public ReflectiveObjectWrapper(Reflective reflective, Function<Reflective, Object> wrappedObjSupplier) {
        this(reflective, wrappedObjSupplier.apply(reflective));
    }

    protected Reflective reflective() {
        return this.reflective;
    }

    protected Object wrappedObj() {
        return this.wrappedObj;
    }

    protected Object invoke(String methodName, Object ... parameters) {
        return this.reflective().invokeMethod(this.wrappedObj(), methodName, parameters);
    }

    protected Object invoke(String methodName, Reflective.TypedValue ... parameters) {
        return this.reflective().invokeMethod(this.wrappedObj(), methodName, parameters);
    }

    public void release() {
        this.invoke("release", new Reflective.TypedValue[0]);
    }

    @Override
    public void close() throws Exception {
        this.release();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReflectiveObjectWrapper)) {
            return false;
        }
        ReflectiveObjectWrapper that = (ReflectiveObjectWrapper)o;
        return Objects.equals(this.wrappedObj, that.wrappedObj) && Objects.equals(this.getClass(), that.getClass());
    }

    public int hashCode() {
        return Objects.hash(this.wrappedObj, this.getClass());
    }
}

