/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.npm;

import com.github.autostyle.FileSignature;
import com.github.autostyle.ThrowingEx;
import com.github.autostyle.npm.TsConfigFileType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;

public class TypedTsFmtConfigFile
implements Serializable {
    private static final long serialVersionUID = -4442310349275775501L;
    private final TsConfigFileType configFileType;
    private final File configFile;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private final FileSignature configFileSignature;

    public TypedTsFmtConfigFile(TsConfigFileType configFileType, File configFile) {
        this.configFileType = Objects.requireNonNull(configFileType);
        this.configFile = Objects.requireNonNull(configFile);
        try {
            this.configFileSignature = FileSignature.signAsList(configFile);
        }
        catch (IOException e) {
            throw ThrowingEx.asRuntime(e);
        }
    }

    TsConfigFileType configFileType() {
        return this.configFileType;
    }

    File configFile() {
        return this.configFile;
    }

    String configFileEnabledOptionName() {
        return this.configFileType.name().toLowerCase(Locale.ROOT);
    }

    String configFileOptionName() {
        return this.configFileEnabledOptionName() + "File";
    }

    String absolutePath() {
        return this.configFile.getAbsolutePath();
    }

    static TypedTsFmtConfigFile named(String name, File file) {
        return new TypedTsFmtConfigFile(TsConfigFileType.forNameIgnoreCase(name), file);
    }
}

