/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.npm;

import com.github.autostyle.npm.Reflective;
import com.github.autostyle.npm.ReflectiveObjectWrapper;
import com.github.autostyle.npm.V8ArrayWrapper;
import com.github.autostyle.npm.V8ObjectWrapper;
import java.lang.reflect.Method;

class V8FunctionWrapper
extends ReflectiveObjectWrapper {
    public static final String WRAPPED_CLASS = "com.eclipsesource.v8.V8Function";
    public static final String CALLBACK_WRAPPED_CLASS = "com.eclipsesource.v8.JavaCallback";

    public V8FunctionWrapper(Reflective reflective, Object v8Function) {
        super(reflective, v8Function);
    }

    public static Object proxiedCallback(WrappedJavaCallback callback, Reflective reflective) {
        Object proxy = reflective.createDynamicProxy((proxyInstance, method, args) -> {
            if (V8FunctionWrapper.isCallbackFunction(reflective, method, args)) {
                V8ObjectWrapper receiver = new V8ObjectWrapper(reflective, args[0]);
                V8ArrayWrapper parameters = new V8ArrayWrapper(reflective, args[1]);
                return callback.invoke(receiver, parameters);
            }
            return null;
        }, CALLBACK_WRAPPED_CLASS);
        return reflective.clazz(CALLBACK_WRAPPED_CLASS).cast(proxy);
    }

    private static boolean isCallbackFunction(Reflective reflective, Method method, Object[] args) {
        if (!"invoke".equals(method.getName())) {
            return false;
        }
        Class<?>[] types = reflective.types(args);
        if (types.length != 2) {
            return false;
        }
        return "com.eclipsesource.v8.V8Object".equals(types[0].getName()) && "com.eclipsesource.v8.V8Array".equals(types[1].getName());
    }

    @FunctionalInterface
    public static interface WrappedJavaCallback {
        public Object invoke(V8ObjectWrapper var1, V8ArrayWrapper var2);
    }
}

