/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.npm;

import com.github.autostyle.npm.Reflective;
import com.github.autostyle.npm.ReflectiveObjectWrapper;
import com.github.autostyle.npm.V8ArrayWrapper;
import java.util.Optional;

class V8ObjectWrapper
extends ReflectiveObjectWrapper {
    public static final String WRAPPED_CLASS = "com.eclipsesource.v8.V8Object";

    public V8ObjectWrapper(Reflective reflective, Object v8Object) {
        super(reflective, v8Object);
    }

    public V8ObjectWrapper add(String name, Object value) {
        this.invoke("add", name, value);
        return this;
    }

    public void executeVoidFunction(String functionName, V8ArrayWrapper params) {
        this.invoke("executeVoidFunction", functionName, params.wrappedObj());
    }

    public V8ObjectWrapper executeObjectFunction(String functionName, V8ArrayWrapper params) {
        Object returnV8Obj = this.invoke("executeObjectFunction", functionName, params.wrappedObj());
        return new V8ObjectWrapper(this.reflective(), returnV8Obj);
    }

    public String executeStringFunction(String functionName, V8ArrayWrapper params) {
        String returnValue = (String)this.invoke("executeStringFunction", functionName, params.wrappedObj());
        return returnValue;
    }

    public String getString(String name) {
        return (String)this.invoke("getString", name);
    }

    public Optional<String> getOptionalString(String name) {
        String result = null;
        try {
            result = this.getString(name);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return Optional.ofNullable(result);
    }

    public boolean getBoolean(String name) {
        return (Boolean)this.invoke("getBoolean", name);
    }

    public Optional<Boolean> getOptionalBoolean(String name) {
        Boolean result = null;
        try {
            result = this.getBoolean(name);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return Optional.ofNullable(result);
    }

    public int getInteger(String name) {
        return (Integer)this.invoke("getInteger", name);
    }

    public Optional<Integer> getOptionalInteger(String name) {
        Integer result = null;
        try {
            result = this.getInteger(name);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return Optional.ofNullable(result);
    }
}

